/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;

public class MxBPVTyphoonServerEnclosure
extends MxBPVServerEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVTyphoonServerEnclosure.class);
    private final int numSlots = 10;
    private final int firstSlotNumber = 0;

    public MxBPVTyphoonServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getNumSlots() {
        return 10;
    }

    public int getFirstSlotNumber() {
        return 0;
    }

    public void populateAll() throws Exception {
        LOGGER.enter("MxBPVTyphoonServerEnclosure.populateAll()");
        LOGGER.fine("Enclosure Name:" + this.node.getNameString());
        LOGGER.fine("Collecting latest data for the enclosure.");
        this.m_BladeEnclosure = ILOHelper.getILOHelper().refreshBladeEnclosure(this.node);
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.setSize(this.getFirstSlotNumber() + this.getNumSlots());
        int slotNumber = this.getFirstSlotNumber();
        LOGGER.fine("Total Number of slots that we will run in a loop:" + this.getFirstSlotNumber() + this.getNumSlots());
        while (slotNumber < this.getFirstSlotNumber() + this.getNumSlots()) {
            LOGGER.fine("Current slotNumber/loop:" + slotNumber);
            if (slotNumber == this.getFirstSlotNumber() || slotNumber == this.getFirstSlotNumber() + this.getNumSlots() - 1) {
                LOGGER.fine("This is switch slot.:" + slotNumber);
                int pseudoSlot = slotNumber == 0 ? 0 : 9999;
                ArrayList elementList = this.getElementsForSlot(nodeClient, nodeAssociations, pseudoSlot);
                LOGGER.fine("The number of devices @ slot number :" + slotNumber + "is:" + elementList.size());
                boolean isDukesSwitch = false;
                if (elementList.size() > 0) {
                    LOGGER.fine("Switch present at slotnumber:" + slotNumber);
                    for (int i = 0; i < elementList.size(); ++i) {
                        MxBPVElement element = (MxBPVElement)elementList.get(i);
                        LOGGER.fine("Switch Name @ index :" + i + ":" + element.getName());
                        if (!(element instanceof MxBPVSwitch)) continue;
                        String dukesSwitch = element.getNode().getClientAttribute("LOCATION");
                        if (dukesSwitch != null && dukesSwitch.equalsIgnoreCase("RearUpperCube")) {
                            isDukesSwitch = true;
                            LOGGER.fine("Dukes switch present:" + element.getName() + "@ slot :" + element.getSlotNumber());
                            MxBPVElement parentElement = element.getParent();
                            if (parentElement != null) {
                                ++parentElement.numDukesSwitches;
                                if (element.getSlotNumber() == 0) {
                                    parentElement.setDukesSlotNumbers(0);
                                } else {
                                    parentElement.setDukesSlotNumbers(1);
                                }
                            }
                        }
                        this.setSlotNumber(pseudoSlot);
                        LOGGER.fine("pseudoSlot:" + pseudoSlot);
                        LOGGER.fine("getSlotNumber():" + this.getSlotNumber());
                        this.set(slotNumber, element);
                        LOGGER.fine("DUKES_ATTRIBUTE:" + dukesSwitch + "SlotNumber:" + slotNumber);
                    }
                } else {
                    LOGGER.fine("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    LOGGER.fine("pseudoSlot:" + pseudoSlot);
                    LOGGER.fine("getSlotNumber():" + this.getSlotNumber());
                    this.set(slotNumber, emptySlot);
                }
                if (isDukesSwitch && elementList.size() == 1) {
                    LOGGER.fine("Empty Switch slot.");
                    MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(true, pseudoSlot, 1, 2);
                    this.setSlotNumber(pseudoSlot);
                    this.set(slotNumber, emptySlot);
                }
                ++slotNumber;
                continue;
            }
            MxBPVElement top = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber);
            MxBPVElement bottom = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber + 8);
            if (top != null && bottom != null) {
                LOGGER.fine("Top Blade  Name:" + top.getName());
                LOGGER.fine("Bottom Blade  Name:" + bottom.getName());
                this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                ++slotNumber;
                continue;
            }
            if (top != null && bottom == null) {
                LOGGER.fine("Top Blade  Name:" + top.getName());
                if (top.getNumSlotsUsedYDir() == 1) {
                    bottom = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                } else {
                    this.set(slotNumber, top);
                }
                slotNumber += top.getNumSlotsUsedXDir();
                continue;
            }
            if (top == null && bottom != null) {
                LOGGER.fine("Bottom Blade  Name:" + bottom.getName());
                top = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                ++slotNumber;
                continue;
            }
            LOGGER.fine("Both are null create a full height empty slot.");
            MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(false, slotNumber, 1, 2);
            this.set(slotNumber, emptySlot);
            ++slotNumber;
        }
    }
}

