/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.events;

import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObjectFactory;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.events.EventException;
import com.hp.mx.portal.events.EventManager;
import com.hp.mx.portal.events.Events;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public class EnclEventsBean {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EnclEventsBean.class);
    private CriteriaDataObjectFactory criteriaFactory;
    private MxQueryClient queryClient;
    private EventManager eventManager;
    private String[] deviceNames;
    private String deviceType = "Enclosure";
    private boolean containsCClass = false;

    public void init(String[] enclNames, MxLoginBean loginBean, boolean containsCClass) throws EventException {
        LOGGER.enter("EventsBean.init(" + enclNames + "," + loginBean + ")");
        this.queryClient = loginBean.getQueryClient();
        try {
            this.criteriaFactory = this.queryClient.getCriteriaFactory();
        }
        catch (MxException e) {
            LOGGER.error("EventsBean.init.Unable to get criteriaFactory object " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
            throw new EventException(e, "Unable to get criteria factory object");
        }
        this.deviceNames = enclNames;
        this.eventManager = EventManager.getEventManager();
        this.containsCClass = containsCClass;
        LOGGER.fine("EventsBean.init.deviceType " + this.deviceType);
        LOGGER.exit("EventsBean.init(" + enclNames + "," + loginBean + ")");
    }

    public String[][] getBPVEventsList(MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.getBPVEventsList(" + loginBean + ")");
        String[][] bpvEventCatagories = MonteroResourceManager.getInstance().getBPVEventsCategories(loginBean.getLocale());
        if (this.containsCClass) {
            bpvEventCatagories = MonteroResourceManager.getInstance().getBPVOverlordEventsCategories(loginBean.getLocale());
        }
        LOGGER.fine("EventsBean.getBPVEventsQueryIdList.bpvEventCatagories " + bpvEventCatagories);
        if (bpvEventCatagories == null) {
            throw new EventException("Unable to get events list for BPV");
        }
        LOGGER.exit("EventsBean.getBPVEventsList(" + loginBean + ")");
        return bpvEventCatagories;
    }

    public String getQueryId(String eventType, MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.getQueryId(" + eventType + "," + loginBean + ")");
        Events eventsObj = this.eventManager.getEventInstance(eventType);
        LOGGER.fine("EventsBean.getQueryId eventsObj class name " + eventsObj.getClass().getName());
        Vector<Object> criteriaVector = eventsObj.getCriteriaList(this.criteriaFactory, this.deviceType, this.deviceNames);
        LOGGER.exit("EventsBean.getQueryId(" + eventType + "," + loginBean + ")");
        return String.valueOf(this.getBPVEventQueryId(criteriaVector, this.queryClient, eventsObj.getEventString(), loginBean));
    }

    private int getBPVEventQueryId(Vector criteriaVector, MxQueryClient queryClient, String queryString, MxLoginBean loginBean) throws EventException {
        LOGGER.enter("EventsBean.getBPVEventQueryId(" + criteriaVector + "," + queryClient + "," + queryString + "," + loginBean);
        int queryId = 0;
        Query query = null;
        try {
            query = queryClient.getQuery(this.deviceNames.hashCode() + queryString);
        }
        catch (MxException e) {
            // empty catch block
        }
        LOGGER.fine("EventsBean.getBPVEventQueryId.query " + query);
        if (query != null) {
            queryId = query.getQueryId();
        } else {
            try {
                query = new Query(this.deviceNames.hashCode() + queryString, "EventViews", criteriaVector);
                query.setDynamic(true);
                queryId = queryClient.addQuery(query, loginBean.getLocale());
            }
            catch (MxException e) {
                LOGGER.error("EventsBean.getBPVEventQueryId.Unable to create new query " + (Object)((Object)e));
                LOGGER.exception((Throwable)e);
                throw new EventException(e, "Unable to get new query ID " + (Object)((Object)e));
            }
        }
        LOGGER.fine("EventsBean.getBPVEventQueryId.queryId " + queryId);
        LOGGER.exit("EventsBean.getBPVEventQueryId(" + criteriaVector + "," + queryClient + "," + queryString + "," + loginBean);
        return queryId;
    }
}

