/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.events;

import com.hp.mx.portal.events.EventException;
import com.hp.mx.portal.events.Events;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Properties;

class EventManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EventManager.class);
    private Properties m_eventClasses = null;
    private final String EVENTS_PKG = "com.hp.mx.portal.events.";
    private static EventManager eventManager = null;

    private EventManager() {
    }

    static EventManager getEventManager() {
        if (eventManager == null) {
            eventManager = new EventManager();
        }
        return eventManager;
    }

    Events getEventInstance(String eventType) throws EventException {
        LOGGER.enter("EventManager.getEventInstance(" + eventType + ")");
        LOGGER.fine("EventManager.getEventInstance.m_eventClasses " + this.m_eventClasses);
        if (null == eventType || null != eventType && eventType.trim().length() == 0) {
            return null;
        }
        if (this.m_eventClasses == null) {
            this.m_eventClasses = new Properties();
        }
        Events eventsObj = (Events)this.m_eventClasses.get(eventType);
        LOGGER.fine("EventManager.getEventInstance.eventsObj " + eventsObj);
        if (eventsObj == null) {
            try {
                eventsObj = (Events)Class.forName("com.hp.mx.portal.events." + eventType).newInstance();
                this.m_eventClasses.put(eventType, eventsObj);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("EventManager.ClassNotFoundException " + cnfe);
                LOGGER.exception((Throwable)cnfe);
                throw new EventException(cnfe, "Unable to get event instance object");
            }
            catch (InstantiationException ie) {
                LOGGER.error("EventManager.InstantiationException " + ie);
                LOGGER.exception((Throwable)ie);
                throw new EventException(ie, "Unable to get event instance object");
            }
            catch (IllegalAccessException iae) {
                LOGGER.error("EventManager.IllegalAccessException " + iae);
                LOGGER.exception((Throwable)iae);
                throw new EventException(iae, "Unable to get event instance object");
            }
        }
        LOGGER.fine("EventManager.getEventInstance.eventsObj " + eventsObj);
        LOGGER.exit("EventManager.getEventInstance(" + eventType + ")");
        return eventsObj;
    }
}

