/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.i18n;

import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MonteroResourceManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroResourceManager.class);
    private static HashMap<String, ResourceBundle> inMemResourceBundles = new HashMap();
    private static MonteroResourceManager m_montResMgr = new MonteroResourceManager();
    private String[][] fanAndThermal = new String[][]{{"Unknown", "Unknown", "Unknown", "Unknown", "Unknown"}, {"Unknown", "Normal", "Ok", "Non_Hot_Pluggable", "Not_Available"}, {"System", "High", "Degraded", "Hot_Pluggable", "Not_Available"}, {"SystemBoard", "Not_Available", "Failed", "Not_Available", "Not_Available"}, {"IOBoard", "Not_Available", "Not_Available", "Not_Available", "BlowOut"}, {"CPU", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"Memory", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"Storage", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"RemovableMedia", "Not_Available", "Not_Available", "Not_Available", "Caution"}, {"PowerSupply", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"Ambient", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"Chassis", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"BridgeCard", "Not_Available", "Not_Available", "Not_Available", "Not_Available"}, {"Not_Available", "Not_Available", "Not_Available", "Not_Available", "Critical"}};

    private MonteroResourceManager() {
    }

    public static MonteroResourceManager getInstance() {
        return m_montResMgr;
    }

    public String[] getPwrSupplyTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPwrSupplyTableHeaders(" + locale + ")");
        String[] pwrSupplyTableHeaders = new String[]{"Bay", "SerialNumber", "Firmware_Rev", "Max_Output_(W)", "Current_Output_(W)", "Available_Power_(W)", "Entry_AirFlow_Temp_(C)", "Exit_AirFlow_Temp_(C)"};
        return this.localize1DArray(pwrSupplyTableHeaders, locale);
    }

    public String[] getCpuUtilTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPwrSupplyTableHeaders(" + locale + ")");
        String[] cpuUtilTableHeaders = new String[]{"Index", "Type", "Utilization_(%)"};
        return this.localize1DArray(cpuUtilTableHeaders, locale);
    }

    public String[] getDiskInfoTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPwrSupplyTableHeaders(" + locale + ")");
        String[] diskInfoTableHeaders = new String[]{"Name", "Size_(MB)", "Usage_(%)"};
        return this.localize1DArray(diskInfoTableHeaders, locale);
    }

    public String[] getmainMemInfoTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPwrSupplyTableHeaders(" + locale + ")");
        String[] mainMemInfoTableHeaders = new String[]{"Size_(MB)", "Free_(MB)", "Paging_Size_(MB)", "Paging_Free_(MB)"};
        return this.localize1DArray(mainMemInfoTableHeaders, locale);
    }

    public String[][] getPMPTools(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPMPTools(" + locale + ")");
        String[] pmpLeft = new String[]{"Configuration...", "Manual Log Purge...", "Online Analysis...", "Offline Analysis...", "Static Analysis Report...", "System Summary Report...", "CSV File Generator...", "For HP Performance Management Pack..."};
        String[] pmpRight = new String[]{"Configuration", "Manual_Log_Purge", "Online_Analysis", "Offline_Analysis", "Static_Analysis_Report", "System_Summary_Report", "CSV_File_Generator", "For_HP_Performance_Management_Pack"};
        String[][] pmpTools = new String[pmpLeft.length][2];
        for (int i = 0; i < pmpTools.length; ++i) {
            pmpTools[i][0] = pmpLeft[i];
            pmpTools[i][1] = this.localizedString(pmpRight[i], locale);
        }
        return pmpTools;
    }

    public String[][] getPRPTools(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getAMTools(" + locale + ")");
        String[] prpLeft = new String[]{"Initialize", "Provision", "Designate_Spare"};
        String[] prpRight = new String[]{"Servers", "Add_To_Collection", "Designate_Spare"};
        String[][] prpTools = new String[prpLeft.length][2];
        for (int i = 0; i < prpTools.length; ++i) {
            prpTools[i][0] = prpLeft[i];
            prpTools[i][1] = this.localizedString(prpRight[i], locale);
        }
        return prpTools;
    }

    public String[][] getBPVOverlordEventsCategories(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getBPVOverlordEventsCategories(" + locale + ")");
        String[] BPVEVENTSCATEGORIESLEFT = new String[]{"", "AllEvents", "AllEvents:Important Events", "AllEvents:Important Uncleared Events", "AllEvents:Informational Events", "", "AllEvents:All Login and Logout Events", "AllEvents:All Failed Login Events", "", "AllEvents:All HP Service Events", "", "AllEvents:Events older than 90 days", "", "OAEvents", "BladeEvents", "SwitchEvents"};
        String[] BPVEVENTSCATEGORIESRIGHT = new String[]{"Events_by_Severity", "All_Events", "Important_Events", "Important_Uncleared_Events", "Informational_Events", "Login_Events", "All_Login_and_Logout_Events", "All_Failed_Login_Events", "Service_Events", "All_HP_Service_Events", "Events_by_Time", "Events_older_than_90_days", "Events_by_Device", "All-Onboard_Administrator_Events", "All_Server_Events", "All_Switch_Events"};
        String[][] BPV_OVERLORD_EVENTS_CATEGORIES = new String[BPVEVENTSCATEGORIESLEFT.length][2];
        for (int i = 0; i < BPV_OVERLORD_EVENTS_CATEGORIES.length; ++i) {
            BPV_OVERLORD_EVENTS_CATEGORIES[i][0] = BPVEVENTSCATEGORIESLEFT[i];
            BPV_OVERLORD_EVENTS_CATEGORIES[i][1] = this.localizedString(BPVEVENTSCATEGORIESRIGHT[i], locale);
        }
        return BPV_OVERLORD_EVENTS_CATEGORIES;
    }

    public String[][] getBPVEventsCategories(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getBPVEventsCategories(" + locale + ")");
        String[] BPVEVENTSCATEGORIESLEFT = new String[]{"", "AllEvents", "AllEvents:Important Events", "AllEvents:Important Uncleared Events", "AllEvents:Informational Events", "", "AllEvents:All Login and Logout Events", "AllEvents:All Failed Login Events", "", "AllEvents:All HP Service Events", "", "AllEvents:Events older than 90 days", "", "BladeEvents", "SwitchEvents"};
        String[] BPVEVENTSCATEGORIESRIGHT = new String[]{"Events_by_Severity", "All_Events", "Important_Events", "Important_Uncleared_Events", "Informational_Events", "Login_Events", "All_Login_and_Logout_Events", "All_Failed_Login_Events", "Service_Events", "All_HP_Service_Events", "Events_by_Time", "Events_older_than_90_days", "Events_by_Device", "All_Server_Events", "All_Switch_Events"};
        String[][] BPV_EVENTS_CATEGORIES = new String[BPVEVENTSCATEGORIESLEFT.length][2];
        for (int i = 0; i < BPV_EVENTS_CATEGORIES.length; ++i) {
            BPV_EVENTS_CATEGORIES[i][0] = BPVEVENTSCATEGORIESLEFT[i];
            BPV_EVENTS_CATEGORIES[i][1] = this.localizedString(BPVEVENTSCATEGORIESRIGHT[i], locale);
        }
        return BPV_EVENTS_CATEGORIES;
    }

    public String getPMP_Msg(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getPMP_Msg(" + locale + ")");
        return this.getString("PMP_Msg", locale);
    }

    public String getString(String key, Locale locale) {
        LOGGER.enter("MonteroResourceManager.getString(" + key + ',' + locale + ')');
        ResourceBundle bundle = this.narrowResourceBundle(locale);
        String localeSpecific = bundle.getString("NOT_AVAILABLE");
        try {
            localeSpecific = bundle.getString(key);
        }
        catch (MissingResourceException missingRscExcep) {
            LOGGER.fine("MonteroResourceManager.getString(" + key + ',' + locale.getDisplayCountry() + ')' + ':' + missingRscExcep.getMessage());
        }
        LOGGER.exit("MonteroResourceManager.getString(" + key + ',' + locale + ')');
        return localeSpecific;
    }

    public ResourceBundle narrowResourceBundle(Locale locale) {
        LOGGER.enter("MonteroResourceManager.narrowResourceBundle(" + locale + ")");
        ResourceBundle x = inMemResourceBundles.get(locale.getLanguage());
        if (x == null) {
            try {
                x = ResourceBundle.getBundle("com.hp.mx.portal.i18n.MonteroResource", locale);
            }
            catch (MissingResourceException e) {
                LOGGER.fine("MonteroResourceManager.narrowResourceBundle(" + locale + ")" + "Locale not supported, " + locale + ". Loading default locale");
                x = ResourceBundle.getBundle("com.hp.mx.res.MonteroResource");
            }
            inMemResourceBundles.put(locale.getDisplayName(), x);
        }
        return x;
    }

    public String[] getFanTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getFanTableHeaders(" + locale + ")");
        String[] fanTableHeaders = new String[]{"Index", "Locale", "Redundant_Partner", "Speed", "Condition", "Hot_Plug"};
        return this.localize1DArray(fanTableHeaders, locale);
    }

    public String[] getTemperatureTableHeaders(Locale locale) {
        LOGGER.enter("MonteroResourceManager.getTemperatureTableHeaders(" + locale + ")");
        String[] temperatureTableHeaders = new String[]{"Index", "Locale", "Celsius(C)", "Threshold(C)", "Condition", "ThresholdType"};
        return this.localize1DArray(temperatureTableHeaders, locale);
    }

    public String getFanAndThermalValue(int row, int col, Locale locale) {
        LOGGER.enter("MonteroResourceManager.getFanAndThermalValue(" + row + "," + col + "," + locale + ")");
        String value = null;
        value = row < 0 || row >= this.fanAndThermal.length ? this.getString("NOT_AVAILABLE", locale) : this.getString(this.fanAndThermal[row][col], locale);
        LOGGER.exit("MonteroResourceManager.getFanAndThermalValue(" + row + "," + col + "," + locale + ")");
        return value;
    }

    protected String[] localize1DArray(String[] array, Locale locale) {
        ArrayList<String> localizedData = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            localizedData.add(this.getString(array[i], locale));
        }
        return localizedData.toArray(new String[localizedData.size()]);
    }

    protected String localizedString(String temp, Locale locale) {
        String localizedString = this.getString(temp, locale);
        return localizedString;
    }
}

