/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance;

import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.license.PMPLicense;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.UITable;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.jsp.JspWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilization {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(Utilization.class);
    private UITable m_cpuUITable;
    private UITable m_diskUITable;
    private UITable m_phyMemUITable;
    private UITable m_fanUITable;
    private UITable m_tempUITable;
    private String[] m_dskHeader;
    private String[] m_memHeader;
    private String[] m_cpuHeader;
    private String[] m_fanHeader;
    private String[] m_temperatureHeader;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private JspWriter m_out;
    private MxNode m_node;
    private boolean m_isUpdate;
    private boolean m_isLicensedPMP = false;
    MonteroResourceManager m_manager = MonteroResourceManager.getInstance();

    public void initialize(DeviceInfoBean deviceInfoBean, JspWriter out) {
        LOGGER.enter("Utilization.initialize(" + deviceInfoBean + ")");
        LOGGER.fine("Out object:" + out);
        LOGGER.fine("m_Out object:" + this.m_out);
        if (this.m_out != out) {
            this.m_out = out;
        }
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.m_cpuHeader = MonteroResourceManager.getInstance().getCpuUtilTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.m_dskHeader = MonteroResourceManager.getInstance().getDiskInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.m_memHeader = MonteroResourceManager.getInstance().getmainMemInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.m_fanHeader = MonteroResourceManager.getInstance().getFanTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.m_temperatureHeader = MonteroResourceManager.getInstance().getTemperatureTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
        }
        LOGGER.exit("Utilization.initialize(" + deviceInfoBean + ")");
    }

    private ArrayList getLogicalVolumeUtilizationTable() {
        LOGGER.enter("Utilization.getDiskUtilizationTable()");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> logicalVolUtilData = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.2", false);
        logicalVolUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.3", true));
        logicalVolUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.5", true));
        LOGGER.fine("Size Of diskUtilData:" + logicalVolUtilData.size());
        LOGGER.fine("End:Utilization.getDiskUtilizationTable()");
        LOGGER.exit("Utilization.getDiskUtilizationTable()");
        return logicalVolUtilData;
    }

    private void renderCPUUtilTable() {
        LOGGER.enter("Utilization.renderCPUUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
        LOGGER.fine("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            LOGGER.fine("Getting the latest data from SNMP for CPU Utililzation");
            MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
            this.m_cpuUITable = new UITable(MonteroResourceManager.getInstance().getString("PROCESSOR", this.m_monteroBean.getLoginBean().getLocale()), this.m_cpuHeader);
            ArrayList<String> tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.3.1.1.3", true);
            ArrayList<String> cpuName = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.1.2.2.1.1.3", false);
            ArrayList<String> cpuSpeed = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.1.2.2.1.1.4", true);
            LOGGER.fine("Size of CPU Util:" + tableList.size());
            LOGGER.fine("Size of CPU Name:" + tableList.size());
            LOGGER.fine("Size of CPU Speed:" + tableList.size());
            if (tableList.size() == 0 || cpuName.size() == 0 || cpuSpeed.size() == 0) {
                this.m_cpuUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_cpuHeader.length);
            } else {
                for (int i = 0; i < tableList.size(); ++i) {
                    this.m_cpuUITable.addRow(new String[]{i + "", cpuSpeed.get(0) + " " + MonteroResourceManager.getInstance().getString("cpu.abbreviation.mhz", this.m_monteroBean.getLoginBean().getLocale()) + " " + cpuName.get(0), tableList.get(i)});
                }
            }
            this.m_cpuUITable.terminateTable();
        }
        this.m_cpuUITable.displayTable(this.m_out);
        LOGGER.exit("Utilization.renderCPUUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
    }

    private void renderLogicalVolumeUtilTable() {
        LOGGER.enter("Utilization.renderDiskUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
        LOGGER.fine("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            LOGGER.fine("Getting the latest data from SNMP for Disk Utililzation");
            this.m_diskUITable = new UITable(MonteroResourceManager.getInstance().getString("LOGICALDISK", this.m_monteroBean.getLoginBean().getLocale()), this.m_dskHeader);
            String numDrivesStr = this.m_deviceInfoBean.getNumberLogicalDrives() + "";
            int numDrives = Integer.parseInt(numDrivesStr);
            LOGGER.fine("numDrives:" + numDrives);
            if (numDrives <= 0) {
                this.m_diskUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_dskHeader.length);
            } else {
                ArrayList tableList = this.getLogicalVolumeUtilizationTable();
                LOGGER.fine("tableList:" + tableList.size());
                if (tableList.size() == 0) {
                    this.m_diskUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_memHeader.length);
                } else {
                    numDrives = tableList.size() / 3;
                    LOGGER.fine("numDrives:" + numDrives);
                    for (int i = 0; i < numDrives; ++i) {
                        this.m_diskUITable.addRow(new String[]{(String)tableList.get(i), (String)tableList.get(i + numDrives), (String)tableList.get(i + numDrives * 2)});
                    }
                }
            }
            this.m_diskUITable.terminateTable();
        }
        this.m_diskUITable.displayTable(this.m_out);
        LOGGER.exit("Utilization.renderDiskUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
    }

    private void renderPhyMemoryTable() {
        LOGGER.enter("Start:Utilization.renderPhyMemoryTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
        LOGGER.fine("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            LOGGER.fine("Getting the latest data from SNMP for Phy Mem Utililzation");
            MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
            this.m_phyMemUITable = new UITable(MonteroResourceManager.getInstance().getString("MEMORY", this.m_monteroBean.getLoginBean().getLocale()), this.m_memHeader);
            ArrayList<String> tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.13", true);
            LOGGER.fine("tableList.size():" + tableList.size());
            if (tableList.size() == 0) {
                this.m_phyMemUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_memHeader.length);
            } else {
                this.m_phyMemUITable.addRow(new String[]{tableList.get(0), tableList.get(1), tableList.get(2), tableList.get(3)});
            }
            this.m_phyMemUITable.terminateTable();
        }
        this.m_phyMemUITable.displayTable(this.m_out);
        LOGGER.exit("Start:Utilization.renderPhyMemoryTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString());
    }

    private void renderPMP() throws MxInvalidTransactionException, IOException {
        LOGGER.enter("Utilization.renderPMP()");
        if (this.m_isUpdate) {
            PMPLicense pmpLicMgr = PMPLicense.getLicenseManager();
            this.m_isLicensedPMP = pmpLicMgr.isNodePMPLicensed(this.m_node.getDeviceKey());
        }
        LOGGER.fine("Is the device Licensed for PMP:" + this.m_isLicensedPMP);
        this.m_out.print("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" class=\"dataTable\"><caption>" + MonteroResourceManager.getInstance().getString("PMPTOOLS", this.m_monteroBean.getLoginBean().getLocale()) + "</caption>");
        if (this.m_isLicensedPMP) {
            String[][] toolList = MonteroResourceManager.getInstance().getPMPTools(this.m_monteroBean.getLoginBean().getLocale());
            for (int i = 0; i < toolList.length; ++i) {
                this.m_out.println("<tr class=\"altRowColor\">");
                try {
                    String tId = this.m_monteroBean.getToolId(toolList[i][1]);
                    this.m_out.println("<td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:MxPortalWorkspaceCreate('" + tId + "')\">" + toolList[i][0] + "</a></td>");
                }
                catch (BladeSystemException bex) {
                    LOGGER.fine("The tool with id" + toolList[i][1] + "was not found.");
                }
                this.m_out.println("</tr>");
            }
        } else {
            String jaPMPURL = "http://www.hp.com/jp/servers/pmp";
            String enPMPURL = "http://www.hp.com/servers/proliantessentials/pmp";
            String pmpURL = "http://www.hp.com/servers/proliantessentials/pmp";
            if (this.m_monteroBean.getLoginBean().getLocale().equals(Locale.JAPANESE)) {
                pmpURL = "http://www.hp.com/jp/servers/pmp";
            }
            this.m_out.print("<tr class=\"altRowColor\"><td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b><a href =\" " + pmpURL + "\" TARGET=" + "\"RESOURCE WINDOW\">" + MonteroResourceManager.getInstance().getPMP_Msg(this.m_monteroBean.getLoginBean().getLocale()) + "</a></td></tr>");
        }
        this.m_out.print("</table>");
        LOGGER.exit("Utilization.renderPMP()");
    }

    private ArrayList<String> getFanDetails() {
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> fanDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.2", true);
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.3", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.4", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.6", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.8", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.9", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.10", true));
        return fanDetails;
    }

    public void renderFanDetails() {
        LOGGER.enter("Utilization:renderFanDetails()");
        LOGGER.fine("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            LOGGER.fine("Getting the latest data from SNMP for Fan Details");
            this.m_fanUITable = new UITable(MonteroResourceManager.getInstance().getString("FanTableName", this.m_monteroBean.getLoginBean().getLocale()), this.m_fanHeader);
            ArrayList<String> fanDetails = this.getFanDetails();
            if (fanDetails.size() == 0) {
                this.m_fanUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_fanHeader.length);
            } else {
                int noOfCol = fanDetails.size() / (this.m_fanHeader.length + 1);
                for (int i = 0; i < noOfCol; ++i) {
                    LOGGER.fine("Display the Fan row if the fan is present");
                    if (!fanDetails.get(i + noOfCol * 2).toString().equalsIgnoreCase("3")) continue;
                    this.m_fanUITable.addRow(new String[][]{{fanDetails.get(i).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {fanDetails.get(i + noOfCol * 4).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 3).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 5).toString()) - 1, 2, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 6).toString()) - 1, 3, this.m_monteroBean.getLoginBean().getLocale()), "false"}});
                }
            }
            this.m_fanUITable.terminateTable();
        }
        this.m_fanUITable.displayTable(this.m_out);
        LOGGER.exit("Utilization:renderFanDetails()");
    }

    private ArrayList<String> getTemperatureDetails() {
        LOGGER.enter("Utilization:getTemperatureDetails()");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> thermalDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.2", true);
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.3", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.4", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.5", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.6", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.7", true));
        LOGGER.exit("Utilization:getTemperatureDetails()");
        return thermalDetails;
    }

    public void renderTemperatureDetails() {
        LOGGER.enter("Utilization:renderTemperatureDetails()");
        LOGGER.fine("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            LOGGER.fine("Getting the latest data from SNMP for temperature details");
            this.m_tempUITable = new UITable(MonteroResourceManager.getInstance().getString("TemperatureTableName", this.m_monteroBean.getLoginBean().getLocale()), this.m_temperatureHeader);
            ArrayList<String> temperatureDetails = this.getTemperatureDetails();
            if (temperatureDetails.size() == 0) {
                this.m_tempUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), this.m_temperatureHeader.length);
            } else {
                int noOfCol = temperatureDetails.size() / this.m_temperatureHeader.length;
                for (int i = 0; i < noOfCol; ++i) {
                    this.m_tempUITable.addRow(new String[][]{{temperatureDetails.get(i).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {temperatureDetails.get(i + noOfCol * 2).toString(), "false"}, {temperatureDetails.get(i + noOfCol * 3).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 4).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 5).toString()) - 1, 4, this.m_monteroBean.getLoginBean().getLocale()), "false"}});
                }
            }
            this.m_tempUITable.terminateTable();
        }
        this.m_tempUITable.displayTable(this.m_out);
        LOGGER.exit("Utilization:renderTemperatureDetails()");
    }
}

