/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.util.UtilizationTableDataModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class CPUUtilizationData {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(CPUUtilizationData.class);
    private UtilizationTableDataModel cpuUtilTable;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("CPUUtilizationData.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.cpuUtilTable = new UtilizationTableDataModel<String>(MonteroResourceManager.getInstance().getCpuUtilTableHeaders(this.m_monteroBean.getLoginBean().getLocale()));
            isInitialized = true;
        }
        LOGGER.exit("CPUUtilizationData.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    public void setCPUUtilTableModel() {
        LOGGER.enter("CPUUtilizationData.renderCPUUtilTable() Node Name:" + this.m_node.getNameString());
        LOGGER.fine("Getting the latest data from SNMP for CPU Utililzation");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.3.1.1.3", true);
        ArrayList<String> cpuName = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.1.2.2.1.1.3", false);
        ArrayList<String> cpuSpeed = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.1.2.2.1.1.4", true);
        LOGGER.fine("Size of CPU Util:" + tableList.size());
        LOGGER.fine("Size of CPU Name:" + tableList.size());
        LOGGER.fine("Size of CPU Speed:" + tableList.size());
        ArrayList<String> row = new ArrayList<String>();
        this.cpuUtilTable.clearData();
        if (tableList.size() == 0 || cpuName.size() == 0 || cpuSpeed.size() == 0) {
            row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
            this.cpuUtilTable.addRow(row);
        } else {
            for (int i = 0; i < tableList.size(); ++i) {
                row.add(i + "");
                row.add(cpuSpeed.get(0) + " " + MonteroResourceManager.getInstance().getString("cpu.abbreviation.mhz", this.m_monteroBean.getLoginBean().getLocale()) + " " + cpuName.get(0));
                row.add((String)tableList.get(i));
                this.cpuUtilTable.addRow(row);
                row = new ArrayList();
            }
        }
        this.cpuUtilTable.fireTableDataChanged();
        LOGGER.exit("CPUUtilizationData.renderCPUUtilTable() Node Name:" + this.m_node.getNameString());
    }

    public AbstractTableModel getCPUUtilTableModel() {
        return this.cpuUtilTable;
    }
}

