/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.util.UtilizationTableDataModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FanUtilData {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(FanUtilData.class);
    private UtilizationTableDataModel fanUtilTable;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private String[] m_fanHeader;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("FanUtilData.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.m_fanHeader = MonteroResourceManager.getInstance().getFanTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.fanUtilTable = new UtilizationTableDataModel<String>(this.m_fanHeader);
            isInitialized = true;
        }
        LOGGER.exit("FanUtilData.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    private ArrayList<String> getFanDetails() {
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<Object> fanDetails = new ArrayList();
        fanDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.2", true);
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.3", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.4", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.6", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.8", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.9", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.10", true));
        return fanDetails;
    }

    public void setFanDetailsTableModel() {
        LOGGER.enter("FanUtilData:setFanDetailsTableModel()");
        LOGGER.fine("Getting the latest data from SNMP for Fan Details");
        this.fanUtilTable.clearData();
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<String> fanDetails = this.getFanDetails();
        if (fanDetails.size() == 0) {
            row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
            this.fanUtilTable.addRow(row);
        } else {
            int noOfCol = fanDetails.size() / (this.m_fanHeader.length + 1);
            MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
            for (int i = 0; i < noOfCol; ++i) {
                LOGGER.fine("Display the Fan row if the fan is present");
                if (!fanDetails.get(i + noOfCol * 2).toString().equalsIgnoreCase("3")) continue;
                row.add(fanDetails.get(i).toString());
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()));
                row.add(fanDetails.get(i + noOfCol * 4).toString());
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 3).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()));
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 5).toString()) - 1, 2, this.m_monteroBean.getLoginBean().getLocale()));
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 6).toString()) - 1, 3, this.m_monteroBean.getLoginBean().getLocale()));
                this.fanUtilTable.addRow(row);
                row = new ArrayList();
            }
        }
        this.fanUtilTable.fireTableDataChanged();
        LOGGER.exit("FanUtilData:setFanDetailsTableModel()");
    }

    public AbstractTableModel getFanUtilTable() {
        return this.fanUtilTable;
    }
}

