/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.util.UtilizationTableDataModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class LogicalVolumeUtilizationData {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(LogicalVolumeUtilizationData.class);
    private UtilizationTableDataModel diskUtilTable;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("LogicalVolumeUtilizationData.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.diskUtilTable = new UtilizationTableDataModel<String>(MonteroResourceManager.getInstance().getDiskInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale()));
            isInitialized = true;
        }
        LOGGER.exit("LogicalVolumeUtilizationData.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    private ArrayList getLogicalVolumeUtilizationTable() {
        LOGGER.enter("LogicalVolumeUtilizationData.getDiskUtilizationTable()");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> logicalVolUtilData = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.2", false);
        logicalVolUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.3", true));
        logicalVolUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.5", true));
        LOGGER.fine("Size Of diskUtilData:" + logicalVolUtilData.size());
        LOGGER.exit("LogicalVolumeUtilizationData.getDiskUtilizationTable()");
        return logicalVolUtilData;
    }

    public void setLogicalVolumeUtilTableModel() {
        LOGGER.enter("LogicalVolumeUtilizationData.setLogicalVolumeUtilTableModel() Node Name:" + this.m_node.getNameString());
        LOGGER.fine("Getting the latest data from SNMP for Disk Utililzation");
        this.diskUtilTable.clearData();
        String numDrivesStr = this.m_deviceInfoBean.getNumberLogicalDrives() + "";
        int numDrives = Integer.parseInt(numDrivesStr);
        LOGGER.fine("numDrives:" + numDrives);
        ArrayList<String> row = new ArrayList<String>();
        if (numDrives <= 0) {
            row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
            this.diskUtilTable.addRow(row);
        } else {
            ArrayList tableList = this.getLogicalVolumeUtilizationTable();
            LOGGER.fine("tableList:" + tableList.size());
            if (tableList.size() == 0) {
                row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
                this.diskUtilTable.addRow(row);
            } else {
                numDrives = tableList.size() / 3;
                LOGGER.fine("numDrives:" + numDrives);
                for (int i = 0; i < numDrives; ++i) {
                    row.add((String)tableList.get(i));
                    row.add((String)tableList.get(i + numDrives));
                    row.add((String)tableList.get(i + numDrives * 2));
                    this.diskUtilTable.addRow(row);
                    row = new ArrayList();
                }
            }
        }
        this.diskUtilTable.fireTableDataChanged();
        LOGGER.exit("LogicalVolumeUtilizationData.setLogicalVolumeUtilTableModel()");
    }

    public AbstractTableModel getDiskUtilTable() {
        return this.diskUtilTable;
    }
}

