/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.license.PMPLicense;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.jsp.JspWriter;

public class PMPTable {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PMPTable.class);
    private MonteroBean m_monteroBean;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("PMPTable.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_node = deviceInfoBean.getMxNode();
            isInitialized = true;
        }
        LOGGER.exit("PMPTable.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    public void renderPMP(JspWriter out) throws MxInvalidTransactionException, IOException {
        LOGGER.enter("PMPTable.renderPMP()");
        PMPLicense pmpLicMgr = PMPLicense.getLicenseManager();
        boolean isLicensedPMP = pmpLicMgr.isNodePMPLicensed(this.m_node.getDeviceKey());
        LOGGER.fine("Is the device Licensed for PMP:" + isLicensedPMP);
        out.print("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" class=\"dataTable\"><caption>" + MonteroResourceManager.getInstance().getString("PMPTOOLS", this.m_monteroBean.getLoginBean().getLocale()) + "</caption>");
        if (isLicensedPMP) {
            String[][] toolList = MonteroResourceManager.getInstance().getPMPTools(this.m_monteroBean.getLoginBean().getLocale());
            for (int i = 0; i < toolList.length; ++i) {
                out.println("<tr class=\"altRowColor\">");
                try {
                    String tId = this.m_monteroBean.getToolId(toolList[i][1]);
                    out.println("<td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:MxPortalWorkspaceCreate('" + tId + "')\">" + toolList[i][0] + "</a></td>");
                }
                catch (BladeSystemException bex) {
                    LOGGER.fine("The tool with id" + toolList[i][1] + "was not found.");
                }
                out.println("</tr>");
            }
        } else {
            String jaPMPURL = "http://www.hp.com/jp/servers/pmp";
            String enPMPURL = "http://www.hp.com/servers/proliantessentials/pmp";
            String pmpURL = "http://www.hp.com/servers/proliantessentials/pmp";
            if (this.m_monteroBean.getLoginBean().getLocale().equals(Locale.JAPANESE)) {
                pmpURL = "http://www.hp.com/jp/servers/pmp";
            }
            out.print("<tr class=\"altRowColor\"><td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b><a href =\" " + pmpURL + "\" TARGET=" + "\"RESOURCE WINDOW\">" + MonteroResourceManager.getInstance().getPMP_Msg(this.m_monteroBean.getLoginBean().getLocale()) + "</a></td></tr>");
        }
        out.print("</table>");
        LOGGER.exit("PMPTable.renderPMP()");
    }
}

