/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.util.UtilizationTableDataModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class PhyMemUtilizationData {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PhyMemUtilizationData.class);
    private UtilizationTableDataModel phyMemUtilTable;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("PhyMemUtilizationData.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.phyMemUtilTable = new UtilizationTableDataModel<String>(MonteroResourceManager.getInstance().getmainMemInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale()));
            isInitialized = true;
        }
        LOGGER.exit("PhyMemUtilizationData.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    public void setPhyMemoryTableModel() {
        LOGGER.enter("PhyMemUtilizationData.setPhyMemoryTableModel() Node Name:" + this.m_node.getNameString());
        LOGGER.fine("Getting the latest data from SNMP for Phy Mem Utililzation");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        this.phyMemUtilTable.clearData();
        ArrayList<String> tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.13", true);
        ArrayList<String> row = new ArrayList<String>();
        LOGGER.fine("tableList.size():" + tableList.size());
        if (tableList.size() == 0) {
            row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
            this.phyMemUtilTable.addRow(row);
        } else {
            row.add(tableList.get(0));
            row.add(tableList.get(1));
            row.add(tableList.get(2));
            row.add(tableList.get(3));
            this.phyMemUtilTable.addRow(row);
        }
        this.phyMemUtilTable.fireTableDataChanged();
        LOGGER.exit("PhyMemUtilizationData.setPhyMemoryTableModel()");
    }

    public AbstractTableModel getPhyMemUtilTable() {
        return this.phyMemUtilTable;
    }
}

