/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance.util;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.util.UtilizationTableDataModel;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemperatureUtilData {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(TemperatureUtilData.class);
    private UtilizationTableDataModel tempUtilTable;
    private String[] m_temperatureHeader;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private MxNode m_node;

    public boolean initialize(DeviceInfoBean deviceInfoBean) {
        LOGGER.enter("TemperatureUtilData.initialize(" + deviceInfoBean + ")");
        boolean isInitialized = false;
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            LOGGER.fine("We are in a new node.");
            LOGGER.fine("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            this.m_temperatureHeader = MonteroResourceManager.getInstance().getTemperatureTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            this.tempUtilTable = new UtilizationTableDataModel<String>(this.m_temperatureHeader);
            isInitialized = true;
        }
        LOGGER.exit("TemperatureUtilData.initialize(" + deviceInfoBean + ")");
        return isInitialized;
    }

    private ArrayList<String> getTemperatureDetails() {
        LOGGER.enter("TemperatureUtilData:getTemperatureDetails()");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList<String> thermalDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.2", true);
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.3", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.4", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.5", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.6", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.7", true));
        LOGGER.exit("TemperatureUtilData:getTemperatureDetails()");
        return thermalDetails;
    }

    public void setTemperatureDetailsTableModel() {
        LOGGER.enter("TemperatureUtilData:setTemperatureDetailsTableModel()");
        LOGGER.fine("Getting the latest data from SNMP for temperature details");
        this.tempUtilTable.clearData();
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<String> temperatureDetails = this.getTemperatureDetails();
        if (temperatureDetails.size() == 0) {
            row.add(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()));
            this.tempUtilTable.addRow(row);
        } else {
            int noOfCol = temperatureDetails.size() / this.m_temperatureHeader.length;
            MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
            for (int i = 0; i < noOfCol; ++i) {
                row.add(temperatureDetails.get(i).toString());
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()));
                row.add(temperatureDetails.get(i + noOfCol * 2).toString());
                row.add(temperatureDetails.get(i + noOfCol * 3).toString());
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 4).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()));
                row.add(m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 5).toString()) - 1, 4, this.m_monteroBean.getLoginBean().getLocale()));
                this.tempUtilTable.addRow(row);
                row = new ArrayList();
            }
        }
        this.tempUtilTable.fireTableDataChanged();
        LOGGER.enter("TemperatureUtilData:setTemperatureDetailsTableModel()");
    }

    public AbstractTableModel getTempUtilTable() {
        return this.tempUtilTable;
    }
}

