/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.prp;

import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.soap.v5_0_2.server.MxpiLogonSession;
import com.hp.mx.soap.v5_0_2.server.MxpiLogonSessionStore;
import com.hp.mx.soap.v5_0_2.server.MxpiMain;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;

public class PRPStatusManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PRPStatusManager.class);
    private static boolean m_isPRPModuleInstalled = PRPStatusManager.isPRPModuleInstalled();
    private final String PRP_STATUS_SOURCE_NAME = "hp.amstatus";
    private static PRPStatusManager m_amStatusMgr;

    private PRPStatusManager() {
    }

    public static PRPStatusManager getInstance() {
        if (m_amStatusMgr == null) {
            m_amStatusMgr = new PRPStatusManager();
        }
        return m_amStatusMgr;
    }

    private int getPRPStatus(MxNode device) {
        LOGGER.enter("PRPStatusManager.getPRPStatus()");
        LOGGER.fine("Device Name:" + device.getNameString());
        LOGGER.fine("Device Key:" + device.getDeviceKey());
        String deviceName = device.getNameString();
        MxpiLogonSession logonSession = MxpiLogonSessionStore.getStore().addLogonSession("mxadmin");
        logonSession.setSSLMutualAuthenticationRequired(false);
        logonSession.setValidated(true);
        String logonToken = logonSession.getLogonToken();
        MxpiMain myInt = new MxpiMain();
        int statusValue = -1;
        try {
            statusValue = myInt.getNodeStatus(logonToken, deviceName, "hp.amstatus");
        }
        catch (Exception e) {
            // empty catch block
        }
        LOGGER.fine("PRP Status :" + statusValue);
        LOGGER.exit("PRPStatusManager.getPRPStatus()");
        return statusValue;
    }

    public String getPRPStatusIcon(MxNode device) {
        LOGGER.enter("PRPStatusManager.getPRPStatusIcon(" + device + ")");
        LOGGER.fine("Device Name:" + device.getNameString());
        String statusIcon = null;
        if (m_isPRPModuleInstalled) {
            switch (this.getPRPStatus(device)) {
                case 1: {
                    statusIcon = "Normal";
                    break;
                }
                case 2: {
                    statusIcon = "Warning";
                    break;
                }
                case 5: {
                    statusIcon = "Critical";
                    break;
                }
                case 9: {
                    statusIcon = "Disabled";
                    break;
                }
                default: {
                    statusIcon = "Blank";
                }
            }
        }
        LOGGER.fine("Status Icon:" + statusIcon);
        LOGGER.exit("PRPStatusManager.getPRPStatusIcon(" + device + ")");
        return statusIcon;
    }

    private static boolean isPRPModuleInstalled() {
        LOGGER.enter("PRPStatusManager.isPRPModuleInstalled()");
        boolean isPRPMgrModuleInstalled = false;
        try {
            String AMComponentExistStr = GlobalSettings.getProperty((String)"AMInstalled", (String)"no");
            if (AMComponentExistStr.equalsIgnoreCase("YES")) {
                isPRPMgrModuleInstalled = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.fine("exception:PRPStatusManager.isPRPModuleInstalled()" + e);
        }
        LOGGER.fine("isPRPModuleInstalled:" + isPRPMgrModuleInstalled);
        LOGGER.exit("PRPStatusManager.isPRPModuleInstalled()");
        return isPRPMgrModuleInstalled;
    }

    public static void getPRPTools(MonteroBean mBean, JspWriter out) throws MxInvalidTransactionException, IOException {
        if (m_isPRPModuleInstalled) {
            String[][] toolList = MonteroResourceManager.getInstance().getPRPTools(mBean.getLoginBean().getLocale());
            LOGGER.fine("toolList.length:" + toolList.length);
            out.print("<table id=\"PRP_LINKS\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
            out.print("<td>" + MonteroResourceManager.getInstance().getString("PRP.BPV", mBean.getLoginBean().getLocale()) + ":&nbsp;</td>");
            String tId = null;
            for (int i = 0; i < toolList.length; ++i) {
                try {
                    tId = mBean.getToolId(toolList[i][1]);
                    out.print("<td>&nbsp;&nbsp;&nbsp;&nbsp;");
                    out.print("<a href=\"javascript:MxPortalWorkspaceCreate('" + tId + "')\">");
                    out.print(toolList[i][0] + "</a></td>");
                    continue;
                }
                catch (BladeSystemException bex) {
                    LOGGER.fine("The tool with id" + toolList[i][1] + "was not found.");
                }
            }
            out.print("<td>&nbsp;&nbsp;&nbsp;&nbsp;");
            out.print("<a href=\"javascript:MxPortalWorkspaceCreate('AUTOMATION_CONSOLE_POLICY','selection=POLICYMAN')\">");
            out.print(MonteroResourceManager.getInstance().getString("prp.PolicyMgmt", mBean.getLoginBean().getLocale()) + "</a></td>");
            out.print("</tr></table>");
        }
    }

    public String getPRPMURL(MxNode device) {
        return "/mxportal/DevicePage/devicepage.jsp?nodeId=" + device.getGUID().toString() + "&selection=ID_PRP&index=3";
    }
}

