/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxNodeIsLockedException;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.querymanager.TreeViewDeviceObject;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.MxBPV;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.skin.SkinParser;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPVSkin {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(BPVSkin.class);
    private String m_skinXml = null;
    protected int counter = 0;

    public void applySkin(JspWriter writer, String guid, MxLoginBean loginBean, Map<String, String> params, boolean isExpired) throws BladeSystemException {
        MxNode node = null;
        LOGGER.enter("BPVSkin.applySkin(" + writer + "," + guid + "," + loginBean + "," + params + "," + isExpired + ")");
        try {
            node = loginBean.getNodeClient().getNode(new MxObjectID(new MxGUID(guid)), false);
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.fine("MxUndefinedNodeException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxNodeIsLockedException e) {
            LOGGER.fine("MxNodeIsLockedException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxFailedAuthenticationException e) {
            LOGGER.fine("MxFailedAuthenticationException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxInvalidTransactionException e) {
            LOGGER.fine("MxInvalidTransactionException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        String deviceType = node.getDeviceType();
        String typeOfView = params.get("typeOfDisplay");
        if (typeOfView != null && typeOfView.equals("urack")) {
            deviceType = "urack";
        }
        String deviceSubType = "ServerEnc";
        List subTypes = node.getDeviceSubTypes();
        if (subTypes.contains("PowerEnc")) {
            deviceSubType = "PowerEnc";
        }
        SkinParser s = new SkinParser();
        Iterator<String> iter = params.keySet().iterator();
        String[][] paramLst = new String[params.size() + 1][2];
        paramLst[0] = new String[]{"deviceSubType", deviceSubType};
        int i = 1;
        while (iter.hasNext()) {
            String key = iter.next();
            paramLst[i] = new String[]{key, params.get(key)};
            ++i;
        }
        s.configure(deviceType, paramLst);
        if (isExpired || this.m_skinXml == null || this.m_skinXml.length() == 0) {
            this.refreshBPV(guid, loginBean);
        }
        try {
            writer.println("<div id=\"BPV_PRINT\">");
            s.parseXML(this.m_skinXml, writer);
            writer.println("</div>");
        }
        catch (Exception e) {
            LOGGER.fine("Exception:" + e);
        }
        LOGGER.exit("BPVSkin.applySkin(" + writer + "," + guid + "," + loginBean + "," + params + "," + isExpired + ")");
    }

    public void applySkin(JspWriter writer, String guid, MxLoginBean loginBean, String typeOfView, boolean isExpired) throws BladeSystemException {
        MxNode node = null;
        LOGGER.enter("BPVSkin.applySkin(" + writer + "," + guid + "," + loginBean + "," + typeOfView + "," + isExpired + ")");
        try {
            node = loginBean.getNodeClient().getNode(new MxObjectID(new MxGUID(guid)), false);
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.fine("MxUndefinedNodeException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxNodeIsLockedException e) {
            LOGGER.fine("MxNodeIsLockedException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxFailedAuthenticationException e) {
            LOGGER.fine("MxFailedAuthenticationException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        catch (MxInvalidTransactionException e) {
            LOGGER.fine("MxInvalidTransactionException" + (Object)((Object)e));
            throw new BladeSystemException(e);
        }
        String deviceType = node.getDeviceType();
        if (typeOfView != null && typeOfView.equals("urack")) {
            deviceType = "urack";
        }
        LOGGER.fine("deviceType:" + deviceType);
        String deviceSubType = "ServerEnc";
        List subTypes = node.getDeviceSubTypes();
        if (subTypes.contains("PowerEnc")) {
            deviceSubType = "PowerEnc";
        }
        SkinParser s = new SkinParser();
        String[][] paramLst = new String[][]{{"deviceSubType", deviceSubType}, {"typeOfDisplay", typeOfView}};
        s.configure(deviceType, paramLst);
        if (isExpired || this.m_skinXml == null || this.m_skinXml.length() == 0) {
            this.refreshBPV(guid, loginBean);
        }
        try {
            writer.println("<div id=\"BPV_PRINT\">");
            s.parseXML(this.m_skinXml, writer);
            writer.println("</div>");
        }
        catch (Exception e) {
            LOGGER.fine("Exception:" + e);
        }
        LOGGER.exit("BPVSkin.applySkin(" + writer + "," + guid + "," + loginBean + "," + typeOfView + "," + isExpired + ")");
    }

    private void refreshBPV(String guid, MxLoginBean loginBean) throws BladeSystemException {
        LOGGER.enter("BPVSkin.refreshBPV(" + guid + "," + loginBean + ")");
        MxBPV bpvBean = new MxBPV();
        bpvBean.initialize(guid, loginBean);
        this.m_skinXml = bpvBean.getXML();
        LOGGER.exit("BPVSkin.refreshBPV(" + guid + "," + loginBean + ")");
    }

    public int displayNodeByQuery(MxLoginBean loginBean, String QueryName, JspWriter out, String typeOfDisplay) throws Exception {
        LOGGER.enter("BPVSkin : displayNodeByQuery for Query :" + QueryName);
        MxQueryClient qClient = loginBean.getQueryClient();
        DefaultMutableTreeNode queryTreeRoot = null;
        MxNodeClient nodeClient = loginBean.getNodeClient();
        this.counter = 0;
        try {
            int m_allDeviceQueryId = qClient.getQuery(QueryName).getQueryId();
            queryTreeRoot = qClient.runQueryWithTreeResults(m_allDeviceQueryId);
            queryTreeRoot.setUserObject(QueryName);
            Enumeration<TreeNode> enumeration = queryTreeRoot.children();
            int childcount = queryTreeRoot.getChildCount();
            if (!enumeration.hasMoreElements()) {
                out.println("<div id=\"BPV_PRINT\">");
                out.print("<p>");
                out.print("<br><font color='black'>");
                out.print(MonteroResourceManager.getInstance().getString("EMPTY_COLLECTION", loginBean.getLocale()));
                out.print(".</font>");
                out.print("<p>");
                out.println("</div>");
            } else {
                Object[] sortedMxNode = new String[childcount];
                out.println("<div id=\"BPV_PRINT\">");
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    TreeViewDeviceObject o = (TreeViewDeviceObject)childTreeNode.getUserObject();
                    MxObjectID obId = o.getObjectID();
                    int devKey = obId.getKey();
                    LOGGER.fine("Device found with deviceKey :" + devKey);
                    MxNode childNode = nodeClient.getNodeByKey(devKey, false);
                    sortedMxNode[this.counter] = childNode.getNameString();
                    ++this.counter;
                }
                Arrays.sort(sortedMxNode);
                this.renderZoomBPV((String[])sortedMxNode, out, loginBean, typeOfDisplay);
                out.println("</div>");
            }
        }
        catch (Exception e) {
            LOGGER.fine("Exception:" + e);
            throw new Exception(e);
        }
        LOGGER.fine("count:" + this.counter);
        LOGGER.exit("BPVSkin : displayNodeByQuery for Query :" + QueryName);
        return this.counter;
    }

    private void renderZoomBPV(String[] sortedMxNode, JspWriter out, MxLoginBean loginBean, String typeOfDisplay) throws Exception {
        LOGGER.enter("BPVSkin.renderZoomBPV()");
        int counter = 0;
        for (int i = 0; i < sortedMxNode.length; ++i) {
            try {
                MxNode childNode = MxNodeController.getDefaultControllerNoEx().getDeviceByName(sortedMxNode[i]);
                if (childNode == null) continue;
                LOGGER.fine("counter:" + counter);
                SkinParser s = new SkinParser();
                this.refreshBPV(childNode.getGUID().toString(), loginBean);
                String[][] xslParamLst = new String[][]{{"typeOfDisplay", typeOfDisplay}, {"deviceSubType", childNode.getDeviceSubTypes().toString()}, {"deviceType", childNode.getDeviceType()}, {"counter", ++counter + ""}};
                s.configure("zoom", xslParamLst);
                s.parseXML(this.m_skinXml, out);
                this.m_skinXml = null;
                out.print("<p>");
                continue;
            }
            catch (Exception e) {
                LOGGER.fine("Exception:" + e);
                throw new Exception(e);
            }
        }
        LOGGER.exit("BPVSkin.renderZoomBPV()");
    }
}

