/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.skin.SkinURIResolver;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.jsp.JspWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SkinParser {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(SkinParser.class);
    private TransformerHandler m_transformer = null;
    private SAXTransformerFactory m_saxTFactory = null;

    private void initialize() {
        LOGGER.enter("SkinParser.intialize()");
        SkinURIResolver uriResolver = new SkinURIResolver();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setURIResolver(uriResolver);
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            this.m_saxTFactory = (SAXTransformerFactory)tFactory;
        }
        LOGGER.exit("SkinParser.intialize()");
    }

    public void configure(String nameOfXSL, String[][] xslParamLst) throws BladeSystemException {
        LOGGER.enter("SkinParser.configure(" + nameOfXSL + "," + xslParamLst + ")");
        try {
            this.initialize();
            this.m_transformer = this.m_saxTFactory.newTransformerHandler(new StreamSource(this.getClass().getResourceAsStream(nameOfXSL + ".xsl")));
            for (int i = 0; i < xslParamLst.length; ++i) {
                LOGGER.fine(xslParamLst[i][0] + ":" + xslParamLst[i][1]);
                this.m_transformer.getTransformer().setParameter(xslParamLst[i][0], xslParamLst[i][1]);
            }
        }
        catch (TransformerConfigurationException tcex) {
            LOGGER.fine("Exception while configuring." + tcex);
            throw new BladeSystemException(tcex);
        }
        catch (Exception tcex) {
            LOGGER.fine("Exception while configuring." + tcex);
            throw new BladeSystemException(tcex);
        }
        LOGGER.exit("SkinParser.configure(" + nameOfXSL + "," + xslParamLst + ")");
    }

    public void configure(String nameOfXSL) throws BladeSystemException {
        LOGGER.enter("SkinParser.configure(" + nameOfXSL + ")");
        try {
            this.initialize();
            this.m_transformer = this.m_saxTFactory.newTransformerHandler(new StreamSource(this.getClass().getResourceAsStream(nameOfXSL + ".xsl")));
        }
        catch (TransformerConfigurationException tcex) {
            LOGGER.fine("Exception while configuring." + tcex);
            throw new BladeSystemException(tcex);
        }
        catch (Exception tcex) {
            LOGGER.fine("Exception while configuring." + tcex);
            throw new BladeSystemException(tcex);
        }
        LOGGER.exit("SkinParser.configure(" + nameOfXSL + ")");
    }

    public void parseXML(String xmlStr, JspWriter writer) throws BladeSystemException {
        LOGGER.enter("SkinParser.parseXML(" + xmlStr + "," + writer + ")");
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(this.m_transformer);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.m_transformer);
            Serializer serializer = SerializerFactory.getSerializer((Properties)OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
            serializer.setWriter((Writer)writer);
            this.m_transformer.setResult(new SAXResult(serializer.asContentHandler()));
            if (xmlStr != null) {
                reader.parse(new InputSource(new StringReader(xmlStr)));
            }
        }
        catch (SAXNotRecognizedException e) {
            LOGGER.fine("SAXNotReconginized" + e);
            throw new BladeSystemException(e);
        }
        catch (SAXNotSupportedException e) {
            LOGGER.fine("SAXNotSupportedException" + e);
            throw new BladeSystemException(e);
        }
        catch (FileNotFoundException e) {
            LOGGER.fine("FileNotFoundException" + e);
            throw new BladeSystemException(e);
        }
        catch (SAXException e) {
            LOGGER.fine("SAXException" + e);
            throw new BladeSystemException(e);
        }
        catch (IOException e) {
            LOGGER.fine("IOException" + e);
            throw new BladeSystemException(e);
        }
        LOGGER.exit("SkinParser.parseXML(" + xmlStr + "," + writer + ")");
    }
}

