/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.tools;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;

public class ILOProperties {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILOProperties.class);
    public static final float ILO_SSO_FIRMWARE_PREREQUISTE = 1.3f;

    public MxNode getILOMxNode(String deviceGUID, MxLoginBean loginBean) {
        LOGGER.enter("ILOProperties.getILOIPAddress(" + deviceGUID + "," + loginBean + ")");
        MxObjectID objID = new MxObjectID(new MxGUID(deviceGUID));
        MxNodeClient nodeClient = loginBean.getNodeClient();
        MxNode deviceMxNode = null;
        try {
            deviceMxNode = nodeClient.getNode(objID, false);
            if (deviceMxNode != null && deviceMxNode.getDeviceType().equalsIgnoreCase("MgmtProc")) {
                LOGGER.fine("Device " + deviceMxNode.getNameString() + " is of type ilo.");
            } else if (deviceMxNode != null && deviceMxNode.getDeviceType().equalsIgnoreCase("Server")) {
                LOGGER.fine("Device " + deviceMxNode.getNameString() + " is of type server, Get its ILO via" + "associaion.");
                int iLOdevKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(deviceMxNode.getDeviceKey(), "MgmtProcToServer_Ilo");
                LOGGER.fine("ilo device key:" + iLOdevKey);
                if (iLOdevKey > 0) {
                    deviceMxNode = MxNodeController.getDefaultController().getReadOnlyNodeObject(iLOdevKey);
                    LOGGER.fine("ilo Name:" + deviceMxNode.getNameString());
                }
            }
        }
        catch (MxException e) {
            LOGGER.exception("MxException:" + (Object)((Object)e));
        }
        LOGGER.fine("deviceMxNode:" + deviceMxNode);
        LOGGER.exit("ILOProperties.getILOIPAddress(" + deviceGUID + "," + loginBean + ")");
        return deviceMxNode;
    }
}

