/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class MonteroVMUtils {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroVMUtils.class);
    private Hashtable<String, String> hostOSTable;

    public MonteroVMUtils() {
        LOGGER.enter("MonteroVMUtils.MonteroVMUtils()");
        this.hostOSTable = new Hashtable();
        this.hostOSTable.put("VMWARE_GSX_VMHost", "VMware Server / GSX Host");
        this.hostOSTable.put("VMWARE_ESX_VMHost", "VMware ESX Host");
        this.hostOSTable.put("MSVS_VMHost", "MS Virtual Server Host");
        this.hostOSTable.put(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString(), "HP Integrity Virtual Machine Host");
        LOGGER.exit("MonteroVMUtils.MonteroVMUtils()");
    }

    public boolean isVmHost(MxNode node) {
        LOGGER.enter("MonteroVMUtils.isVmHost(MxNode)");
        boolean isVmHost = false;
        if (node != null && (node.getDeviceSubTypes().contains(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString()) || node.getDeviceSubTypes().contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString()))) {
            isVmHost = true;
        }
        LOGGER.exit("MonteroVMUtils.isVmHost - " + isVmHost);
        return isVmHost;
    }

    public String getVMHostOsName(MxNode node) {
        LOGGER.enter("MonteroVMUtils.getVMHostOsName(" + node + ")");
        if (node != null) {
            List subTypesList = node.getDeviceSubTypes();
            String osName = this.getFromHostOSTable(subTypesList);
            if (osName != null && osName.length() != 0) {
                LOGGER.fine("Host os found from the subtypes " + osName);
                return osName;
            }
            LOGGER.fine("fetching subtypes from the db, os not found in node.getDeviceSubTypes()");
            subTypesList = this.getSubTypesFromDb(node.getDeviceKey());
            osName = this.getFromHostOSTable(subTypesList);
            if (osName != null && osName.length() != 0) {
                LOGGER.fine("os name is " + osName);
                return osName;
            }
        }
        LOGGER.fine("could not retrieve VM host os value.");
        LOGGER.exit("MonteroVMUtils.getVMHostOsName(" + node + ")");
        return "";
    }

    public String getFromHostOSTable(List lst) {
        LOGGER.enter("MonteroVMUtils.getFromHostOSTable(" + lst + ")");
        Enumeration<String> keys = this.hostOSTable.keys();
        while (keys.hasMoreElements()) {
            String osNameKey = keys.nextElement();
            if (!lst.contains(osNameKey = osNameKey.trim())) continue;
            String osNameValue = this.hostOSTable.get(osNameKey);
            LOGGER.fine("VM Host OS is " + osNameValue);
            return osNameValue;
        }
        LOGGER.fine("could not retrieve VM host OS");
        LOGGER.exit("MonteroVMUtils.getFromHostOSTable(" + lst + ")");
        return "";
    }

    public int getVMGuestCount(MxNode hostNode) {
        LOGGER.enter("MonteroVMUtils.getVMGuestCount()");
        int vmGuestCount = 0;
        Vector associatedVmGuestKeys = null;
        String assocType = "HPVMGuestToHPVMHost";
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            if (hostNode.getDeviceSubTypes().contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString())) {
                assocType = "VMGuestToVMHost";
            }
            associatedVmGuestKeys = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(hostNode.getDeviceKey(), assocType);
            vmGuestCount = associatedVmGuestKeys.size();
            LOGGER.fine("MonteroVMUtils.getVMGuestCount()- vmGuestCount  :" + vmGuestCount);
        }
        catch (MxException e) {
            LOGGER.exception("Exception in MonteroVMUtils.getVMGuestCount()" + (Object)((Object)e));
        }
        LOGGER.exit("MonteroVMUtils.getVMGuestCount");
        return vmGuestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSubTypesFromDb(Integer devKey) {
        LOGGER.enter("MonteroVMUtils.getSubTypesFromDb " + devKey);
        ArrayList<String> lst = new ArrayList<String>();
        Connection myConnection = null;
        Statement myStatement = null;
        ResultSet myResultSet = null;
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("NodeRepositoryManager.loadAllNodesFromDb()");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select subType2,subType3,subType4,subType5,subType6,subType7,subType8 from devices where deviceKey=" + devKey);
            if (myResultSet != null) {
                myResultSet.next();
                for (int i = 1; i <= 7; ++i) {
                    String subType = myResultSet.getString(i);
                    if (subType != null) {
                        subType = subType.trim();
                    }
                    LOGGER.fine("sub type at position " + i + " is " + subType + ".");
                    lst.add(subType);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.panic("Error retrieving subtypes from the db " + e.toString());
        }
        finally {
            try {
                if (myResultSet != null) {
                    myResultSet.close();
                }
                if (myStatement != null) {
                    myStatement.close();
                }
                if (myConnection != null) {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
            }
            catch (SQLException e) {
                LOGGER.panic("Finally clause clean up failure" + e.toString());
            }
        }
        LOGGER.exit("MonteroVMUtils.getSubTypesFromDb " + devKey);
        return lst;
    }
}

