/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.utilities;

import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxStatusMapping;

public class MonteroUtils {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroUtils.class);
    public static final String ILOTYPE_ASSOCAITED = "ILOTypeAssociated";
    public static final String ILO_DEVICEKEY = "iloDeviceKey";

    public static String normaliseOAXMLSatus(String status) {
        LOGGER.enter("MonteroUtils.normaliseOAXMLSatus(" + status + ")");
        String hpSIMStatus = null;
        if (status == null) {
            LOGGER.exit("MonteroUtils.normaliseOAXMLSatus(" + status + ")");
            return DeviceStatusType.UNKNOWN.toString();
        }
        hpSIMStatus = status.equalsIgnoreCase("normal") ? DeviceStatusType.NORMAL.toString() : (status.equalsIgnoreCase("unknown") || status.equalsIgnoreCase("DMTF Reserved") || status.equalsIgnoreCase("Vendor Reserved") ? DeviceStatusType.UNKNOWN.toString() : (status.equalsIgnoreCase("informational") ? "INFORMATIONAL" : (status.equalsIgnoreCase("disabled") || status.equalsIgnoreCase("IN SERVICE") ? DeviceStatusType.DISABLED.toString() : (status.equalsIgnoreCase("minor") ? DeviceStatusType.MINOR.toString() : (status.equalsIgnoreCase("major") ? DeviceStatusType.MAJOR.toString() : (status.equalsIgnoreCase("critical") ? DeviceStatusType.CRITICAL.toString() : (status.equalsIgnoreCase("warning_status") || status.equalsIgnoreCase("warning") ? DeviceStatusType.WARNING.toString() : MxStatusMapping.normalizeWBEMStringOperationalStatus((String)status))))))));
        if (hpSIMStatus == null || hpSIMStatus.equalsIgnoreCase("NOSTATUS")) {
            hpSIMStatus = DeviceStatusType.UNKNOWN.toString();
        }
        LOGGER.fine("hpSIMStatus:" + hpSIMStatus);
        LOGGER.exit("MonteroUtils.normaliseOAXMLSatus(" + status + ")");
        return hpSIMStatus;
    }
}

