/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.utilities;

import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.util.Properties;

public class PropertiesFile {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PropertiesFile.class);
    Properties propsFile = new Properties();

    public PropertiesFile(String className, String propertiesFileName) {
        this.loadPropertiesFile(className, propertiesFileName);
    }

    private Properties loadPropertiesFile(String className, String propertiesFileName) {
        LOGGER.enter("PropertiesFile.loadPropertiesFile(" + className + "," + propertiesFileName + ")");
        try {
            Class<?> classFile = Class.forName(className);
            this.propsFile.load(classFile.getResourceAsStream(propertiesFileName));
        }
        catch (ClassNotFoundException e1) {
            LOGGER.exception("Unable to load class:" + className + ". Exception:" + e1);
        }
        catch (IOException e1) {
            LOGGER.exception("Unable to load properties file " + propertiesFileName + " Exception:" + e1);
        }
        LOGGER.exit("PropertiesFile.loadPropertiesFile(" + className + "," + propertiesFileName + ")");
        return this.propsFile;
    }

    public String getProperty(String key) {
        return this.propsFile.getProperty(key);
    }
}

