<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

	<!--
		(C) Copyright 2005 Hewlett-Packard Development Company, L.P.
	-->
	
	<!-- NOTE: The global templates file depends on the guiConstants.xsl file. -->
	
	
	<!--
		Status icon template. Takes a status code as a parameter and returns
		an img element with the correct status image path.
	-->
	
	
	<xsl:template name="statusIcon">

		<!-- Icon status code -->
		<xsl:param name="statusCode" />

		<xsl:element name="img">
		<xsl:attribute name="border">0</xsl:attribute>
		<xsl:attribute name="onmouseout"><xsl:text>removeDeviceInfoTip();</xsl:text></xsl:attribute>

			<!-- Determine the icon image's src attribute based on status parameter -->
			<xsl:attribute name="src">
				<xsl:choose>

					<!-- New operational status stuff -->
					<xsl:when test="$statusCode=$STATUS_OK">
						<xsl:value-of select="$STATUS_OK_IMAGE" />
					</xsl:when>

					<xsl:when test="$statusCode=$STATUS_MISMATCH">
						<xsl:value-of select="$STATUS_MAJOR_IMAGE" />
					</xsl:when>

					<!--
						A catch all. Displays status as unknown if one of the above
						cases is not matched.
					-->
					<xsl:otherwise>
						<xsl:value-of select="$STATUS_UNKNOWN_IMAGE" />
					</xsl:otherwise>
					
				</xsl:choose>
			</xsl:attribute>
			<!-- tool tip -->
			<xsl:choose>
       		<xsl:when test="$statusCode=$STATUS_OK">
				<xsl:variable name="toolTip">
									<xsl:value-of select="//I18N/L10NNormalStatus"></xsl:value-of>
				</xsl:variable>
				<xsl:attribute name="onmouseover"><xsl:text>try{loadDeviceInfoTip(event,'</xsl:text><xsl:value-of select="$toolTip"/><xsl:text>');}catch(e) {loadDeviceInfoTip(null,'</xsl:text><xsl:value-of select="$toolTip"/><xsl:text>');}</xsl:text></xsl:attribute>						
			</xsl:when>
       		<xsl:when test="$statusCode=$STATUS_MISMATCH">
					<xsl:variable name="toolTip">
						<xsl:value-of select="//I18N/L10NMisMatchStatus"></xsl:value-of>
					</xsl:variable>
				    <xsl:attribute name="onmouseover"><xsl:text>try{loadDeviceInfoTip(event,'</xsl:text><xsl:value-of select="$toolTip"/><xsl:text>');}catch(e) {loadDeviceInfoTip(null,'</xsl:text><xsl:value-of select="$toolTip"/><xsl:text>');}</xsl:text></xsl:attribute>						
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="toolTip">
						<xsl:value-of select="//I18N/L10NUnknownStatus"></xsl:value-of>
				</xsl:variable>
			</xsl:otherwise>
		 </xsl:choose>

		</xsl:element>

	</xsl:template>
	
	<!--
		The getStatusLabel template takes a blade status code and returns the HTML image and
		text associated with that status code.
	-->

	<xsl:template name="getStatusLabel">

		<xsl:param name="statusCode" />

		<xsl:choose>
			<xsl:when test="$statusCode=$STATUS_OK">
				<xsl:call-template name="statusIcon" >
					<xsl:with-param name="statusCode" select="$statusCode" />
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$statusCode=$STATUS_MISMATCH">
				<xsl:call-template name="statusIcon" >
					<xsl:with-param name="statusCode" select="$statusCode" />
				</xsl:call-template>
			</xsl:when>
			
			<!-- A catch all in case none of the above cases are matched against a status code. -->
			<xsl:otherwise>
				<xsl:call-template name="statusIcon" >
					<xsl:with-param name="statusCode" select="$STATUS_UNKNOWN" />
				</xsl:call-template>
			</xsl:otherwise>

		</xsl:choose>

	</xsl:template>

</xsl:stylesheet>
