<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:include href="constants.xsl"/>
    <xsl:include href="globalTemplates.xsl"/>
	<xsl:include href="uproxy.xsl"/>
	<xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay"/>
	<xsl:param name="startU"/>
	<xsl:param name="endU"/>

	<xsl:template match="/">
		<!-- xsl:call-template name="Head"/ -->
		<div id="BPV_PRINT" >
		<table class="systemStatusTable" border="0" cellpadding="0" cellspacing="0" id="RackBPV" width="100%">
			<tbody>
				<!-- View As Combo box -->
					    <xsl:choose>
						  <xsl:when test="//Rack[@Empty='true']">
							<tr>
								<div id="emptyRackTitleBar" style="width: 100%;">
									<td align="left">
										<xsl:attribute name="style">border:1px solid #000000;</xsl:attribute>
											<table class="window-border-table-small" cellspacing="0" cellpadding="0" border="1"  width="100%">
												<font color="#cc0000" ><xsl:value-of select="//I18N/L10NTheEmptyRackMessage"/></font>
											</table>
								</td>
								</div>
							</tr>
						</xsl:when>
						<xsl:otherwise>
						<tr>
							<td>
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:attribute name="id"><xsl:value-of select="//Rack/Common/Name"/></xsl:attribute>
										<tbody>
											<xsl:for-each select="//BladeEnclosure">
												<tr>
													<td>
															<xsl:call-template name="renderBPV">
																<xsl:with-param name="encName">
																		<xsl:call-template name="getMemberAttr">
																		<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
																			<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
																	</xsl:call-template>
																</xsl:with-param>
																<xsl:with-param name="subRackName">
																	<xsl:value-of select="//Rack/Common/Name"/>
																</xsl:with-param>
																<xsl:with-param name="enclSerialNum">
																	<xsl:call-template name="getMember">
																		<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
																	</xsl:call-template>
																</xsl:with-param>
																<xsl:with-param name="typeOfView"><xsl:text>urack</xsl:text></xsl:with-param> 
																<xsl:with-param name="deviceSubType" select="$ServerEnc"/>
																<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
																<xsl:with-param name="startU" select="$startU"/>
																<xsl:with-param name="endU" select="$endU"/>
															</xsl:call-template>
													</td>
												</tr>
											</xsl:for-each>
											<xsl:for-each select="//PowerSupplyEnclosure">
											<tr>
												<td>
													<xsl:call-template name="renderBPV">
														<xsl:with-param name="encName">
															<xsl:call-template name="getMember">
																<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
															</xsl:call-template>
														</xsl:with-param>
														<xsl:with-param name="subRackName">
															<xsl:value-of select="//Rack/Common/Name"/>
														</xsl:with-param>
														<xsl:with-param name="enclSerialNum">
															<xsl:call-template name="getMember">
																<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
															</xsl:call-template>
														</xsl:with-param>
															<xsl:with-param name="typeOfView"><xsl:text>urack</xsl:text></xsl:with-param> 
															<xsl:with-param name="deviceSubType" select="$PowerEnc"/>
															<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
															<xsl:with-param name="startU" select="$startU"/>
															<xsl:with-param name="endU" select="$endU"/>
													</xsl:call-template>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
								</table>
							</td>
						</tr>
				</xsl:otherwise>
			</xsl:choose>
			</tbody>
		</table>
		</div>
</xsl:template>
</xsl:stylesheet>
