<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
    <xsl:include href="constants.xsl" />
    <xsl:include href="globalTemplates.xsl" />
	<xsl:include href="proxy.xsl" />

	<xsl:param name="typeOfDisplay" />
	<xsl:param name="deviceType" />
	<xsl:param name="counter"/>

<!--
	<xsl:param name="typeOfDisplay" />
	<xsl:param name="deviceType" />
	<xsl:param name="counter" />
-->	
	<xsl:template match="/">
		<xsl:call-template name="Head"/>

		<xsl:if test="$counter &lt; 2">
			<table border="0" cellpadding="0" cellspacing="0">
				<tbody>
					
					<tr>
					<!--Seperator-->
						<td>	<xsl:value-of select="//I18N/L10NSelect"/> </td>
						<xsl:call-template name="drawCheckBox1">
							<xsl:with-param name="checkBoxName" select="//I18N/L10NAllBlades"/>
							<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
							<xsl:with-param name="checkBoxId" select="'All Blades'"/>
						</xsl:call-template>
						<xsl:call-template name="drawCheckBox1">
							<xsl:with-param name="checkBoxName" select="//I18N/L10NAllInterconnectSwitches"/>
							<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
							<xsl:with-param name="checkBoxId" select="'All Switches'"/>
						</xsl:call-template>
						<xsl:if test="//@type=$C_CLASS">
							<xsl:call-template name="drawCheckBox1">
								<xsl:with-param name="checkBoxName" select="//I18N/L10NAllEMs"/>
								<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								<xsl:with-param name="checkBoxId" select="'All EMs'"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:call-template name="drawCheckBox1">
							<xsl:with-param name="checkBoxName" select="//I18N/L10NAllEnclosures"/>
							<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
							<xsl:with-param name="checkBoxId" select="'All Enclosures'"/>
						</xsl:call-template>
						<xsl:if test="//@type!=$E_CLASS">
							<xsl:call-template name="drawCheckBox1">
								<xsl:with-param name="checkBoxName" select="//I18N/L10NAllRacks"/>
								<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								<xsl:with-param name="checkBoxId" select="'All Racks'"/>
							</xsl:call-template>
						</xsl:if>
					</tr>
				</tbody>
			</table>
		</xsl:if>
		
		 
		 <xsl:if test="$deviceType='Rack'">
			<table class="window-border-table-small systemStatusTable" cellspacing="0" cellpadding="0" border="0"  width="100%" >
			  <tr>
					<div id="enclTitleBar" style="width: 100%;">
						<td class="subTitle" id="rackTitle">
						<xsl:attribute name="style">border:1px solid #000000;</xsl:attribute>
						 <xsl:if test="//Rack[@Empty='false']">
							<div class="subTitleIcon">							 
								<xsl:choose>
									<xsl:when test="$typeOfDisplay = $BPV ">
										<a href="javascript:void(0);">
											<xsl:element name="img">
												<xsl:attribute name="onclick">toggleEnclosureVisible('<xsl:value-of select="//Rack/Common/Name"/>', this,'<xsl:value-of select="//I18N/L10NMaximize"/>','<xsl:value-of select="//I18N/L10NMinimize"/>','enclTitleBar');</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NMinimize"/></xsl:attribute>
												<xsl:attribute name="width">11</xsl:attribute>
												<xsl:attribute name="height">11</xsl:attribute>
												<xsl:attribute name="border">0</xsl:attribute>
											</xsl:element>
										</a>
									</xsl:when>
									<xsl:otherwise>
											<img width="11" height ="11" border="0" >
												<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
											</img>
									</xsl:otherwise>
								</xsl:choose>									
							 </div>
							</xsl:if>
							<div style="cursor:default" class="subTitleIconLeft" >

								<input type="checkbox" rowselector="yes" id="rackCheckBox" >
									<xsl:attribute name="title">
										<xsl:value-of select="//I18N/L10NRackChkBxTitle"/>
									</xsl:attribute>
									<xsl:if test="$typeOfDisplay!=$BPV">
										<xsl:attribute name="DISABLED"/>
									</xsl:if>
									<xsl:attribute name="guid">
										<xsl:value-of select="//Rack/Common/NodeId" />
									</xsl:attribute>
								</input>

								<xsl:for-each select="//Rack/Attribute">
									<xsl:if test="./@Section='System Status' and ./Name=//I18N/L10NHealthStatus " >
									   <xsl:variable name="status" select="Value"/>
										<xsl:call-template name="statusIcon">
											<xsl:with-param name="statusCode" select="$status" />
										</xsl:call-template>
									</xsl:if>	  
								</xsl:for-each>								
								<img width="5" height="1px">
									<xsl:attribute name="src">
										<xsl:value-of select="$ONE_GRAY"/>
									</xsl:attribute>
								</img>	
								
								<xsl:choose>
									<xsl:when test="$typeOfDisplay = $BPV ">
										<a>
											<xsl:attribute name="href">
												<xsl:value-of select="//Rack/Common/DrillDownURL"/>
											</xsl:attribute>
											<font color="white">
												<xsl:value-of select="//Rack/Common/Name"/>
											</font>
										</a>		
									</xsl:when>
									<xsl:otherwise>
											<font color="white">
												<xsl:value-of select="//Rack/Common/Name"/>
											</font>
									</xsl:otherwise>	
								</xsl:choose>	
							</div>
						</td>
					</div>			  
				</tr>	
			<xsl:choose>
				 <xsl:when  test="//Rack[@Empty='true']">               
				 
						<tr>
						<div id="emptyRackTitleBar" style="width: 100%;">       
							<td align="left">
							<xsl:attribute name="style">border:1px solid #000000;</xsl:attribute>
							<table class="window-border-table-small" cellspacing="0" cellpadding="0" border="1"  width="100%">				
								<font color="#cc0000" ><xsl:value-of select="//I18N/L10NTheEmptyRackMessage"/></font>
							</table>
							
							</td>
							</div>
						</tr>	
						

					</xsl:when>
					<xsl:otherwise>
				<tr>
					<td>
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<xsl:attribute name="id"><xsl:value-of select="//Rack/Common/Name"/></xsl:attribute>	
							<tbody>							
                              <xsl:for-each select="*">
												<xsl:apply-templates/> 
								</xsl:for-each>
						</tbody>
					</table>
				</td>
			</tr>
			</xsl:otherwise>
			</xsl:choose>
		 </table>
      </xsl:if>
      
         
	  <xsl:if test="$deviceType='Enclosure'">   
		 <table border="0" cellpadding="0" cellspacing="0" id="bpv" width="100%">
			<tbody>
			   <xsl:for-each select="//BladeEnclosure">
				   <tr>
						<td>
							<xsl:call-template name="renderBPV">
								<xsl:with-param name="encName">
										<xsl:call-template name="getMemberAttr">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
											<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
										</xsl:call-template>
								</xsl:with-param>
								<xsl:with-param name="enclSerialNum">
									<xsl:call-template name="getMemberAttr">
										<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
										<xsl:with-param name="location"><xsl:text>Both</xsl:text></xsl:with-param>
									</xsl:call-template>
								</xsl:with-param>
								<xsl:with-param name="typeOfView"><xsl:text>RackView</xsl:text></xsl:with-param> 
								<xsl:with-param name="deviceSubType" select="$ServerEnc"/>
								<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								<xsl:with-param name="deviceType" select="$deviceType"/>
								<xsl:with-param name="enclosureSubType" select="@subType"/>
							</xsl:call-template>
						</td>
					</tr>	
				</xsl:for-each>
			</tbody>
		</table>
   	</xsl:if>
   
   
		<!--</font>-->
	</xsl:template>
	
	<xsl:template match="BladeEnclosure">
	<tr>
										<td>
											<xsl:call-template name="renderBPV">
												<xsl:with-param name="encName">
													<xsl:call-template name="getMemberAttr">
														<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
														<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
													</xsl:call-template>
												</xsl:with-param>
												<xsl:with-param name="enclSerialNum">
													<xsl:call-template name="getMember">
													<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
													</xsl:call-template>
												</xsl:with-param>
												<xsl:with-param name="typeOfView"><xsl:text>RackView</xsl:text></xsl:with-param> 
												<xsl:with-param name="deviceSubType" select="$ServerEnc"/>
												<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
												<xsl:with-param name="deviceType" select="$deviceType"/>
												<xsl:with-param name="enclosureSubType" select="@subType"/>
											</xsl:call-template>
										</td>
		</tr>
	</xsl:template>
	<xsl:template match="PowerSupplyEnclosure">
	<tr>
									<td>
										<xsl:call-template name="renderBPV">
											<xsl:with-param name="encName">
													<xsl:call-template name="getMemberAttr">
														<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
														<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
													</xsl:call-template>
											</xsl:with-param>
											<xsl:with-param name="enclSerialNum">
												<xsl:call-template name="getMemberAttr">
													<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
													<xsl:with-param name="location"><xsl:text>Both</xsl:text></xsl:with-param>
												</xsl:call-template>
											</xsl:with-param>
											<xsl:with-param name="typeOfView"><xsl:text>RackView</xsl:text></xsl:with-param> 
											<xsl:with-param name="deviceSubType" select="$PowerEnc"/>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											<xsl:with-param name="deviceType" select="$deviceType"/>
										</xsl:call-template>
									</td>
								</tr>		
	</xsl:template>
	
	<xsl:template match="*">
	</xsl:template>
</xsl:stylesheet>
