
PRODNAME="HP BladeSystem Integrated Manager 3.1"
HPSIMNAME="HP Systems Insight Manager 5.1"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
SIM_QUERY="/etc/opt/mx/config/rackable"
SIMLOGS="/var/opt/mx/logs/"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
BSIMLOG="/var/opt/mx/logs/bsim.log"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_51="51050100"
VERSION_511="51105010"
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? -ne 0 ]
    then
        return 1
    fi

    return 0
}
#############################################################
#
# Function: ExitInstaller()
#
# Exits from the Install.sh
#
# Returns nothing
#
#############################################################

ExitInstaller()
{
        echo "$1"
	echo "For more details Refer $BSIMLOG"
        exit "$2"
}

#############################################################
#
# Function: MessageLog()
#
# Logs the messages into LOG file
#
# Returns nothing
#############################################################

MessageLog()
{
	timestamp=`date +%Y-%m-%d\ %T\ %Z`
	echo "$timestamp : $1" >> "$BSIMLOG"
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

#Clear the existing Log
if [ -e "$BSIMLOG" ]
then
        rm -f "$BSIMLOG"
fi
MessageLog "HP BladeSystem Integrated Manager 3.1 installer started."
MessageLog "Waiting for user to continue the installation."

echo
echo
echo  "==============================================="
echo  HP BladeSystem Integrated Manager 3.1
echo 
echo  This product is an enhanced management plug-in for
echo  ${HPSIMNAME}.  The installation
echo  will stop and restart ${HPSIMNAME}
echo  if it is currently running.
echo 
echo  Enter "'y'" to continue this installation.
echo  "===================================================="

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	MessageLog "Installation aborted by user.Exiting now."
        ExitInstaller "Installation was not chosen.  No changes being made." "1"
fi
echo 

#Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
	MessageLog "Checking for root user : failed : user is $user - Exiting now"
        ExitInstaller "This patch must be run by the root user.  No changes being made." "100"
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
        MessageLog "Checking HP SIM version : failed : ${MXVERSION} not found - Exiting now"
        ExitInstaller "${HPSIMNAME} not found.  No changes being made." "200"
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
        MessageLog "Checking HP SIM version : failed : ${MXVERSION} failed to execute - Exiting now"
        ExitInstaller "Failed to execute ${MXVERSION} .  No changes being made." "300"
fi

# extract the version string from the "mxversion" output
verString="$(echo $simVersion | tr -d '.[:alpha:][:blank:][:punct:]'| cut -c1-8)"
echo $verString

MessageLog "Checking HP SIM version, Installed version is :$simVersion"
# Check to see if we can recognize the version of SIM
suppSimVersion="NO"
if [ "$verString" = "$VERSION_51" ]
then
    suppSimVersion="YES"
fi
if [ "$verString" = "$VERSION_511" ]
then
    suppSimVersion="YES"
fi

if [ "$suppSimVersion" != "YES" ]
then 
        MessageLog "Checking HP SIM version : failed : $simVersion found - Exiting now"
        ExitInstaller "${HPSIMNAME} not found.  No changes being made." "500"
fi

echo
MessageLog "Checking HP SIM version : success "
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
wasSIMStarted="FALSE"
GetSIMStatus

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    MessageLog "Stopping the "$simVersion" daemons..."
    echo "Stopping the $simVersion daemons..."
    $MXSTOP  
    # Remember that HP SIM was running so we can restart it at the end
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo 
GetSIMStatus
if [ $? -ne 0 ]
then
	MessageLog "After 30 seconds delay Checking HP SIM Status: HP SIM services stooped"
fi

# install new files
x=`pwd`
cd ${SIM_LIB}

if [ ! -e ${SIM}/bsimbackup/lib/bladeime.bck ]
then
	MessageLog "Backin up the Old BSIM files"
   	mkdir -p ${SIM}/bsimbackup/lib
	MessageLog " Backup the current bladeSystem files"
        echo "Starting Backup up of existing files..."
	MessageLog "BACKUP bladeime.jar"
	cp ${SIM_LIB}/bladeime.jar ${SIM}/bsimbackup/lib/bladeime.bck            
	MessageLog "BackUP Tools"
	cp -R ${SIM2}/tools ${SIM}/bsimbackup/
	MessageLog "BackUP Actions"
        cp -R ${SIM2}/actions ${SIM}/bsimbackup/
	MessageLog "BackUP config"
        cp -R ${SIM3}/config ${SIM}/bsimbackup/
	
	MessageLog "BackUP /opt/hpwebadmin/webapps/ROOT/mxportal/bladeime"
	mkdir -p ${SIM}/bsimbackup/webapps/ROOT/mxportal

	cp -R ${SIM_PORTAL}/bladeime ${SIM}/bsimbackup/webapps/ROOT/mxportal/
	
	MessageLog "BackUP /hpwebadmin/webapps/ROOT/mxportal/DevicePage"
        cp -R ${SIM_PORTAL}/DevicePage ${SIM}/bsimbackup/webapps/ROOT/mxportal/	
	
	MessageLog "BackUP /hpwebadmin/webapps/ROOT/mxportal/home"
        cp -R ${SIM_PORTAL}/home ${SIM}/bsimbackup/webapps/ROOT/mxportal/

	MessageLog "BackUP /hpwebadmin/webapps/ROOT/data"
        cp -R /opt/hpwebadmin/webapps/ROOT/data ${SIM}/bsimbackup/webapps/ROOT/
	
	MessageLog "BackUP Help Documents "
	cp -R /opt/hpwebadmin/webapps/mxhelp/bladeime/* ${SIM}/bsimbackup/
	
	MessageLog "BackUP Complete..."
	echo "BackUP Complete..."

        MessageLog "Now Copying New BladeSystem Manager Files"
	echo "Starting Copy of new files..."
        MessageLog "Copying bladeime.jar..."
        cp "$x"/lib/bladeime.jar ${SIM_LIB}
	
	MessageLog "Copying Tools..."
        cp -R "$x"/tools ${SIM2}/
        MessageLog "Copying Actions..."
        cp -R "$x"/actions ${SIM2}/
        MessageLog "Copying config..."
        cp -R "$x"/config ${SIM3}/

        MessageLog "Copying WebApps..."
        cp -R "$x"/webapps /opt/hpwebadmin/

	MessageLog "Copying HOTFIX..."
	cp -R "$x"/HOTFIX51_003.jar ${SIM}/patch
#	cp -R "$x"/HOTFIX51_006.jar ${SIM}/patch
	cp -R "$x"/HOTFIX51_007.jar ${SIM}/patch
	
	MessageLog "Copying All Queries and SIM properties patch for PCI Blade and other to setup folder ..."
        cp -R "$x"/NodeSubTypeEnums.properties ${SIM2}/setup
        cp -R "$x"/NodeTypeEnums.properties ${SIM2}/setup
	cp -R "$x"/NodeTypeEnums_ja.properties ${SIM2}/setup
        cp -R "$x"/config/rackable/allRackableEnclosures.xml ${SIM2}/setup
        cp -R "$x"/config/vcm/VCDomainCollection.xml ${SIM2}/setup
        #cp -R "$x"/config/vcm/VC_ethmodule.xml ${SIM2}/setup
        cp -R "$x"/tools/iLOToolBox.xml ${SIM2}/setup
        cp -R "$x"/tools/telnetTool.xml ${SIM2}/setup
        cp -R "$x"/tools/OAConfig.xml ${SIM2}/setup
        cp -R "$x"/tools/iLO2Links.xml ${SIM2}/setup

	MessageLog "Copying Help docs..."
        cp -R "$x"/en /opt/hpwebadmin/webapps/mxhelp/bladeime/
	cp -R "$x"/ja /opt/hpwebadmin/webapps/mxhelp/bladeime/
	
	MessageLog "Update Namazu files for content searching..."
	cp -R "$x"/enamazu/* /opt/hpwebadmin/webapps/mxhelp/WEB-INF/cgi/var/en/bladeime/
        cp -R "$x"/jnamazu/* /opt/hpwebadmin/webapps/mxhelp/WEB-INF/cgi/var/ja/bladeime/
	
	MessageLog "deleting the compiled JSP pages so that they can be rebuilt"
	cp -R "$x"/mxportal /opt/mx/jboss/server/hpsim/work/jboss.web/localhost/_/org/apache/jsp/
	MessageLog "Copying files complete...: Successfully"

	# Delete old file that doesnt require in this release
        MessageLog " Deleting Old Status Polling file..."
        if [ -e ${SIM3}/config/polling/StorageDevicePollingProtocol.xml ]
        then
        echo " Device polling file deleted" >>"$BSIMLOG" 2>&1
        rm -f ${SIM3}/config/polling/StorageDevicePollingProtocol.xml
        else
        echo "file is not there" >>"$BSIMLOG" 2>&1
        fi

	# Delete old file that doesnt require in this release
        MessageLog " Deleting Old HOTFIX file..."
        if [ -e ${SIM}/patch/HOTFIX51_006.jar ]
        then
        echo " HOTFIX file deleted" >>"$BSIMLOG" 2>&1
        rm -f ${SIM}/patch/HOTFIX51_006.jar
        else
        echo "file is not there" >>"$BSIMLOG" 2>&1
        fi

else	
	# Copy New BladeSystem Manager Files
        echo "Starting Copy of new files..."
        MessageLog "Starting Copy of new files..."
	MessageLog "Copying bladeime.jar..."
        cp "$x"/lib/bladeime.jar ${SIM_LIB}

        MessageLog "Copying Tools..."
        cp -R "$x"/tools ${SIM2}/
        MessageLog "Copying Actions..."
        cp -R "$x"/actions ${SIM2}/
        MessageLog "Copying config..."
        cp -R "$x"/config ${SIM3}/

        MessageLog "Copying WebApps..."
        cp -R "$x"/webapps /opt/hpwebadmin/

        MessageLog "Copying HOTFIXES..."
        cp -R "$x"/HOTFIX51_003.jar ${SIM}/patch
#        cp -R "$x"/HOTFIX51_006.jar ${SIM}/patch
	cp -R "$x"/HOTFIX51_007.jar ${SIM}/patch
	
	MessageLog "Copying All Queries and SIM properties patch for PCI Blade and other to setup folder ..."
	cp -R "$x"/NodeSubTypeEnums.properties ${SIM2}/setup
	cp -R "$x"/NodeTypeEnums.properties ${SIM2}/setup
	cp -R "$x"/NodeTypeEnums_ja.properties ${SIM2}/setup
	cp -R "$x"/config/rackable/allRackableEnclosures.xml ${SIM2}/setup
	cp -R "$x"/config/vcm/VCDomainCollection.xml ${SIM2}/setup
	#cp -R "$x"/config/vcm/VC_ethmodule.xml ${SIM2}/setup
	cp -R "$x"/tools/iLOToolBox.xml ${SIM2}/setup
	cp -R "$x"/tools/telnetTool.xml ${SIM2}/setup
	cp -R "$x"/tools/OAConfig.xml ${SIM2}/setup
	cp -R "$x"/tools/iLO2Links.xml ${SIM2}/setup


	MessageLog "Copying Help docs..."
        cp -R "$x"/en /opt/hpwebadmin/webapps/mxhelp/bladeime/
        cp -R "$x"/ja /opt/hpwebadmin/webapps/mxhelp/bladeime/
        
	MessageLog "Update Namazu files for content searching..."
        cp -R "$x"/enamazu/* /opt/hpwebadmin/webapps/mxhelp/WEB-INF/cgi/var/en/bladeime/
        cp -R "$x"/jnamazu/* /opt/hpwebadmin/webapps/mxhelp/WEB-INF/cgi/var/ja/bladeime/


	MessageLog "deleting the compiled JSP pages so that they can be rebuilt"
	cp -R "$x"/mxportal /opt/mx/jboss/server/hpsim/work/jboss.web/localhost/_/org/apache/jsp/
	
	# Delete old file that doesnt require in this release
	MessageLog " Deleting Old Status Polling file..."
        if [ -e ${SIM3}/config/polling/StorageDevicePollingProtocol.xml ]
        then
        echo " Device polling file deleted" >>"$BSIMLOG" 2>&1
        rm -f ${SIM3}/config/polling/StorageDevicePollingProtocol.xml
        else
        echo "file is not there" >>"$BSIMLOG" 2>&1
        fi

	# Delete old file that doesnt require in this release
        MessageLog " Deleting Old HOTFIX file..."
        if [ -e ${SIM}/patch/HOTFIX51_006.jar ]
        then
        echo " HOTFIX file deleted" >>"$BSIMLOG" 2>&1
        rm -f ${SIM}/patch/HOTFIX51_006.jar
        else
        echo "file is not there" >>"$BSIMLOG" 2>&1
        fi

fi

	echo "Copying files complete..." 
	MessageLog "Copying files complete...: Successfully"
	echo "Restarting ${HPSIMNAME} daemons...."
	MessageLog "Restarting ${HPSIMNAME} daemons...."
	echo "This will take couple of minutes...."
	$MXSTART
	$SLEEP 30
	SIMStatus=1
	while [ $SIMStatus -ne 0 ]
	do
        	$SLEEP 10
        	wasSIMStarted="TRUE"
		GetSIMStatus
		SIMStatus=`echo $?`
	done

	if [ $wasSIMStarted = "TRUE" ]
	then
	        MessageLog "Starting HP SIM : success"
	else
        	MessageLog "Starting HP SIM : Failed"
	fi
	cd ${SIM_TOOLS}
	MessageLog "Starting HP BSIM tool updation"
	
	if [ -e ${SIM_BIN}/mxtool ] 
	then
		MessageLog "Updating BSIM version ..."
		${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/bladeimeVersion.xml>>"$BSIMLOG" 2>&1
		${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/bladeimeVersion.xml>>"$BSIMLOG" 2>&1

		MessageLog "Updating all links and tree View..."
		#${SIM_BIN}/mxtoolbox -a -f ${SIM_TOOLS}/iLOToolBox.xml>>"$BSIMLOG" 2>&1
		#${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/telnetTool.xml>>"$BSIMLOG" 2>&1
		#${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/OAConfig.xml>>"$BSIMLOG" 2>&1
		#${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/iLO2Links.xml>>"$BSIMLOG" 2>&1

		#${SIM_BIN}/mxquery -a -f ${SIM_QUERY}/allRackableEnclosures.xml>>"$BSIMLOG" 2>&1
		${SIM_BIN}/mxcollection -m mem -f ${SIM_QUERY}/modifyHPBS.xml>>"$BSIMLOG" 2>&1
		${SIM_BIN}/mxstm -a -f ${SIM3}/config/vcm/stmrules_snmp.xml>>"$BSIMLOG" 2>&1
		MessageLog "All links, Tree View and version updated..."
		MessageLog "BSIM update complete successfully...: Success"
		echo "HP BLADESYSTEM INTEGRATED MANAGER 3.1 UPDATE COMPLETE. YOU CAN DELETE THE EXTRACTED FOLDER." 
  	else
	    	
		MessageLog "HP BSIM tool update : failed : MXTOOL DOES NOT EXIST :HP BladeSystem Integrated Manager UPDATE FAILED."
	        ExitInstaller "MXTOOL DOES NOT EXIST \n HP BladeSystem Integrated Manager UPDATE FAILED." "1"
	fi
		

