
PRODNAME="HP BladeSystem Integrated Manager 3.1"
HPSIMNAME="HP Systems Insight Manager 5.1"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
SIM_QUERY="/etc/opt/mx/config/rackable"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_51="51050100"
VERSION_511="51105010"
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? -ne 0 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo "===================================================="
echo "HP BladeSystem Integrated Manager 3.1 Uninstall"
echo "This will move HP BladeSystem Integrated Manager 3.1"
echo "to 2.3"
echo
echo "Enter "'y'" to continue this uninstall of "
echo "HP BladeSystem Integrated Manager 3.1 "
echo "===================================================="

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Uninstall was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

echo $cmsOS

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made"
    exit 300
fi

# extract the version string from the "mxversion" output
cmsOS=$(uname -s)
verString="$(echo $simVersion | tr -d '.[:alpha:][:blank:][:punct:]'| cut -c1-8)"
echo $verString

# Check to see if we can recognize the version of SIM
# Check to see if we can recognize the version of SIM
suppSimVersion="NO"
if [ "$verString" = "$VERSION_51" ]
then
    suppSimVersion="YES"
fi
if [ "$verString" = "$VERSION_511" ]
then
    suppSimVersion="YES"
fi

if [ "$suppSimVersion" != "YES" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
fi
echo
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
GetSIMStatus

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    echo
    echo "Stopping the ${HPSIMNAME} daemons..."
    $MXSTOP  
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo 
GetSIMStatus
if [ $? -ne 0 ]
then
	 echo "After 30 seconds delay Checking HP SIM Status: HP SIM services stopped"
fi


# copy old files again
x=`pwd`

if [ -e ${SIM}/bsimbackup/lib/bladeime.bck ]
then
	
	echo "Starting HP BladeSystem Integrated Manager 3.1 Restore"
	${SIM_BIN}/mxstm -r -f ${SIM_TOOLS}/stmrules_snmp.xml
	#echo "RESTORE bladeime.jar"
        cp ${SIM}/bsimbackup/lib/bladeime.bck ${SIM_LIB}/bladeime.jar
        
	#echo "Restore Tools"
        cp -R ${SIM}/bsimbackup/tools ${SIM2}/
        #echo "Restore Actions"
        cp -R ${SIM}/bsimbackup/actions ${SIM2}/
        #echo "Restore config"
        cp -R ${SIM}/bsimbackup/config ${SIM3}/

        #echo "Restore /webapps/ROOT/mxportal/bladeime"
        cp -R ${SIM}/bsimbackup/webapps/ROOT/mxportal/bladeime ${SIM_PORTAL}/

        #echo "Restore /hpwebadmin/webapps/ROOT/mxportal/DevicePage"
        cp -R ${SIM}/bsimbackup/webapps/ROOT/mxportal/DevicePage ${SIM_PORTAL}/

        #echo "Restore /hpwebadmin/webapps/ROOT/mxportal/home"
        cp -R ${SIM}/bsimbackup/webapps/ROOT/mxportal/home ${SIM_PORTAL}/

        #echo "Restore /hpwebadmin/webapps/ROOT/data"
        cp -R ${SIM}/bsimbackup/webapps/ROOT/data /opt/hpwebadmin/webapps/ROOT/

        #echo "Restore Help Documents "
	cp -R ${SIM}/bsimbackup/en /opt/hpwebadmin/webapps/mxhelp/bladeime/
	cp -R ${SIM}/bsimbackup/ja /opt/hpwebadmin/webapps/mxhelp/bladeime/
	
	echo "Deleting HOTFIX..."
	rm -rf ${SIM}/patch/HOTFIX51_003.jar
#	rm -rf ${SIM}/patch/HOTFIX51_006.jar
	rm -rf ${SIM}/patch/HOTFIX51_007.jar
        #echo delete precompiled jsp 
	rm -rf /opt/mx/jboss/server/hpsim/work/jboss.web/localhost/_/org/apache/jsp/mxportal/bladeime/*
	echo "Restore Complete..."
	#Message "Copying All Queries and SIM properties patch for PCI Blade and other to setup folder ..."
	cp -R "$x"/NodeSubTypeEnums.properties ${SIM2}/remove
	cp -R "$x"/NodeTypeEnums.properties ${SIM2}/remove
	cp -R "$x"/NodeTypeEnums_ja.properties ${SIM2}/remove
	cp -R "$x"/config/rackable/allRackableEnclosures.xml ${SIM2}/remove
	cp -R "$x"/config/vcm/VCDomainCollection.xml ${SIM2}/remove
	#cp -R "$x"/config/vcm/VC_ethmodule.xml ${SIM2}/setup
	cp -R "$x"/tools/iLOToolBox.xml ${SIM2}/remove
	cp -R "$x"/tools/telnetTool.xml ${SIM2}/remove
	cp -R "$x"/tools/OAConfig.xml ${SIM2}/remove
	cp -R "$x"/tools/iLO2Links.xml ${SIM2}/remove

echo "Restarting ${HPSIMNAME} daemons..."
echo "This would take couple of minutes..."
$MXSTART 
$SLEEP 30
SIMStatus=1
while [ $SIMStatus -ne 0 ]
do
       	$SLEEP 10
       	wasSIMStarted="TRUE"
	GetSIMStatus
	SIMStatus=`echo $?`
done

cd ${SIM_TOOLS}
	if [ -e bladeimeVersion.xml ] 
	then
		#cp ${SIM}/bsimbackup/tools/bladeimeVersion.bck ${SIM_TOOLS}/bladeimeVersion.xml
	 	echo "HP BLADESYSTEM INTERAGTED MANAGER VERSION FILE COPIED"
	   
	  	if [ -e ${SIM_BIN}/mxtool ] 
	  		then
	   	        ${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/bladeimeVersion.xml
		        ${SIM_BIN}/mxtool -a -f ${SIM}/bsimbackup/tools/bladeimeVersion.xml
			echo "Updating all links and tree View..."
                        #${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/telnetTool.xml
                        #${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/OAConfig.xml
                        #${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/iLO2Links.xml
			#${SIM_BIN}/mxtoolbox -r -f ${SIM_TOOLS}/iLOToolBox.xml			

			#${SIM_BIN}/mxquery -r -f ${SIM_QUERY}/allRackableEnclosures.xml
                        ${SIM_BIN}/mxcollection -m mem -f ${SIM_QUERY}/restoreHPBS.xml
			echo "HP BLADESYSTEM INTEGRATED MANAGER 3.1 RESTORE COMPLETE."		
	    	else
		    	echo "MXTOOL DOES NOT EXIST"	
		    	echo "HP BLADESYSTEM INTEGRATED MANAGER 3.1 RESTORE FAILED."
		exit			
		fi	
				  
	else
	        echo "HP BLADESYSTEM INTEGRATED MANAGER 3.1 VERSION CHANGE FAILED."
        exit
	fi		
else
echo "HP BLADESYSTEM INTEGRATED MANAGER 3.1 BACKUP NOT FOUND. RESTORE FAILED."
exit
fi
