<%
/*************************************************************************************************
 ** File         : BladeIMEBPVEventFrame.jsp
 ** Dependencies :
 ** Description  : This class is responsible for creating two frames in the event page, with 
 **				   criteria in the top one and results in the bottom.
 ** @author      : Prakash C Rao
 ** @created     : Sep 26, 2005
 ** (C) Copyright 2001-2006, Hewlett-Packard Company, All Rights Reserved.
 *************************************************************************************************
 */
%>

<%@ page import="com.hp.mx.portal.ui.MxBean"%>
<%@ page import="com.hp.mx.portal.ui.MxOptions"%>
<%@ page import="com.hp.mx.html.core.MxHtmlUtil"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session"/>

<%
    MxBean.jspInit(request, response);

    String target = request.getParameter("target");

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
        return;
%>

<html>
<head>
	<script>
		function myLoad()
		{
			var oSelf = parent.document.getElementById("ID_WORKSPACE");
			oSelf.style.height = 800;
		}
	</script>
</head>
	<body class="body-flush-fit-no-scrolling" onload="myLoad()">
	<br>
		<iframe name="eventCriteriaFrame" id="topID" frameborder="0" marginwidth="0" width="100%" height="30"
			src="<%=MxOptions.URL_BASE%>/bladeime/events/BladeIMEBPVEventCriteria.jsp?target=<%=MxHtmlUtil.encodeHtmlEntities(target)%>">
		</iframe>
		<iframe name="eventResultsFrame" id="bottomID" frameborder="0" marginwidth="0" width="100%" height="400"
			src="<%=MxOptions.URL_BASE%>/bladeime/events/BladeIMEBPVEventResults.jsp?target=<%=MxHtmlUtil.encodeHtmlEntities(target)%>">
		</iframe>
	</body>
</html>
