<%
/*************************************************************************************************
 ** File         : BladeIMEBPVEventResults.jsp
 ** Dependencies :
 ** Description  : This class is responsible for displaying events for the selected choice.
 ** @author      : 
 ** @created     : Sep 26, 2005
 ** (C) Copyright 2001-2004, Hewlett-Packard Company, All Rights Reserved.
 *************************************************************************************************
 */
%>

<%@ page import="com.hp.mx.portal.events.EventException"%>

<%@ page import="com.hp.mx.portal.ui.MxBean"%>
<%@ page import="com.hp.mx.core.nodemanager.MxNode"%>
<%@ page import="com.hp.mx.core.objectmodel.MxObjectID"%>
<%@ page import="com.hp.mx.core.objectmodel.MxGUID"%>
<%@ page import="com.hp.mx.portal.ui.MxOptions"%>
<%@ page import="com.hp.mx.html.core.MxHtmlUtil"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="eventsBean" class="com.hp.mx.portal.events.EventsBean" scope="session" />

<%
    MxBean.jspInit(request, response);

    // REQUIRED: This aborts the page if the session is invalid.
    if (loginBean.checkLogoutConditionForWebPage(pageContext))
        return;

	String eventType = request.getParameter("eventType");
	String filterQueryName = request.getParameter("filterQName");
	
	if (eventType == null || eventType.equals("null"))
	{
		String target = request.getParameter("target");

		MxNode mxNode = (loginBean.getNodeCtlr()).getNode((new MxObjectID(new MxGUID(target))), false);

		if (mxNode == null)
		{
%>
			<jsp:forward page="<%=MxOptions.URL_BASE + "/bladeime/events/BladeIMEBPVEventErrorPage.jsp"%>"/>
<%
		}
		
		try
		{
			eventsBean.init(mxNode, loginBean);
			String[][] bpvEventsQueryIdList = eventsBean.getBPVEventsList(loginBean);
			eventType = bpvEventsQueryIdList[1][0];
		}
		catch(EventException e)
		{
%>
			<jsp:forward page="<%=MxOptions.URL_BASE + "/bladeime/events/BladeIMEBPVEventErrorPage.jsp"%>"/>
<%
		}
	}

	int tempDynQueryId;
	try
	{
		tempDynQueryId = eventsBean.getQueryId(eventType, filterQueryName, loginBean);
	}
	catch(Exception e)
	{
%>
		<jsp:forward page="<%=MxOptions.URL_BASE + "/bladeime/events/BladeIMEBPVEventErrorPage.jsp"%>"/>
<%
	}
%>

<html>
<head>
<title></title>
<link type='text/css' rel='stylesheet' href='css/MxSearch.css'>
<script src="/SessionReset.js" language="JavaScript" type="text/javascript"></script>
<script language="JAVASCRIPT">

	var PageName     = "viewContentsEvents";
    var queryId = "<%=tempDynQueryId%>";

    var url = "/ui/jsp/XeHdr.jsp";

    var params  = "PageName=" + PageName;
    params     += "&viewid=" + queryId;

    url = url + "?" + params + "&suppressHeader=1&disableSystemLink=1&ViewType=EventViews&suppressCustomize=1";

    // display selected list
    document.location.replace(url);
</script>
</head>

<body>
</body>
</html>

