 <%@page errorPage = "OAConfigErrorHandler.jsp"%>
<%@page import="java.util.Enumeration,
				java.util.Hashtable,	
				java.util.Arrays,
				com.hp.mx.portal.ui.MxOptions,
				com.hp.mx.core.tools.datacollection.soap.oa.SOAPCustomHandler,
				com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationIntf,
				com.hp.mx.core.tools.datacollection.soap.oa.OAFileHandler,
				com.hp.mx.portal.i18n.MonteroResourceManager,				
				com.hp.mx.portal.ui.MxBean,
				com.hp.mx.core.objectmodel.MxObjectID,
		        com.hp.mx.core.client.MxNodeClient,
		        com.hp.mx.core.objectmodel.MxGUID,
				com.hp.mx.core.nodemanager.MxNode"
%>
				
<%@page import="java.net.*,javax.servlet.*"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean class="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicatorSessionBean" id="OACommunicatorSessionBean" scope="session"/>

<%
	MxBean.jspInit(request, response);

	if(loginBean.checkLogoutConditionForWebPage(pageContext))
	{
		return;
	}

	rbPortal.init(loginBean, "MxPortal");

	String ipAddress = request.getParameter("ipAddress");
	//get the soap object from the session bean
	OACommunicationIntf soapObj = OACommunicatorSessionBean.getOACommunicator(ipAddress);

	//create mxnode for OA to get the system name
	String guid = soapObj.getGuid();
	MxObjectID objID = new MxObjectID(new MxGUID(guid));
	MxNodeClient nodeClient = loginBean.getNodeCtlr();
	MxNode oaNode = nodeClient.getNode(objID, false);
	String systemName = oaNode.getNameString();	


	//get the list of the configuration files for the OA
	OAFileHandler oaFileHandlerObj = new OAFileHandler();

	//get the guid of the stand by oa
	String standByOaGuid = oaFileHandlerObj.getStandByOaGuid(String.valueOf(oaNode.getDeviceKey()));
	if(standByOaGuid == null)
	{
		standByOaGuid = "";
	}

	Hashtable configFiles = oaFileHandlerObj.getConfigFiles(guid, standByOaGuid );	
	Enumeration keys = configFiles.keys();
	String tmpKey;

	//get i18n strings
	String i18nCfgTitle				=	MonteroResourceManager.getInstance().getString("oaconfig.cfgTitle", loginBean.getLocale());
	String i18nCfgScript			=	MonteroResourceManager.getInstance().getString("oaconfig.configScript", loginBean.getLocale());
	String i18nLoginMainTitle		=	MonteroResourceManager.getInstance().getString("oaconfig.configLoginMainTitle", loginBean.getLocale());

	//for save
	String i18nSaveTitle			=	MonteroResourceManager.getInstance().getString("oaconfig.saveTitle", loginBean.getLocale());
	String i18nSaveCurConfiguration	=	MonteroResourceManager.getInstance().getString("oaconfig.saveCurConfiguration", loginBean.getLocale());
	String i18nName					=	MonteroResourceManager.getInstance().getString("xml.Name", loginBean.getLocale());
	String i18nSave					=	MonteroResourceManager.getInstance().getString("oaconfig.save", loginBean.getLocale());
	
	//for restore
	String i18nRestoreConfig		=	MonteroResourceManager.getInstance().getString("oaconfig.restoreConfig", loginBean.getLocale());
	String i18nRestoreTitle			=	MonteroResourceManager.getInstance().getString("oaconfig.restoreTitle", loginBean.getLocale());
	String savedConfigurations		=	MonteroResourceManager.getInstance().getString("oaconfig.savedConfigurations", loginBean.getLocale());
	String i18nTotal				=	MonteroResourceManager.getInstance().getString("oaconfig.total", loginBean.getLocale());
	String i18nRestore				=	MonteroResourceManager.getInstance().getString("oaconfig.restore", loginBean.getLocale());
	String i18nNoConfigsSaved		=	MonteroResourceManager.getInstance().getString("oaconfig.noConfigsSaved", loginBean.getLocale());

	//for deletion
	String i18nDelete				=	MonteroResourceManager.getInstance().getString("oaconfig.delete", loginBean.getLocale());
	String i18nBack					=	MonteroResourceManager.getInstance().getString("oaconfig.back", loginBean.getLocale());

	//link to tools & link page used for the back button
	String toolsLinksPageUrl		= 	"/mxportal/DevicePage/devicepage.jsp?nodeId=" + guid + "&selection=ID_LINKS&index=1";

	//check if this page is loaded after restore operation, if so get the status to display the msg
	String restoreStatus = request.getParameter("restoreStatus");
%>
<html>
<head>
	<link rel="stylesheet" type="text/css" href="<%=MxOptions.URL_BASE%>\bladeime\skin\css\default.css">
	<link rel="stylesheet" type="text/css" href="<%=MxOptions.URL_BASE%>\bladeime\skin\css\blue_theme.css">
</head>

<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\buttonManager.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\global.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\skin.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\js\MxPortalApi.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\oaconfig.js" language="JavaScript" type="text/javascript"></script>

<script language='JavaScript' type='text/javascript'>
	globalManagerCreate();
	MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_enclosureView");
</script>

<body>
<%
	if(restoreStatus != null && restoreStatus.equalsIgnoreCase("ok"))
		out.println(MonteroResourceManager.getInstance().getString("oaconfig.restore.success", loginBean.getLocale()));
%>
<form name = "frm" method="post" action="ProgresBarForOAProcessConfigRequest.jsp" onKeyDown="return handleEnteryKey(event)">

	<input type = "hidden" name = "ipAddress" value = "<%=ipAddress%>">
	<input type=hidden name="reqType">
	
	<p><b><font size="2"><%=i18nCfgScript%></font></b></p>
	<p><font size="2"><%=i18nSaveTitle%></font></p>	
	<p><b><font size="2"><%=i18nSaveCurConfiguration%></font></b></p>
	
	<!-- save section -->
	<table border="1" width="55%" id="table7" cellspacing="0" cellpadding="2">
		<tr><td>
	
			<!--  save config -->
			<table border="0" width="100%" id="table8">
				<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>
				<tr>
					<td  valign="top">&nbsp;<b><font size="2"><%=i18nName%> :</font></td>
					<td valign="top"><input type="text" name="fileName" size="30" onKeyUp="setSaveBtnState()" maxlength="100"></td>
					<td><div class='bWrapperUp'><div><div><button type='button' class='hpButton' style="width:100" onClick="saveConfigFile()" id="saveBtn"><%=i18nSave%></button></div></div></div>&nbsp;&nbsp;</td>
					<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>
				</tr>
			</table>
			<!--  end of save config -->
			
		</td></tr>
	</table> 
	<!--  end of save table -->
	
	<br><br>

	<hr width="55%" style="height: 2px" align="left">

	<p><b><font size="2"><%=i18nRestoreConfig%><br><br></font></b>
	<font size="2"><%=i18nRestoreTitle%></font></p>

<!-- start of restore table -->
<table border="0" width="65%" id="table9">
	<tr><td>
		<table border="0" width="60%" id="filesList" cellspacing="0" cellpadding="0">
			<tr><td width="100%">
				<table style="PADDING-TOP: 3px" border="0" cellpadding="0" cellspacing="0" class="dataTable" style="width:400" id="fileId">
					 <caption>
						 <%=savedConfigurations%>  &nbsp;&nbsp;&nbsp;<%=i18nTotal%> : <%=configFiles.size()%>
					 </caption>		

					<thead>
						<tr style="background-color:#968F89;">
							<th  align="left" width="30">&nbsp;<input type="checkbox" onClick="highlightWholeConfigTable()" name="selectAll" value="ON"></th>
							<th  align="left">&nbsp;<%=i18nName%></th>						
						</tr>
					</thead>
						
					<tbody>
					<input type="checkbox" name="chkFilePath" value="tmpChk" style="visibility:hidden">
						<%
							//if no files are saved
							if(configFiles.size() == 0) 
							{
						%>			<tr><td colspan="2"><%=i18nNoConfigsSaved%></td></tr>
						<% 	}
							else
							{									
								//display all the file names for restoring
								keys = configFiles.keys();
								String names[] = new String[configFiles.size()];
								String className = "";
								int i = 0;		
								//get all the keys in a string array
								while(keys.hasMoreElements())
								{
									names[i] = (String)keys.nextElement();
									i++;
								}

								//sort them
								Arrays.sort(names);

								i=0;
								while(i<configFiles.size())
								{
									tmpKey = names[i];

									if(i%2 != 0)
									 className = "altRowColor";
									else
										className="";
									i++;
							%>
									<tr class="<%=className%>" id="<%=tmpKey%>">
										<td width="30"><input type="checkbox" name="chkFilePath" value="<%=tmpKey%>" onClick="highlightConfigRow()"></td>
										<td><font size="2"><%=configFiles.get(tmpKey)%></font></td>
									</tr>
							<%
								} //end of while
							} // end of if files found
							%>
	
			</div></tbody>
		</table> <!--  end of file name table -->
		</td>
		<td>&nbsp;</td> <!--  a blank row -->
	</tr>
	</table> <!--  end of second table -->
	</td></tr>
		<tr><td>&nbsp;<br></td></tr>
		<tr>
			<td valign="bottom">
			<div class='bWrapperUp'><div><div><button type='button' class='hpButton' style="width:100" onClick="goToToolsAndLinksPage()"  id="backBtn"><%=i18nBack%></button></div></div></div>
			<div class='bWrapperUp'><div><div><button type='button' class='hpButton' style="width:100" onClick="deleteConfigFile()" id="deleteBtn"><%=i18nDelete%></button></div></div></div>
			<div class='bWrapperUp'><div><div><button type='button' class='hpButton' style="width:100" onClick="restoreConfig()"  id="restoreBtn"><%=i18nRestore%></button></div></div></div>
			<p>&nbsp;</td>
		</tr>
	</table> <!--  end of restore -->

</form>
</body>
<script>

	//hide the progress bar and load the actual page
	if(parent.hideLoading)
	{
		parent.hideLoading();
	}

	var fileList = new Array();
	addFileNameToFileList();

	//disable all buttons by default
	ourButtonManager.disableButtonById("restoreBtn");
	ourButtonManager.disableButtonById("deleteBtn");
	ourButtonManager.disableButtonById("saveBtn");

	//set the main title
	 //append the OA name with the title
	 var title = "<%=i18nLoginMainTitle%>";

	 <%
		 if(systemName != null && !systemName.equals(""))
		{
	 %>
				title = title + " (" + "<%=systemName%>" + ")";
	 <%
			}
	 %>

	 //set the main title
	 MxPortalWorkspaceSetTitleHtml(title);


	 //set the sub title
	 MxPortalWorkspaceSetSubtitleHtml("<%=i18nCfgTitle%>");

	//client side validation localised error messages
	var i18nNameExists				=	"<%=MonteroResourceManager.getInstance().getString("oaconfig.validateNameExists", loginBean.getLocale())%>"
	var i18nNameStartWithAlphabet	=	"<%=MonteroResourceManager.getInstance().getString("oaconfig.validateNameStart", loginBean.getLocale())%>"
	var i18nNameValidateChars		=	"<%=MonteroResourceManager.getInstance().getString("oaconfig.validateNameSpecialChars", loginBean.getLocale())%>"
	var i18nConfirmDelete			=	"<%=MonteroResourceManager.getInstance().getString("oaconfig.confirmDelete", loginBean.getLocale())%>"
	var i18nName					=	"<%=i18nName%>"

//add file names to javascript array
//this array will be used, to check for existing file name while saving a new file
function addFileNameToFileList()
{
	<%
		keys = configFiles.keys();		
		while(keys.hasMoreElements())
		{
			tmpKey = (String)keys.nextElement();
	%>
			fileList[fileList.length] ="<%=configFiles.get(tmpKey)%>"
	<%
		}
	%>
}

//highlights the table, as a result of select All option
function highlightWholeConfigTable()
{
	//don't highlight the row, if it's blank
	var filesCnt = "<%=configFiles.size()%>"
	if(filesCnt == 0)
		return false;
		
	var n = document.getElementById("fileId").rows.length;

	for(i=0;i<n;i++)
	{
		if(document.frm.selectAll.checked)
		{		
			document.getElementById("fileId").rows[i].className="rowHighlight";
			document.frm.chkFilePath[i].checked = true;
		}
		else
		{
			document.frm.chkFilePath[i].checked = false;
			document.getElementById("fileId").rows[i].className="";
			if(i%2 != 0)
				document.getElementById("fileId").rows[i].className="altRowColor";		
		}
	}
	setConfigButtonState();
}

//go to tools & links page (back option)
function goToToolsAndLinksPage()
{
	window.location.href	= "<%=toolsLinksPageUrl%>";
}
</script>
</html>

