<%@page errorPage = "OAConfigErrorHandler.jsp"%>
<%@page import="com.hp.mx.core.nodemanager.MxNode,
				 com.hp.mx.core.controllers.MxNodeController,
				 com.hp.mx.portal.ui.MxOptions,
				 com.hp.mx.core.tools.datacollection.http.oa.OAHelper,
 				 com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator,
				 com.hp.mx.portal.core.MxObjList,
				 com.hp.mx.core.objectmodel.MxObjectID,
		         com.hp.mx.core.client.MxNodeClient,
		         com.hp.mx.core.objectmodel.MxGUID,
				 com.hp.mx.portal.i18n.MonteroResourceManager,
				 com.hp.mx.portal.ui.MxBean,
				 com.hp.mx.utilities.DebugSubsystem,
				 java.net.SocketException,
				 com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationIntf"
%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="selectionBean" class="com.hp.mx.portal.core.MxObjSelections" scope="session" />
<jsp:useBean class="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicatorSessionBean" id="OACommunicatorSessionBean" scope="session"/>

<html>
<head>
	<link rel="stylesheet" type=text/css href="<%=MxOptions.URL_BASE%>/bladeime/skin/css/blue_theme.css">
	<link rel="stylesheet" type=text/css href="<%=MxOptions.URL_BASE%>/bladeime/skin/css/default.css">
	<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxTools.css'>
</head>

<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\buttonManager.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\global.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\skin.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\js\MxPortalApi.js" language="JavaScript" type="text/javascript"></script>
<script src="<%=MxOptions.URL_BASE%>\bladeime\skin\js\oaconfig.js" language="JavaScript" type="text/javascript"></script>

<script language='JavaScript' type='text/javascript'>
	globalManagerCreate();
	MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_enclosureView");
</script>

<body>
<%
	MxBean.jspInit(request, response);
	
	if(loginBean.checkLogoutConditionForWebPage(pageContext))
	{
		return;
	}

	rbPortal.init(loginBean, "MxPortal");

	//check for the sign in faliure, to display msg on top
	//error msg will have value, when it's redirected from the OAProcesslogin.jsp
	String errorMsg = request.getParameter("errorMsg");

	if(errorMsg != null)
	{
		String causeMsg = request.getParameter("causeMsg");
		String actionMsg = request.getParameter("actionMsg");
		if(causeMsg == null)
		{
			causeMsg = "";
		}
		if(actionMsg == null)
		{
			actionMsg = "";
		}
	%>
		<p class="error-instruction"><%=errorMsg%><%=causeMsg%><%=actionMsg%></p>
	<%
	}

	//get the i18n strings
	String i18nUserName						=	MonteroResourceManager.getInstance().getString("oaconfig.userName", loginBean.getLocale());
	String i18nPassword						=	MonteroResourceManager.getInstance().getString("oaconfig.password", loginBean.getLocale());
	String i18nNext							=	MonteroResourceManager.getInstance().getString("oaconfig.next", loginBean.getLocale());
	String i18nLoginFailedMsg				=	MonteroResourceManager.getInstance().getString("oaconfig.loginErrorMsg", loginBean.getLocale());
	String i18nLoginSubTitle				=	MonteroResourceManager.getInstance().getString("oaconfig.loginSubTitle", loginBean.getLocale());
	String i18nLoginMainTitle				=	MonteroResourceManager.getInstance().getString("oaconfig.configLoginMainTitle", loginBean.getLocale());
	String i18nStandByOaErrMsg				=	MonteroResourceManager.getInstance().getString("oaconfig.secondaryOAErrorMsg", loginBean.getLocale());
	String i18nStandByOaUnsupportedErrMsg	=	MonteroResourceManager.getInstance().getString("oaconfig.secondaryOAUnsupportedErrorMsg", loginBean.getLocale());		

	//get the ipaddress from the supplied key
	String deviceKey = request.getParameter("devId");
	String tmpGuid = "";
	String systemName = "";
	DebugSubsystem LOGGER = new DebugSubsystem(OALogin_jsp.class);

	//if device key is null, it indicates this page is visited from the Configure menu
	if(deviceKey == null)
	{
			//get the selected device from the global selection bean
			MxObjList mxObjList = selectionBean.getObjList();

			for (int i=0;i<mxObjList.size();i++)
			{	
				tmpGuid =(mxObjList.get(i)).getGuid();
			}
			MxObjectID objID = new MxObjectID(new MxGUID(tmpGuid));
			MxNodeClient nodeClient = loginBean.getNodeCtlr();
			MxNode node1 = nodeClient.getNode(objID, false); 
			deviceKey = String.valueOf(node1.getDeviceKey());
			systemName = node1.getNameString();
	}
	
	if(deviceKey != null)
	{
		MxNode node = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(Integer.parseInt(deviceKey));	
	
		//get ip address
		String OAIPAddress;
		OAIPAddress = node.getWorkingAddress();
		String guid = node.getGUID().toString();
		systemName = node.getNameString();
		
		//check if this for the secondary OA.
		OAHelper oaHelper = OAHelper.getOAHelper();
		OnboardAdministrator oAObj = (OnboardAdministrator)oaHelper.getOLDevice(node, node);
		
		//save restore option not supported for the secondary oa
		if(oAObj.getIsPrimary() == false && OAIPAddress != null)
		{
	%>	
			<b><p class="error-instruction"><%=i18nStandByOaErrMsg%><br>
			<br><%=i18nStandByOaUnsupportedErrMsg%></p></b>	
	<% 	
		}
		else
		{
	%>

<form method="POST" name="frm" onKeyDown="return handleEnteryKey(event)">
	<input type="hidden" name="ipAddress" value= "<%=OAIPAddress%>"/>
	<input type="hidden" name="guid" value= "<%=guid%>"/>
	<input type="hidden" name="devId" value= "<%=deviceKey%>"/>
<% 
	//check if the user has already logged in, then redirect to configuration page
	//no need to prompt for the credentials again
	if(OACommunicatorSessionBean.userAlreadyLoggedIn(OAIPAddress))
	{		
		//get the current guid, check if node exists with that guid, if not
		//display login page and remove from the session
		//this occurs when the node is deleted and rediscovered
		//as a result, the guid will change
		try
		{
			OACommunicationIntf soapObj = OACommunicatorSessionBean.getOACommunicator(OAIPAddress);			
			String newGuid = soapObj.getGuid();
			MxObjectID objID = new MxObjectID(new MxGUID(newGuid));
			MxNodeClient nodeClient = loginBean.getNodeCtlr();
			MxNode oaNode = nodeClient.getNode(objID, false);
			//node exists, so redirect to Config page
%>
			<jsp:forward page="OAConfiguration.jsp">
				<jsp:param name="ipAddress" value="<%=OAIPAddress%>"/>
			</jsp:forward>
<%
		}
		catch(Exception e)
		{			
			//node with supplied guid does n't exist
			LOGGER.panic("OALogin.jsp \n " + e.toString());
			OACommunicatorSessionBean.deleteOACommunicator(OAIPAddress);
		}	
	}
%>
	<table border="0" width="50%" id="table1">		
		<tr>
			<td align="right"><b><%=i18nUserName%> :</b></td>
			<td><input type="text" name="userName" size="20" onKeyUp="setLoginBtnState()"></td>
		</tr>		
		<tr>
			<td align="right" height="25"><b><%=i18nPassword%> :</b></td>
			<td height="25"><input type="password" name="password" size="20" onKeyUp="setLoginBtnState()"></td>
		</tr>		
		<tr>
			<td align="right" colspan="2">			
				<div class='bWrapperUp'><div><div><button type='button' class='hpButton' onclick="loginToOA()"  id='next' tabindex='101' ><%=i18nNext%></button></div></div></div></td>
		</tr>		
	</table>	
</form>
</body>

<script language="javascript">

	 //disable next button by default, will be enabled on key press of username/pwd
	 ourButtonManager.disableButtonById("next");

	 //append the OA name with the title
	 var title = "<%=i18nLoginMainTitle%>";

	 <%
		 if(systemName != null && !systemName.equals(""))
		{
	 %>
				title = title + " (" + "<%=systemName%>" + ")";
	 <%
			}
	 %>

	 //set the main title
	 MxPortalWorkspaceSetTitleHtml(title);

     //set the sub title
	 MxPortalWorkspaceSetSubtitleHtml("<%=i18nLoginSubTitle%>");
	 
</script>
<%	
	}//end of check for primary OA
}// end if device key is not null
%>
</html>