<%@page errorPage = "OAConfigErrorHandler.jsp"%>
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationFactory"%>
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.SOAPCustomHandler"%>
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationIntf"%>
<%@page import="java.net.InetAddress"%> 
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.OAConstants"%>
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicatorSessionBean"%>
<%@page import="com.hp.mx.utilities.DebugSubsystem"%>
<%@page import="java.net.SocketException"%>		
<%@page import="java.net.UnknownHostException"%>
<%@page import="java.net.MalformedURLException"%>	
<%@page import="java.io.ByteArrayOutputStream"%>
<%@page import="java.io.PrintStream"%>
<%@page import="java.io.IOException"%>
<%@page import="java.net.ConnectException"%>
<%@page import="com.hp.mx.portal.i18n.MonteroResourceManager"%>
<%@page import="com.hp.mx.portal.ui.MxBean"%>

<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean class="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicatorSessionBean" id="OACommunicatorSessionBean" scope="session"/>
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />


<% 
	MxBean.jspInit(request, response);
	rbPortal.init(loginBean, "MxPortal");
	String userName 	= request.getParameter("userName");
 	String pwd			= request.getParameter("password");
	String ipAddress 	= request.getParameter("ipAddress");
	String guid		 	= request.getParameter("guid");
	String deviceKey    = request.getParameter("devId");
	String errorMsg		= "Invalid User Name and/or Password.";
	String causeMsg		= "";
	String actionMsg	= "";
	DebugSubsystem LOGGER = new DebugSubsystem(OAProcessLogin_jsp.class);
	ByteArrayOutputStream  baos = new ByteArrayOutputStream();

	//url to connect to OA
	String url = "https://" + ipAddress + "/hpoa";
try
{

	//login to OA
	OACommunicationIntf soapObj = OACommunicationFactory.getOACommunicator(OAConstants.OA_SOAP_CURRENT_HANDLER);
	String OASessionKey = soapObj.loginOA(url, userName, pwd);
	
	//set all the properties for the soap handler
	
	//url to access OA
	soapObj.setURL(url);	
	
	//session key to OA
	soapObj.setSessionKey(OASessionKey);
	
	//guid of the OA
	soapObj.setGuid(guid);
	
	//set the relative url of the config file which will be used for restoring
	//this is presently not used, since OA does n't support https
	InetAddress localHost = InetAddress.getLocalHost();
	String configRelativeURL = "http://" + localHost.getHostAddress() + ":280" + "/mxportal";
	soapObj.setConfigScriptURLForRestore(configRelativeURL);
	
	//save the soap obj in the session bean so that user need not login for the
	// subsequent request
	if ( OASessionKey != "-1")
	{
		//check if user is administrator
		boolean isOAAdmin = soapObj.isCurrentUserOAAdministrator();
		if(isOAAdmin == false)
		{
			errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.cfgFailed", loginBean.getLocale()) + "<br><br> ";
			causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.user", loginBean.getLocale()) +" \"" + userName + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.cause.noPrivilege", loginBean.getLocale()) + "<br><br>";
			actionMsg= MonteroResourceManager.getInstance().getString("oaconfig.action.ensurePrivilegeMsg1", loginBean.getLocale()) +" \"" + ipAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.ensurePrivilegeMsg2", loginBean.getLocale()) +"<br>";
	%>
		
			<jsp:forward page="OALogin.jsp">
				<jsp:param name="errorMsg" value="<%=errorMsg%>"/>
				<jsp:param name="causeMsg" value="<%=causeMsg%>"/>
				<jsp:param name="actionMsg" value="<%=actionMsg%>"/>
				<jsp:param name="devId" value="<%=deviceKey%>"/>
			</jsp:forward>
	<%
		}
		//end check for Administrator

		OACommunicatorSessionBean.saveOACommunicator(ipAddress, soapObj);
%>
		<jsp:forward page="OAConfiguration.jsp">
			<jsp:param name="ipAddress" value="<%=ipAddress%>"/>
		</jsp:forward>
<%
	}
}
catch(UnknownHostException e) //if unreachable ipaddress is supplied
{
	errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.signIn", loginBean.getLocale()) + "<br><br>";
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.oa", loginBean.getLocale()) + " " + ipAddress + " " + MonteroResourceManager.getInstance().getString("oaconfig.cause.notReachable", loginBean.getLocale()) + "<br><br>";
	actionMsg=MonteroResourceManager.getInstance().getString("oaconfig.action.ensure", loginBean.getLocale()) + " \"" + ipAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.reachable", loginBean.getLocale()) + "<br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessLogin.jsp \n " + errorMsg + baos.toString());
}
catch(ConnectException e) //if unreachable ipaddress is supplied
{
	errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.signIn", loginBean.getLocale()) + "<br><br>";
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.oa", loginBean.getLocale()) + " " + ipAddress + " " + MonteroResourceManager.getInstance().getString("oaconfig.cause.notReachable", loginBean.getLocale()) + "<br><br>";
	actionMsg=MonteroResourceManager.getInstance().getString("oaconfig.action.ensure", loginBean.getLocale()) + " \"" + ipAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.reachable", loginBean.getLocale()) + "<br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessLogin.jsp \n " + errorMsg + baos.toString());
}
catch(SocketException e) //if https is disabled
{
	errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.signIn", loginBean.getLocale()) + "<br><br> ";
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.httpsDisabled", loginBean.getLocale()) + "<br><br> ";
	actionMsg = MonteroResourceManager.getInstance().getString("oaconfig.action.enableHTTPs", loginBean.getLocale()) + "<br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessLogin.jsp \n " + errorMsg + baos.toString());
}
catch(MalformedURLException e) //when /hpoa is invalid
{
	errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.signIn", loginBean.getLocale()) + "<br><br> URL " + url + " " + MonteroResourceManager.getInstance().getString("oaconfig.causeUrlNotAccessible", loginBean.getLocale()) + "<br><br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("URL is not accessible");
	LOGGER.panic("Error in OAProcessLogin.jsp \n " + errorMsg + baos.toString());
}
catch(IOException e) //when invalid user details are supplied
{
	errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.signIn", loginBean.getLocale()) + "<br><br>";
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.invalidUser", loginBean.getLocale()) + "<br><br>";
	actionMsg = MonteroResourceManager.getInstance().getString("oaconfig.action.supplyValidDetails", loginBean.getLocale()) + "<br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessLogin.jsp \n " + errorMsg + baos.toString());
}

%>
	<jsp:forward page="OALogin.jsp">
		<jsp:param name="errorMsg" value="<%=errorMsg%>"/>
		<jsp:param name="causeMsg" value="<%=causeMsg%>"/>
		<jsp:param name="actionMsg" value="<%=actionMsg%>"/>
		<jsp:param name="devId" value="<%=deviceKey%>"/>
	</jsp:forward>