//variables for auto refresh of tool tip
var curGuid = "";
var initialToolTip = "";

//create an array of guids (if it's P-class/C-class server or p-class switch)
function getGlobalGuids()
{
	var count = 0;
	var j=0;

	//reinitialise the array
	guidsList = new Array();
	var classType,subType;

	var inputNodeCollection = window.document.getElementsByTagName("input");
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		classType = inputNodeCollection[i].getAttribute("classtype");
		subType = inputNodeCollection[i].getAttribute("id");
		
		//if it's P-class or a C-class server
		if((classType == "p-Class" ||  classType == "c-Class") && (subType == "serverCheckBox"))
		{
			guidsList[j] = inputNodeCollection[i].getAttribute("guid");
			j++;
		}

		// if it's a p-class switch
		if((classType == "p-Class" ||  classType == "c-Class") && subType == "switchCheckBox")
		{
			guidsList[j] = inputNodeCollection[i].getAttribute("guid");
			j++;
		}
	}	
 }

//create the http request object
function createRequestObject() {
    var ro;
    var browser = navigator.appName;
    if(browser == "Microsoft Internet Explorer"){
        ro = new ActiveXObject("Microsoft.XMLHTTP");
    }else{
        ro = new XMLHttpRequest();
    }
    return ro;
}

//loads more tool tip
function loadDeviceMoreToolTip(e, toolTip, moreToolTip, guid) {
	var guidFound = false;

	//used for refreshing tool tip
	curGuid = guid;
	initialToolTip = toolTip;

	positionTT(e);
	document.onmousemove = positionTT;
	var canvas=document.getElementById("toolText");
	canvas.innerHTML="";
	toolTip = toolTip.split(",");
	
	var tt="";
	for(var k=0;k<toolTip.length;k++) {
		if(toolTip[k].indexOf(":")>0) {
			var toolTipTitle = toolTip[k].split(":");
			tt += "<b>"+toolTipTitle[0]+": </b>";
			for(var i=1;i<toolTipTitle.length;i++) {
			  tt += toolTipTitle[i];
			  if((i+1)<toolTipTitle.length) {
					tt += ":";
			  }
			}
			tt+="<br>";
		} else {
			tt += toolTip[k]+"<br>"
		}
	}

	toolTip=tt;	

	if(moreToolTip != undefined && moreToolTip.length !=0)
	{
			for(k=0;k<toolTipData.length;k++)
			{
				if(toolTipData[k][0] == guid)
				{
					guidFound = true;					
					moreToolTip = toolTipData[k][1];
					break;
				}
			}		
		
		//get from the cached array
		if(isRefreshed == true)
		{
			if(guidFound == false)
			{
				for(k=0;k<copyToolTipData.length;k++)
				{
					if(copyToolTipData[k][0] == guid)
					{
						guidFound = true;
						moreToolTip = copyToolTipData[k][1];
						break;
					}
				}
			}
		}

		//append the extra tool tip
		
		var tt="";
	
		moreToolTip = moreToolTip.split(",");

		for(k=0;k<moreToolTip.length;k++) {
			if(moreToolTip[k].indexOf(":")>0) {
				var toolTipTitle = moreToolTip[k].split(":");
				tt += "<b>"+toolTipTitle[0]+": </b>";
				for(var i=1;i<toolTipTitle.length;i++) {
				  tt += toolTipTitle[i];
				  if((i+1)<toolTipTitle.length) {
					tt += ":";
				  }
				}
				tt+="<br>";
			} else {
				tt += moreToolTip[k]+"<br>"
			}
		}
		toolTip = toolTip + tt;
	}

	canvas.innerHTML=toolTip;

	canvas.style.visibility="visible";

	if(e){
		e.stopPropagation();
	}else {
		event.cancelBubble=true;
	}
}

//create the xml file from the received string
function importXML(xmlData)
{	
	if (document.implementation && document.implementation.createDocument)
	{
	   var objDOMParser = new DOMParser();     
	   xmlDoc = objDOMParser.parseFromString(xmlData,"text/xml");	
	   processXML();
   }
	else if (window.ActiveXObject)
	{
		xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
		xmlDoc.async="false";
		xmlDoc.loadXML(xmlData);
		processXML();		
 	}
	else
	{
		return;
	}		
}

//parse the xml file
function processXML()
{		
	var guid = xmlDoc.getElementsByTagName("Device")[0].attributes.getNamedItem("guid").value;
	var Status = xmlDoc.getElementsByTagName("Status")[0].childNodes[0].nodeValue;
	var DataList;
	
	//don't add if it's already found	
		if(isGuidFound(toolTipData, guid) == true)
			return;	

	if(Status != "Not Available")
	{			
		toolTipData[tindex] = new Array();
		toolTipData[tindex][0] = guid;
		data = "";
		DataList = xmlDoc.getElementsByTagName("Data");

		for(i=0;i<DataList.length;i++)
		{
			var attributes = DataList[i].attributes;
			name = attributes.getNamedItem("name").value;
			value = attributes.getNamedItem("value").value;

			if(data == "")
				data = name + ":" + value;
			else
				data = data + "," + name + ":" + value;			
		}

		toolTipData[tindex][1] = data;
		
		//check if the tool tip layer is displayed presently for this guid. 
		//if so repaint the tool tip area with the received response data
		checkGuidToolTipDisplayed(guid);
		tindex++;
	}
}

//check if guid is found
function isGuidFound(tmpArray, guid)
{	
	if(tmpArray != null)
	{
		for(var j=0;j<tmpArray.length;j++)
		{
			if(tmpArray[j][0] == guid)
				return true;
		}
	}
	return false;
}

//send the ajax calls
function sndReq() 
{	
	for(var i=0;i<guidsList.length;i++){
		current=i;
		if (document.implementation && document.implementation.createDocument)
			arrReq[i].overrideMimeType('text/xml');
		
		arrReq[i].open('get', urls[i], true);
		arrReq[i].send(null);
	}
	loop=setInterval("checkResponse()", 500);
}

//check if response is received
function checkResponse(){
	var doneCount = 0;
	for(var i=0;i<arrReq.length;i++){
		if(arrReq[i].readyState==4){
			var response = arrReq[i].responseText;
			importXML(response);
			doneCount++;
		}
	}
	if(doneCount>=arrReq.length && loop){
		clearInterval(loop);
	}
}

//call for every guid
function loadMoreToolTip()
{	
	getGlobalGuids();
	getRequestObjects();
	sndReq();
}

//checks if received data need to be repainted on the tool tip layer
//(to auto refresh the tool tip)
function checkGuidToolTipDisplayed(respReceivedGuid)
{
	if(respReceivedGuid == curGuid)
		updateMoreToolTipLayer();	
}

//repaints the tooltip layer automatically on receiveing the reponse
function updateMoreToolTipLayer()
{
	var tt="";
	var dynamicToolTip = "";

	//append the initial tool tip
	var staticToolTip = formatToolTipData(initialToolTip);	

	//now, append more tool tip
	var tmpIndex = getArrayIndexForGuid(curGuid)
	
	//tmpIndex will be -1 incase tool tip data is not yet received for the guid
	if(tmpIndex != -1)
	{
		dynamicToolTip = toolTipData[tmpIndex][1];
		dynamicToolTip = formatToolTipData(dynamicToolTip);
		tt = staticToolTip + dynamicToolTip;
		var canvas = document.getElementById("toolText");
		if(canvas)
		{
			if(canvas.style.visibility == "visible")
				canvas.innerHTML=tt;			
		}
	}	
}

//get the index from the tool tip array for the passed guid
function getArrayIndexForGuid(guid)
{
	var k = 0;
	for(k=0;k<toolTipData.length;k++)
	{
		if(toolTipData[k][0] == guid)		
			return k;		
	}

	//-1 when toolTipData array does n't contain the data for the guid
	return -1;
}

//parses the tool tip data and return in the displayable format
function formatToolTipData(tmpData)
{
	var tt = "";
	tData = tmpData.split(",");
	for(var k=0;k<tData.length;k++)
	{
		if(tData[k].indexOf(":")>0) 
		{
			var tDataTitle = tData[k].split(":");
			tt += "<b>"+tDataTitle[0]+" : </b>"+tDataTitle[1]+"<br>"
		} 
		else 
		{
			tt += tData[k]+"<br>"
		}
	}
	return tt;
}
