function MxBrowserIsGecko()
{
    return (navigator.userAgent.toLowerCase().indexOf("gecko") >= 0);
}

function MxBrowserGetBodyWidth(nAdjust_ie, nAdjust_ns)
{
    var o = MxBrowserIsGecko() ? document.getElementById("ID_BODY_PROXY") : document.body;
    if (o == null) o = document.body;

    var v = MxBrowserIsGecko() ? o.offsetWidth + nAdjust_ns : o.offsetWidth + nAdjust_ie;
    return v;
}

function MxBrowserGetBodyHeight(nAdjust_ie, nAdjust_ns)
{
    var o = MxBrowserIsGecko() ? document.getElementById("ID_BODY_PROXY") : document.body;
    if (o == null) o = document.body;

    var v = MxBrowserIsGecko() ? o.offsetHeight + nAdjust_ns : o.offsetHeight + nAdjust_ie;
    return v;
}

/**
* This function is for checking the state of the given iframe in the
* current document.
*
* If it returns null, then the browser is IE AND the iframe is in an error state.
* Otherwise, it returns the lastModified value of the iframe.
*
* (1) get the lastModified time on an iframe
* (2) load a URL (to a non-cached JSP) into the iframe
* (3) let a significant amount of time pass
* (4) check the lastModified time on the iframe. An error has occurred if:
*     (a) null is returned, or
*     (b) the lastModified time has not changed
*/
function MxBrowserGetLastModified(szId)
{
    var oDoc = null;
    try {
        oDoc = document.getElementById(szId).contentWindow.document;
    } catch (e) {
        return null;
    }

    return oDoc.lastModified;
}

/**
 * Safely refreshes the given iframe.
 */
function MxBrowserRefreshFrame(oFrame)
{
    // using simply location.reload() doesn't work in Mozilla

    if (oFrame != null && oFrame.contentWindow != null)
    {
        var szUrl = oFrame.contentWindow.document.location.href;
        if (szUrl.indexOf("#") >= 0)
        {
            szUrl = szUrl.split("#")[0];
            if (MxBrowserIsGecko())
            {
                // at this time, Mozilla requires this first call
                // to strip off the hash, then the next one actually
                // reloads it
                oFrame.contentWindow.document.location.replace(szUrl);
            }
        }

        oFrame.contentWindow.document.location.replace(szUrl);
    }
}

/**
 * Returns the topmost window that we can access without security
 * violations, stopping at the given page (or null to not stop
 * until "top" is reached).
 */
function MxBrowserGetTopmost(szStopAt)
{
    var w = window;
    while (true)
    {
        if (szStopAt != null && w.document.location.href.indexOf(szStopAt) > 0)
           break;

        if (w == w.top)
           break;

        try {
            w.parent.document.lastModified;
        } catch (e) {
           break;
        }

        w = w.parent;
    }

    return w;
}

////////////////////////////////////////////////////////////////////////////
// Style sheet functions

/*
 * Check whether the given CSS is already linked.
 */
function MxBrowserCssCheck(szCss)
{
    var oLinks = document.getElementsByTagName("LINK");
    for (var i = 0; i < oLinks.length; i++)
    {
        var szHref = "";
        if (typeof(oLinks[i].href) != "undefined")
            szHref = oLinks[i].href;

        if (szHref == szCss)
            return true;

        if (szCss.charAt(0) == '/')
        {
            if (szHref.indexOf(szCss) >= 0)
                return true;
        }
        else
        {
            if (szHref.indexOf("/" + szCss) >= 0)
                return true;
        }

    }

    return false;
}

/*
 * Link the given CSS into the current document.
 */
function MxBrowserCssLink(szCss, szMedia)
{
    var oHead = document.getElementsByTagName("HEAD")[0];
    if (oHead == null)
        return;

    var oLink = document.createElement("LINK");
    oLink.rel = "stylesheet";
    oLink.type = "text/css";
    if (szMedia != null)
        oLink.media = szMedia;

    oLink.href = szCss;
    oHead.appendChild(oLink);
}

/*
 * If the given CSS hasn't been linked into the current document,
 * then link it in.
 */
function MxBrowserCssAdd(szCss, szMedia)
{
    if (!MxBrowserCssCheck(szCss))
    {
        MxBrowserCssLink(szCss, szMedia);
    }
}

/**
 * Return the value of the requested cookie (properly unESCaped), or null.
 */
function MxBrowserGetCookie(szName)
{
    var aCookie = document.cookie.split("; ");
    for (var i = 0; i < aCookie.length; i++)
    {
        var aCrumb = aCookie[i].split("=");
        if (aCrumb[0] == szName)
            return unescape(aCrumb[1]);
    }

    return null;
}

/**
 * Sets the given cookie with the given value (properly ESCaped).
 * If the value is null, the cookie is removed.
 */
function MxBrowserSetCookie(szName, szValue, bTemp)
{
    document.cookie = szName + "=nothing; expires=Fri, 31 Dec 1999 23:59:59 GMT;";

    if (szValue != null)
    {
        if (bTemp)
            document.cookie = szName + "=" + escape(szValue);
        else
            document.cookie = szName + "=" + escape(szValue) + "; expires=Thu, 31 Dec 2099 23:59:59 GMT;";
    }
}
