#!/bin/sh

# ==============================================================
# sol.sh
# Creates Solaris boot environment for JumpStart installs
#
# Usage:
#   dist=(provided in job)
#   nfsmedia=(provided in job)
#   sysidcfg=(provided in job)
#   jumpstart=(provided in job)
#   sol.sh
# ==============================================================

function ErrorHandle
{
   rc=$1
   case $rc in
     255 )
      errorlevel=3
      msg="$0: dist= value is missing";;
     254 )
      errorlevel=3
      msg="$0: unattendfile= value is missing";;
     253 )
      errorlevel=3
      msg="$0: could not mount the hard drive or did not find the RDP boot image";;
     252 )
      errorlevel=3
      msg="$0: could not copy boot or kickstart files";;
     251 )
      errorlevel=3
      msg="$0: $initdir boot files do not exist";;
     250 )
      errorlevel=3
      msg="$0: grub.conf file was not generated";;
     249 )
      errorlevel=3
      msg="$0: ipaddress= value is missing";;
     0 )
      errorlevel=1
      msg="$0 completed successfully";;
     * )
      errorlevel=3
      msg="$0: Unknown error";;
   esac
   # Call Altiris console logging
   /opt/altiris/deployment/adlagent/bin/logevent -c:$rc -l:$errorlevel -ss:"$msg"
   # Exit script 
   exit
}

dsdir=/mnt/ds/lib
hddir=/mnt/hd
initdir=$dsdir/osdist/$dist

if [ "$dist" = "" ]; then
  ErrorHandle 255
fi

# Get HD Device
# this will follow the partition setup from rdeploy previous task
# check for rdp flag file to verify is the RDP image
mkdir -p $hddir
names=(`grep "1$" /proc/partitions | awk '{ print $4 }'`)
hdmounted=false
for dev in ${names[@]}; do
   mount -t ext2 /dev/$dev $hddir
   if [ $? -eq 0 ] && [ -e $hddir/rdpimage ]; then
     hdmounted=true
     # Grab primary controller device name for kickstart token replace
     if [ `echo $dev | grep cciss` ]; then
        let strlen=${#dev}-2
     else # not cciss
        let strlen=${#dev}-1
     fi
     shortdevice=${dev:0:$strlen}
     break
   else
     umount $hddir >>/dev/null
   fi
done
if ! $hdmounted; then 
   ErrorHandle 253
fi

# Copy Solaris boot files
if [ -e $initdir/multiboot ] && [ -e $initdir/x86.miniroot ]; then
   cp $initdir/multiboot $hddir/init
   rccp1=$?
   cp $initdir/x86.miniroot $hddir/init
   rccp2=$?
   if [ $rccp1 -ne 0 ] || [ $rccp2 -ne 0 ]; then
      ErrorHandle 252
   fi
else
   ErrorHandle 251
fi

# create grub.conf
echo "default=0" > $hddir/grub/grub.conf
echo "timeout=5" >> $hddir/grub/grub.conf
echo "title RDP Solaris Loader" >> $hddir/grub/grub.conf
echo "root (hd0,0)" >> $hddir/grub/grub.conf

echo "kernel /init/multiboot kernel/unix - install -B install_media=$nfsmedia,install_config=$jumpstart,sysid_config=${sysidcfg}${otheroptions}" >> $hddir/grub/grub.conf
echo "module /init/x86.miniroot" >> $hddir/grub/grub.conf
if [ ! -e $hddir/grub/grub.conf ]; then
   ErrorHandle 250
fi
umount $hddir >>/dev/null

# Exit successfully
ErrorHandle 0
