/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.utilities;

import com.hp.mx.database.DatabaseManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class ResourceDump {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceDump(String dir, String lang) {
        Connection myConnection = null;
        Statement p = null;
        ResultSet rSet = null;
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("ResourceDump");
            String theResClass = "";
            String propsfilename = "";
            p = myConnection.createStatement();
            rSet = p.executeQuery("select DISTINCT(resourceClassName) from stringResource");
            boolean haveone = false;
            while (rSet != null && rSet.next()) {
                theResClass = rSet.getString(1).trim();
                if (theResClass.equalsIgnoreCase("appmenu") || theResClass.equalsIgnoreCase("mib")) continue;
                propsfilename = dir + File.separator + theResClass + "_" + lang + ".properties";
                System.out.println("              Creating file from database: " + propsfilename);
                FileOutputStream out = new FileOutputStream(propsfilename);
                this.dumpResourceToFile(theResClass, lang, out);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception occurred while trying to access the database..Bummer!");
            System.out.println(ex);
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                }
                if (p != null) {
                    p.close();
                }
                if (myConnection != null) {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpResourceToFile(String resourceclass, String lang, OutputStream out) {
        Properties props = new Properties();
        Connection myConnection = null;
        Statement p = null;
        ResultSet rSet = null;
        String propertyname = "";
        String propertyvalue = "";
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("ResourceDump");
            if (resourceclass != null) {
                resourceclass = resourceclass.trim();
                boolean specialcase = false;
                if (resourceclass.equalsIgnoreCase("AllAlertTypes")) {
                    resourceclass = "AlertType";
                    specialcase = true;
                }
                if (resourceclass.equalsIgnoreCase("AllDeviceUrl")) {
                    resourceclass = "DeviceUrl";
                    specialcase = true;
                }
                StringBuffer theSqlQuery = new StringBuffer();
                theSqlQuery.append("select RTRIM(resourceClassName), RTRIM(subclass), RTRIM(resourcename), RTRIM(language), RTRIM(largeValue) ");
                theSqlQuery.append(" from stringResource,stringtablelarge   where stringResource.id = stringtablelarge.id ");
                theSqlQuery.append(" and resourceClassName = '");
                theSqlQuery.append(resourceclass);
                theSqlQuery.append("'");
                theSqlQuery.append(" and language='" + lang + "'");
                if (!specialcase && resourceclass.equalsIgnoreCase("AlertType")) {
                    theSqlQuery.append(" and resourcename in (select typeIdStr from noticeType where typeIdStr not like 'trap.%' )");
                    System.out.println("                Filtered out mib data.");
                }
                if (!specialcase && resourceclass.equalsIgnoreCase("DeviceUrl")) {
                    theSqlQuery.append(" and LOWER(subclass)  not like 'compaq.webserver.%' ");
                    System.out.println("                Filtered out discovered webservers.");
                }
                p = myConnection.createStatement();
                rSet = p.executeQuery(theSqlQuery.toString());
                while (rSet.next()) {
                    propertyname = "stringtable." + rSet.getString(1).replaceAll("[.]", "..").replaceAll(" ", "_") + "." + rSet.getString(2).replaceAll("[.]", "..").replaceAll(" ", "_") + "." + rSet.getString(3).replaceAll("[.]", "..").replaceAll(" ", "_");
                    propertyvalue = rSet.getString(5);
                    props.put(propertyname, propertyvalue);
                }
                String comment = resourceclass;
                props.save(out, comment);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception occurred while trying to access the database..Bummer!");
            System.out.println(ex);
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                }
                if (p != null) {
                    p.close();
                }
                if (myConnection != null) {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
            }
            catch (Exception ex) {}
        }
    }

    public static void main(String[] args) {
        String dirname = "";
        String lang = "en";
        int exitCode = 0;
        try {
            if (args.length != 1 && args.length != 2) {
                System.out.println("\nUsage:  ResourceDump  targetdir [lang]\n");
                System.out.println("              Dump database resources as property files into targetdir.\n\n");
                exitCode = 2;
            } else {
                dirname = args[0];
                File f = new File(dirname);
                if (!f.exists()) {
                    System.out.println("\nDirectory does not exist: " + f.getName());
                    exitCode = 1;
                }
                if (args.length == 2) {
                    lang = args[1];
                }
            }
        }
        catch (Exception e) {
            System.out.println("\nError: " + e + "\n");
            exitCode = 3;
        }
        if (exitCode == 0) {
            new ResourceDump(dirname, lang);
        }
        System.exit(exitCode);
    }
}

