
PRODNAME="HP BladeSystem Integrated Manager 2.3"
HPSIMNAME="HP Systems Insight Manager 5.1"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool -l f -t BogusToolName"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_52="5105010000"


#############################################################
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? = 200 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo ====================================================
echo HP BladeSystem Integrated Manager 2.3 Installer
echo 
echo Enter "'y'" to continue this installation.
echo ====================================================

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Installation was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

echo $cmsOS

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made."
    exit 300
fi

# extract the version string from the "mxversion" output
#cmsOS=$(uname -s)
verString="$( echo $simVersion| tr -d '.[:alpha:][:blank:][:punct:]'| cut -c1-10 )"

#verString="$(echo $simVersion | sed 's/^.*- Linux \([^ ]*\).*$/\1/')"
#verString="$(echo $verString | sed 's/^.*- HP-UX \([^ ]*\).*$/\1/')"
#verString="$(echo $verString | sed 's/^Systems Insight Manager \([^ ]*\).*$/\1/')"
#if [ $cmsOS = "HP-UX" ]
#then
#    verString="$(echo $verString | sed 's/.[^.]*$//')"
#fi
echo $verString
# Check to see if we can recognize the version of SIM
if [ "$verString" != "$VERSION_52" ]
then 
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
else
    echo
    echo "${HPSIMNAME} found.${PRODNAME} is included as part ${HPSIMNAME}.No Update Requried"
    exit 600	
fi



