/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.JAXBCustomValidationEventHandler;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class DataManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DataManager.class);

    protected RIMPType processXMLData(MxNode deviceMxNode) throws DCException {
        LOGGER.enter("DataManager.processXMLData(" + deviceMxNode + ")");
        String isHttpEnabledOnGlobalScale = GlobalSettings.getProperty((String)"http_check_state", (String)"checked");
        if (!isHttpEnabledOnGlobalScale.equals("checked")) {
            throw new DCException("Http/Https protocols are disabled on global scale, Go to Options->Configure Global Protocol settings from the SIM Menu and enable the check.");
        }
        JAXBContext jaxbContext = null;
        Unmarshaller unmarshaller = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB");
            LOGGER.fine("DataManager.processXMLData.jaxbContext " + jaxbContext);
            unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            LOGGER.fine("DataManager.processXMLData.unmarshaller " + unmarshaller);
        }
        catch (JAXBException je) {
            LOGGER.error("DataManager.processXMLData.JAXBException Unable to get jaxbContext/unmarshaller" + (Object)((Object)je));
            LOGGER.exception((Throwable)je);
            LOGGER.exit("DataManager.processXMLData(" + deviceMxNode + ")");
            throw new DCException(je);
        }
        String WORKING_ADDRESS = deviceMxNode.getWorkingAddress();
        LOGGER.fine("DataManager.processXMLData.WORKING_ADDRESS " + WORKING_ADDRESS);
        RIMPType rimpType = null;
        try {
            rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, "https://"));
            LOGGER.fine("DataManager.processXMLData.rimpType from https:// is success " + rimpType);
        }
        catch (DCException oe) {
            LOGGER.fine("DataManager.processXMLData.rimpType from https:// is failed " + oe);
            try {
                rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, "http://"));
                LOGGER.fine("DataManager.processXMLData.rimpType from http:// is success " + rimpType);
            }
            catch (DCException oe1) {
                LOGGER.error("DataManager.processXMLData.rimpType from http:// is failed " + oe1);
                LOGGER.exception((Throwable)oe1);
                LOGGER.exit("DataManager.processXMLData(" + deviceMxNode + ")");
                throw new DCException(oe1);
            }
        }
        LOGGER.exit("DataManager.processXMLData(" + deviceMxNode + ")");
        return rimpType;
    }

    private String getURL(String WORKING_ADDRESS, String PROTOCOL) {
        LOGGER.enter("DataManager.getURL(" + WORKING_ADDRESS + "," + PROTOCOL + ")");
        StringBuffer url = new StringBuffer(PROTOCOL);
        url.append(WORKING_ADDRESS);
        url.append("/xmldata?item=All");
        LOGGER.exit("DataManager.getURL(" + WORKING_ADDRESS + "," + PROTOCOL + ")");
        return url.toString();
    }

    private RIMPType getRIMPType(Unmarshaller unmarshaller, String url) throws DCException {
        LOGGER.enter("DataManager.getRIMPType(" + unmarshaller + "," + url + ")");
        RIMPType rimpType = null;
        MgmtProcessorParser mpp = new MgmtProcessorParser();
        try {
            String xmlResponse = mpp.sendTheRequest(url);
            LOGGER.fine("DataManager.getRIMPType xmlResponse " + xmlResponse);
            if (xmlResponse == null) {
                throw new DCException("XML response is null for url " + url);
            }
            xmlResponse = xmlResponse.trim();
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlResponse)));
            LOGGER.fine("DataManager.getRIMPType success " + url);
        }
        catch (JAXBException je) {
            LOGGER.fine("DataManager.getRIMPType failed " + url);
            LOGGER.fine("DataManager.getRIMPType JAXBException " + (Object)((Object)je));
            LOGGER.exit("DataManager.getRIMPType(" + unmarshaller + "," + url + ")");
            throw new DCException(je);
        }
        LOGGER.exit("DataManager.getRIMPType(" + unmarshaller + "," + url + ")");
        return rimpType;
    }

    protected RIMPType processXMLData(String xmlString) throws DCException {
        LOGGER.enter("DataManager.processXMLData(" + xmlString + ")");
        RIMPType rimpType = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlString)));
            LOGGER.fine("DataManager.processXMLData.rimpType " + rimpType);
        }
        catch (JAXBException je) {
            LOGGER.error("DataManager.processXMLData.JAXBException " + (Object)((Object)je));
            LOGGER.exception((Throwable)je);
            LOGGER.exit("DataManager.processXMLData(" + xmlString + ")");
            throw new DCException(je);
        }
        LOGGER.exit("DataManager.processXMLData(" + xmlString + ")");
        return rimpType;
    }
}

