/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.RackTopology;
import com.hp.mx.core.tools.datacollection.http.iLO.Blade;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB.PClassEnclosureType;
import com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB.RIMPType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BLADETypePClass;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.PCLASSINFRAType;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;

public class BladeEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(BladeEnclosure.class);
    private Blade blade;
    private RackTopology rackTopology;
    private String rackName = "";
    private String name = "";
    private String icmbAddress = "";
    private String serialNumber = "";
    private String uuid = "";
    private int maxSlotInXDirection = -1;
    private int maxSlotInYDirection = -1;
    private int maxSlots = -1;
    private String fwri = "";
    private int powerZone = -1;
    private String uuidStatus = "";
    private int temperature = -1;

    public BladeEnclosure(com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType rimpType) {
        LOGGER.enter("BladeEnclosure(" + rimpType + ")");
        this.rackTopology = new RackTopology(rimpType);
        this.blade = new Blade(rimpType);
        ArrayList lstContents = rimpType != null && rimpType.getINFRA() != null ? rimpType.getINFRA().getContent() : new ArrayList();
        Invoker.init("initializeINFRA", lstContents, BladeEnclosure.class, this);
        this.print("BladeEnclosure JAXB");
        this.blade.print("Blade JAXB");
        LOGGER.exit("BladeEnclosure(" + rimpType + ")");
    }

    public BladeEnclosure() {
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_RACKImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_RACKImpl(" + element + ")");
        this.rackName = DCUtil.trimAttribute(((PCLASSINFRAType.RACK)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_RACKImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_ENCLImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ENCLImpl(" + element + ")");
        this.name = DCUtil.trimAttribute(((PCLASSINFRAType.ENCL)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ENCLImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_ICMBADDRImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ICMBADDRImpl(" + element + ")");
        this.icmbAddress = DCUtil.trimAttribute(DCUtil.getHexString(((PCLASSINFRAType.ICMBADDR)element).getValue()));
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ICMBADDRImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_ENCLSNImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ENCLSNImpl(" + element + ")");
        this.serialNumber = DCUtil.trimAttribute(((PCLASSINFRAType.ENCLSN)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_ENCLSNImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_UUIDImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_UUIDImpl(" + element + ")");
        this.uuid = DCUtil.trimAttribute(((PCLASSINFRAType.UUID)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSXImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSXImpl(" + element + ")");
        this.maxSlotInXDirection = ((PCLASSINFRAType.MAXNUMBERSLOTSX)element).getValue().intValue();
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSXImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSYImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSYImpl(" + element + ")");
        this.maxSlotInYDirection = ((PCLASSINFRAType.MAXNUMBERSLOTSY)element).getValue().intValue();
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSYImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSImpl(" + element + ")");
        this.maxSlots = ((PCLASSINFRAType.MAXNUMBERSLOTS)element).getValue().intValue();
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_MAXNUMBERSLOTSImpl(" + element + ")");
    }

    public void initializeINFRA_PCLASSINFRATypeImpl_BLADEImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_BLADEImpl(" + element + ")");
        Invoker.init("initializeINFRA", ((BLADETypePClass)element).getContent(), Blade.class, this.blade);
        LOGGER.exit("BladeEnclosure.initializeINFRA_PCLASSINFRATypeImpl_BLADEImpl(" + element + ")");
    }

    void init(RIMPType rimpType) {
        LOGGER.enter("BladeEnclosure.init(" + rimpType + ")");
        Invoker.init("initializeEnclosure", rimpType.getEnclosure().getContent(), BladeEnclosure.class, this);
        this.print("BladeEnclosure ICMB JAXB");
        LOGGER.exit("BladeEnclosure.init(" + rimpType + ")");
    }

    public void initializeEnclosure_PClassEnclosureTypeImpl_FWRIImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_FWRIImpl(" + element + ")");
        this.fwri = DCUtil.trimAttribute(((PClassEnclosureType.FWRI)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_FWRIImpl(" + element + ")");
    }

    public void initializeEnclosure_PClassEnclosureTypeImpl_PwrZoneImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_PwrZoneImpl(" + element + ")");
        this.powerZone = ((PClassEnclosureType.PwrZone)element).getValue();
        LOGGER.exit("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_PwrZoneImpl(" + element + ")");
    }

    public void initializeEnclosure_PClassEnclosureTypeImpl_UidStatusImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_UidStatusImpl(" + element + ")");
        this.uuidStatus = DCUtil.trimAttribute(((PClassEnclosureType.UidStatus)element).getValue());
        LOGGER.exit("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_UidStatusImpl(" + element + ")");
    }

    public void initializeEnclosure_PClassEnclosureTypeImpl_TemperatureImpl(Object element) {
        LOGGER.enter("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_TemperatureImpl(" + element + ")");
        this.temperature = ((PClassEnclosureType.Temperature)element).getValue();
        LOGGER.exit("BladeEnclosure.initializeEnclosure_PClassEnclosureTypeImpl_TemperatureImpl(" + element + ")");
    }

    public Blade getBlade() {
        return this.blade;
    }

    public RackTopology getRackTopology() {
        return this.rackTopology;
    }

    public String getRackName() {
        return this.rackName;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getICMBAddress() {
        return this.icmbAddress;
    }

    public int getMaxSlotInXDirection() {
        return this.maxSlotInXDirection;
    }

    public int getMaxSlotInYDirection() {
        return this.maxSlotInYDirection;
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public String getFWRI() {
        return this.fwri;
    }

    public int getPowerZone() {
        return this.powerZone;
    }

    public String getUUIDStatus() {
        return this.uuidStatus;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public MxNode getDeviceMxNode() throws ILOException {
        LOGGER.enter("BladeEnclosure.getDeviceMxNode()");
        MxNode enclosureMxNode = null;
        if (this.uuid != null && this.uuid.trim().length() > 0) {
            try {
                enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
            }
            catch (MxException e) {
                LOGGER.fine("BladeEnclosure.getDeviceMxNode.MxException Unable to find Enclosure MxNode by enclosureUUID " + (Object)((Object)e));
            }
        }
        if (enclosureMxNode == null) {
            try {
                enclosureMxNode = DCUtil.getNodeBySerialNumber(this.serialNumber);
            }
            catch (DCException de) {
                LOGGER.fine("OLEnclosure.getDeviceMxNode.DCException Unable to find Enclosure MxNode : " + de);
                LOGGER.exception((Throwable)de);
            }
        }
        if (enclosureMxNode == null) {
            LOGGER.exit("BladeEnclosure.getDeviceMxNode()");
            throw new ILOException("BladeEnclosure.getDeviceMxNode unable to find enclosure node by uuid/serial number");
        }
        LOGGER.exit("BladeEnclosure.getDeviceMxNode()");
        return enclosureMxNode;
    }

    protected void print(String SOURCE) {
        LOGGER.enter("*********BladeEnclosure.print(" + SOURCE + ")**************");
        LOGGER.fine("BladeEnclosure.rackName " + this.rackName);
        LOGGER.fine("BladeEnclosure.name " + this.name);
        LOGGER.fine("BladeEnclosure.icmbAddress " + this.icmbAddress);
        LOGGER.fine("BladeEnclosure.serialNumber " + this.serialNumber);
        LOGGER.fine("BladeEnclosure.uuid " + this.uuid);
        LOGGER.fine("BladeEnclosure.maxSlotInXDirection " + this.maxSlotInXDirection);
        LOGGER.fine("BladeEnclosure.maxSlotInYDirection " + this.maxSlotInYDirection);
        LOGGER.fine("BladeEnclosure.maxSlots " + this.maxSlots);
        LOGGER.fine("BladeEnclosure.fwri " + this.fwri);
        LOGGER.fine("BladeEnclosure.powerZone " + this.powerZone);
        LOGGER.fine("BladeEnclosure.uuidStatus " + this.uuidStatus);
        LOGGER.fine("BladeEnclosure.temperature " + this.temperature);
        LOGGER.exit("*********BladeEnclosure.print(" + SOURCE + ")**************");
    }
}

