/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.MGMTPROCType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;

public class ILO {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILO.class);
    private String pn = "";
    private String sn = "";
    private float fwri = -1.0f;
    private final String[] CLIENTATTRIBUTES = new String[]{"FWRI"};

    public ILO(RIMPType rimpType) {
        LOGGER.enter("ILO(" + rimpType + ")");
        ArrayList listContents = rimpType != null && rimpType.getMP() != null ? rimpType.getMP().getContent() : new ArrayList();
        Invoker.init("initializeMP", listContents, ILO.class, this);
        this.print("ILO JAXB");
        LOGGER.exit("ILO(" + rimpType + ")");
    }

    public ILO(MxNode iLOMxNode) {
        LOGGER.enter("ILO(" + iLOMxNode + ")");
        this.fwri = Float.parseFloat(iLOMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0]));
        this.print("ILO DB");
        LOGGER.exit("ILO(" + iLOMxNode + ")");
    }

    public void initializeMP_MGMTPROCTypeImpl_PNImpl(Object element) {
        LOGGER.enter("ILO.initializeMP_MGMTPROCTypeImpl_PNImpl(" + element + ")");
        this.pn = DCUtil.trimAttribute(((MGMTPROCType.PN)element).getValue());
        LOGGER.exit("ILO.initializeMP_MGMTPROCTypeImpl_PNImpl(" + element + ")");
    }

    public void initializeMP_MGMTPROCTypeImpl_SNImpl(Object element) {
        LOGGER.enter("ILO.initializeMP_MGMTPROCTypeImpl_SNImpl(" + element + ")");
        this.sn = DCUtil.trimAttribute(((MGMTPROCType.SN)element).getValue());
        LOGGER.exit("ILO.initializeMP_MGMTPROCTypeImpl_SNImpl(" + element + ")");
    }

    public void initializeMP_MGMTPROCTypeImpl_FWRIImpl(Object element) {
        LOGGER.enter("ILO.initializeMP_MGMTPROCTypeImpl_FWRIImpl(" + element + ")");
        this.fwri = DCUtil.getFloatValue(((MGMTPROCType.FWRI)element).getValue());
        LOGGER.exit("ILO.initializeMP_MGMTPROCTypeImpl_FWRIImpl(" + element + ")");
    }

    public String getPN() {
        return this.pn;
    }

    public String getSN() {
        return this.sn;
    }

    public float getFWRI() {
        return this.fwri;
    }

    public void updateAllQueryData(MxNode iLOMxNode) {
        LOGGER.enter("ILO.updateAllQueryData(" + iLOMxNode + ")");
        iLOMxNode.setClientAttribute(this.CLIENTATTRIBUTES[0], String.valueOf(this.fwri));
        DCUtil.commit(iLOMxNode);
        LOGGER.exit("ILO.updateAllQueryData(" + iLOMxNode + ")");
    }

    private void print(String SOURCE) {
        LOGGER.enter("*********ILO.print(" + SOURCE + ")***********");
        LOGGER.fine("ILO.pn " + this.pn);
        LOGGER.fine("ILO.sn " + this.sn);
        LOGGER.fine("ILO.fwri " + this.fwri);
        LOGGER.exit("*********ILO.print(" + SOURCE + ")***********");
    }
}

