/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.iLO.EmptyContainerException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

final class ILOUtil {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILOUtil.class);

    ILOUtil() {
    }

    static MxNode getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(MxNode bladeEnclosureMxNode) throws ILOException {
        LOGGER.enter("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(" + bladeEnclosureMxNode + ")");
        NodeAssociationsManager myNodeRelationshipManager = ILOUtil.getNodeAssociationManager();
        Vector bladeDeviceKeyList = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(bladeEnclosureMxNode.getDeviceKey(), "ServerToEnclosure");
        if (bladeDeviceKeyList.size() == 0) {
            LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(" + bladeEnclosureMxNode + ")");
            throw new EmptyContainerException("This blade enclosure is Empty " + bladeEnclosureMxNode.getDeviceKey());
        }
        int bladeDeviceKey = -1;
        Vector iLODeviceKeyList = null;
        MxNode iLOMxNode = null;
        ILO iLO = null;
        MxNode iLOMxNodeHavingMaxFirmwareInEnclosure = null;
        float maxFirmwareRevisionInEnclosure = -1.0f;
        MxNode iLO2MxNode = null;
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure bladeDeviceKeyList.size() " + bladeDeviceKeyList.size());
        for (int i = 0; i < bladeDeviceKeyList.size(); ++i) {
            bladeDeviceKey = (Integer)bladeDeviceKeyList.get(i);
            iLODeviceKeyList = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(bladeDeviceKey, "MgmtProcToServer_Ilo");
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure bladeDeviceKey " + bladeDeviceKey);
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure iLODeviceKeyList.size() " + iLODeviceKeyList.size());
            for (int j = 0; j < iLODeviceKeyList.size(); ++j) {
                try {
                    iLOMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)iLODeviceKeyList.get(j));
                    iLO = ILOHelper.getILOHelper().getILO(iLOMxNode);
                    LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure iLO.getFWRI() " + iLO.getFWRI());
                    LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure maxFirmwareRevisionInEnclosure " + maxFirmwareRevisionInEnclosure);
                    if (ILOUtil.doesMPSupportICMBQuery(iLOMxNode)) {
                        iLO2MxNode = iLOMxNode;
                    }
                    if (!(iLO.getFWRI() > maxFirmwareRevisionInEnclosure)) continue;
                    maxFirmwareRevisionInEnclosure = iLO.getFWRI();
                    iLOMxNodeHavingMaxFirmwareInEnclosure = iLOMxNode;
                    continue;
                }
                catch (ILOException ie) {
                    LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevision ILOException Unable to compare firmware revision " + ie.getMessage());
                    LOGGER.exception((Throwable)ie);
                }
            }
        }
        if (iLOMxNodeHavingMaxFirmwareInEnclosure == null) {
            LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(" + bladeEnclosureMxNode + ")");
            throw new ILOException("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure Unable to find iLO with Max Firmware");
        }
        if (maxFirmwareRevisionInEnclosure < 1.8f && iLO2MxNode != null) {
            iLOMxNodeHavingMaxFirmwareInEnclosure = iLO2MxNode;
        }
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure Final maxFirmwareRevisionInEnclosure " + maxFirmwareRevisionInEnclosure);
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure Final maxFirmwareRevisionInEnclosure from ILO wrapper object " + ILOHelper.getILOHelper().getILO(iLOMxNodeHavingMaxFirmwareInEnclosure).getFWRI());
        LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(" + bladeEnclosureMxNode + ")");
        return iLOMxNodeHavingMaxFirmwareInEnclosure;
    }

    static MxNode getILOMxNodeHavingMaxFirmwareRevisionInRack(MxNode rackMxNode) throws ILOException {
        LOGGER.enter("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInRack(" + rackMxNode + ")");
        MxNode iLOMxNodeHavingMaxFirmwareInRack = null;
        NodeAssociationsManager myNodeRelationshipManager = ILOUtil.getNodeAssociationManager();
        Vector enclosureDeviceKeyList = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(rackMxNode.getDeviceKey(), "EnclosureToRack");
        iLOMxNodeHavingMaxFirmwareInRack = ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList(enclosureDeviceKeyList);
        LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInRack(" + rackMxNode + ")");
        return iLOMxNodeHavingMaxFirmwareInRack;
    }

    static MxNode getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList(Vector enclosureDeviceKeyList) throws ILOException {
        LOGGER.enter("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList(" + enclosureDeviceKeyList + ")");
        int enclosureDeviceKey = -1;
        ILO iLO = null;
        MxNode iLOMxNodeHavingMaxFirmwareInRack = null;
        MxNode iLOMxNodeHavingMaxFirmwareInEnclosure = null;
        MxNode iLO2MxNode = null;
        float maxFirmwareRevisionInRack = -1.0f;
        MxNode enclosureMxNode = null;
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList enclosureDeviceKeyList.size() " + enclosureDeviceKeyList.size());
        int bladeEnclosureCount = 0;
        int emptyBladeEnclosureCount = 0;
        for (int i = 0; i < enclosureDeviceKeyList.size(); ++i) {
            enclosureDeviceKey = (Integer)enclosureDeviceKeyList.get(i);
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList enclosureDeviceKey " + enclosureDeviceKey);
            try {
                enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(enclosureDeviceKey);
            }
            catch (MxException me) {
                LOGGER.error("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList unable to find enclosureMxNode for devicekey " + enclosureDeviceKey);
                LOGGER.exception((Throwable)me);
                continue;
            }
            if (!enclosureMxNode.getDeviceSubTypes().contains("ServerEnc")) {
                LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList it's a power enclosure " + enclosureDeviceKey);
                continue;
            }
            ++bladeEnclosureCount;
            try {
                iLOMxNodeHavingMaxFirmwareInEnclosure = ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosure(enclosureMxNode);
                iLO = ILOHelper.getILOHelper().getILO(iLOMxNodeHavingMaxFirmwareInEnclosure);
                if (ILOUtil.doesMPSupportICMBQuery(iLOMxNodeHavingMaxFirmwareInEnclosure)) {
                    iLO2MxNode = iLOMxNodeHavingMaxFirmwareInEnclosure;
                }
                if (iLO.getFWRI() > maxFirmwareRevisionInRack) {
                    maxFirmwareRevisionInRack = iLO.getFWRI();
                    iLOMxNodeHavingMaxFirmwareInRack = iLOMxNodeHavingMaxFirmwareInEnclosure;
                }
            }
            catch (EmptyContainerException ece) {
                LOGGER.fine(ece.getMessage());
                ++emptyBladeEnclosureCount;
            }
            catch (ILOException ie) {
                LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList ILOException after executing getILOMxNodeHavingMaxFirmwareRevisionInEnclosure");
                LOGGER.exception((Throwable)ie);
            }
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList maxFirmwareRevisionInRack " + maxFirmwareRevisionInRack);
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList iLOMxNodeHavingMaxFirmwareInRack " + iLOMxNodeHavingMaxFirmwareInRack);
        }
        if (bladeEnclosureCount == emptyBladeEnclosureCount) {
            LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList. This daisy chained Rack doesn't have any blades ");
            LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList");
            throw new EmptyContainerException("This dasiy chained Rack doesn't have any blades");
        }
        if (iLOMxNodeHavingMaxFirmwareInRack == null) {
            LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList");
            throw new ILOException("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList Unable to find iLO with Max Firmware in Rack");
        }
        if (maxFirmwareRevisionInRack < 1.8f && iLO2MxNode != null) {
            iLOMxNodeHavingMaxFirmwareInRack = iLO2MxNode;
        }
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList Final maxFirmwareRevisionInRack " + maxFirmwareRevisionInRack);
        LOGGER.fine("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList Final maxFirmwareRevisionInRack from ILO wrapper object " + ILOHelper.getILOHelper().getILO(iLOMxNodeHavingMaxFirmwareInRack).getFWRI());
        LOGGER.exit("ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInEnclosureList");
        return iLOMxNodeHavingMaxFirmwareInRack;
    }

    static NodeAssociationsManager getNodeAssociationManager() throws ILOException {
        NodeAssociationsManager myNodeRelationshipManager = null;
        try {
            myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException npe) {
            LOGGER.error("ILOUtil.getNodeAssociationManager Unable to get reference to NodeAssociationsManager");
            LOGGER.exception((Throwable)npe);
            throw new ILOException(npe, "ILOUtil.getNodeAssociationManager Unable to get reference to NodeAssociationsManager " + (Object)((Object)npe));
        }
        return myNodeRelationshipManager;
    }

    static boolean doesMPSupportICMBQuery(MxNode iLOMxNode) {
        boolean doesILOSupportICMBQuery = false;
        if (iLOMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ILO2_SUBTYPE.toString())) {
            doesILOSupportICMBQuery = true;
        }
        return doesILOSupportICMBQuery;
    }
}

