/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB.PowerUnitType;
import com.hp.mx.utilities.DebugSubsystem;

public class PowerUnit {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PowerUnit.class);
    private String location = "";
    private String fwri = "";
    private String acInput = "";
    private int inputTemp = -1;
    private int inputTempTrip = -1;
    private int inputTempFail = -1;
    private int outputTemp = -1;
    private int outputTempTrip = -1;
    private int outTempFail = -1;

    PowerUnit(PowerUnitType powerUnitType) {
        LOGGER.enter("PowerUnit(" + powerUnitType + ")");
        this.location = DCUtil.trimAttribute(powerUnitType.getLocation());
        this.fwri = DCUtil.trimAttribute(powerUnitType.getFWRI());
        this.acInput = DCUtil.trimAttribute(powerUnitType.getAcInput());
        this.inputTemp = powerUnitType.getInputTemp();
        this.inputTempTrip = powerUnitType.getInputTempTrip();
        this.inputTempFail = powerUnitType.getInputTempFail();
        this.outputTemp = powerUnitType.getOutputTemp();
        this.outputTempTrip = powerUnitType.getOutputTempTrip();
        this.outTempFail = powerUnitType.getOutputTempFail();
        this.print("PowerUnit JAXB");
        LOGGER.exit("PowerUnit(" + powerUnitType + ")");
    }

    public String getLocation() {
        return this.location;
    }

    public String getFWRI() {
        return this.fwri;
    }

    public String getAcInput() {
        return this.acInput;
    }

    public int getInputTemp() {
        return this.inputTemp;
    }

    public int getInputTempTrip() {
        return this.inputTempTrip;
    }

    public int getInputTempFail() {
        return this.inputTempFail;
    }

    public int getOutputTemp() {
        return this.outputTemp;
    }

    public int getOutputTempTrip() {
        return this.outputTempTrip;
    }

    public int getOutTempFail() {
        return this.outTempFail;
    }

    private void print(String SOURCE) {
        LOGGER.enter("*********PowerUnit.print(" + SOURCE + ")*************");
        LOGGER.fine("PowerUnit.location " + this.location);
        LOGGER.fine("PowerUnit.fwri " + this.fwri);
        LOGGER.fine("PowerUnit.acInput " + this.acInput);
        LOGGER.fine("PowerUnit.inputTemp " + this.inputTemp);
        LOGGER.fine("PowerUnit.inputTempTrip " + this.inputTempTrip);
        LOGGER.fine("PowerUnit.inputTempFail " + this.inputTempFail);
        LOGGER.fine("PowerUnit.outputTemp " + this.outputTemp);
        LOGGER.fine("PowerUnit.outputTempTrip " + this.outputTempTrip);
        LOGGER.fine("PowerUnit.outTempFail " + this.outTempFail);
        LOGGER.exit("*********PowerUnit.print(" + SOURCE + ")*************");
    }
}

