/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.FANType;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceFansType {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DeviceFansType.class);
    private List<DeviceFanType> deviceFanTypeList = new ArrayList<DeviceFanType>();
    private String redundancy = "";

    void init(List fanList, String redundancy) {
        LOGGER.enter("DeviceFansType.init(" + fanList + "," + redundancy + ")");
        LOGGER.fine("DeviceFansType.init.fanList.size() " + fanList.size());
        this.redundancy = redundancy;
        this.print("DeviceFansType JAXB");
        DeviceFanType deviceFanType = null;
        for (int i = 0; i < fanList.size(); ++i) {
            try {
                deviceFanType = this.getDeviceFanType();
                deviceFanType.init((FANType)fanList.get(i));
                this.addDeviceFanType(deviceFanType);
                continue;
            }
            catch (OAException e) {
                LOGGER.error("DeviceFansType.init(JAXB).OAException " + e);
                LOGGER.exception((Throwable)e);
            }
        }
        LOGGER.exit("DeviceFansType.init(" + fanList + "," + redundancy + ")");
    }

    private void print(String SOURCE) {
        LOGGER.enter("*********DeviceFansType.print(" + SOURCE + ")**************");
        LOGGER.fine("DeviceFansType.redundancy " + this.redundancy);
        LOGGER.exit("*********DeviceFansType.print(" + SOURCE + ")**************");
    }

    public List<DeviceFanType> getDeviceFanTypeList() {
        return this.deviceFanTypeList;
    }

    private DeviceFanType getDeviceFanType() {
        return new DeviceFanType();
    }

    private void addDeviceFanType(DeviceFanType value) {
        this.deviceFanTypeList.add(value);
    }

    public String getRedundancy() {
        return this.redundancy;
    }

    public class DeviceFanType {
        private String type = "";
        private String status = "";
        private String pn = "";
        private String productName = "";
        private String pwrUsed = "";
        private String rpmCur = "";
        private String rpmMax = "";
        private String rpmMin = "";
        private DeviceFanBayOccupanType deviceFanBayOccupanType = new DeviceFanBayOccupanType();

        private void init(FANType fanType) throws OAException {
            LOGGER.enter("DeviceFanType.init(" + fanType + ")");
            try {
                this.type = DCUtil.trimAttribute(fanType.getTYPE());
                this.status = DCUtil.trimAttribute(fanType.getSTATUS());
                this.pn = DCUtil.trimAttribute(fanType.getPN());
                this.productName = DCUtil.trimAttribute(fanType.getPRODUCTNAME());
                if (fanType.getPWRUSED() != null) {
                    this.pwrUsed = fanType.getPWRUSED().toString();
                }
                if (fanType.getRPMCUR() != null) {
                    this.rpmCur = fanType.getRPMCUR().toString();
                }
                if (fanType.getRPMMAX() != null) {
                    this.rpmMax = fanType.getRPMMAX().toString();
                }
                if (fanType.getRPMMIN() != null) {
                    this.rpmMin = fanType.getRPMMIN().toString();
                }
                this.print("DeviceFanType JAXB");
                this.deviceFanBayOccupanType.init(fanType);
            }
            catch (Exception e) {
                LOGGER.error("DeviceFanType.init Exception " + e);
                LOGGER.exception((Throwable)e);
                LOGGER.exit("DeviceFanType.init(" + fanType + ")");
                throw new OAException(e, "DeviceFanType.init(JAXB).Exception " + e);
            }
            LOGGER.exit("DeviceFanType.init(" + fanType + ")");
        }

        private void print(String SOURCE) {
            LOGGER.enter("*********DeviceFanType.print(" + SOURCE + ")***************");
            LOGGER.fine("DeviceFanType.type " + this.type);
            LOGGER.fine("DeviceFanType.status " + this.status);
            LOGGER.fine("DeviceFanType.pn " + this.pn);
            LOGGER.fine("DeviceFanType.productName " + this.productName);
            LOGGER.fine("DeviceFanType.pwrUsed " + this.pwrUsed);
            LOGGER.fine("DeviceFanType.rpmCur " + this.rpmCur);
            LOGGER.fine("DeviceFanType.rpmMax " + this.rpmMax);
            LOGGER.fine("DeviceFanType.rpmMin " + this.rpmMin);
            LOGGER.exit("*********DeviceFanType.print(" + SOURCE + ")***************");
        }

        public String getType() {
            return this.type;
        }

        public String getStatus() {
            return this.status;
        }

        public String getPN() {
            return this.pn;
        }

        public String getProductName() {
            return this.productName;
        }

        public String getPWRDUsed() {
            return this.pwrUsed;
        }

        public String getRPMCur() {
            return this.rpmCur;
        }

        public String getRPMMax() {
            return this.rpmMax;
        }

        public String getRPMMin() {
            return this.rpmMin;
        }

        public DeviceFanBayOccupanType getDeviceFanBayOccupanType() {
            return this.deviceFanBayOccupanType;
        }

        public class DeviceFanBayOccupanType {
            private String connection = "";
            private List occupies;

            private void init(FANType fanType) throws OAException {
                LOGGER.enter("DeviceFanBayOccupanType.init(" + fanType + ")");
                try {
                    this.connection = DCUtil.trimAttribute(fanType.getBAY().getCONNECTION());
                    this.occupies = fanType.getBAY().getOCCUPIES();
                }
                catch (Exception e) {
                    LOGGER.error("DeviceFanBayOccupanType.init Exception " + e);
                    LOGGER.exception((Throwable)e);
                    LOGGER.exit("DeviceFanBayOccupanType.init(" + fanType + ")");
                    throw new OAException(e, "DeviceFanBayOccupanType.init(JAXB).Exception " + e);
                }
                this.print("DeviceFanBayOccupanType JAXB");
                LOGGER.exit("DeviceFanBayOccupanType.init(" + fanType + ")");
            }

            private void print(String SOURCE) {
                LOGGER.enter("*********DeviceFanBayOccupanType.print(" + SOURCE + ")*****************");
                LOGGER.fine("DeviceFanBayOccupanType.connection " + this.connection);
                LOGGER.exit("*********DeviceFanBayOccupanType.print(" + SOURCE + ")*****************");
            }

            public String getCONNECTION() {
                return this.connection;
            }

            public List getOCCUPIES() {
                return this.occupies;
            }
        }
    }
}

