/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.RackTopology;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceFansType;
import com.hp.mx.core.tools.datacollection.http.oa.DeviceTempsType;
import com.hp.mx.core.tools.datacollection.http.oa.EnclosurePowerType;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLBlade;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitch;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYINFOType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BLADEType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.ENCLMGRType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.OVERLORDINFRAType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.SWITCHType;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OLEnclosure.class);
    private String enclosureSerialNumber = "";
    private String enclosureProductName = "";
    private String enclosureName = "";
    private String enclosureAsset = "";
    private String enclosureUUID = "";
    private String enclosureUUIDStatus = "";
    private String enclosureStatus = "";
    private String enclosureAddress = "";
    private String enclosurePartNumber = "";
    private int enclosureHeight = -1;
    private int encloureWidth = -1;
    private int enclosureDepth = -1;
    private String rackName = "";
    private RackTopology rackTopology;
    private List<OLDevice> bladeList = new ArrayList<OLDevice>();
    private List<OLDevice> switchList = new ArrayList<OLDevice>();
    private List<OLDevice> oaList = new ArrayList<OLDevice>();
    private String uniqueIdentifier;
    private DeviceTempsType deviceTempsType = new DeviceTempsType();
    private DeviceFansType deviceFansType = new DeviceFansType();
    private EnclosurePowerType enclosurePowerType = new EnclosurePowerType();
    private VCM vcm;

    public OLEnclosure() {
    }

    public OLEnclosure(RIMPType rimpType) {
        LOGGER.enter("OLEnclosure(" + rimpType + ")");
        if (rimpType.getINFRA2() != null) {
            Invoker.init("initializeINFRA2", rimpType.getINFRA2().getContent(), OLEnclosure.class, this);
        }
        this.rackTopology = new RackTopology(rimpType);
        this.initUniqueIdentifier();
        this.print("OLEnclosure JAXB");
        LOGGER.exit("OLEnclosure(" + rimpType + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_RACKImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_RACKImpl(" + element + ")");
        this.rackName = DCUtil.trimAttribute(((OVERLORDINFRAType.RACK)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_RACKImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ENCLImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ENCLImpl(" + element + ")");
        this.enclosureName = DCUtil.trimAttribute(((OVERLORDINFRAType.ENCL)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ENCLImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_PNImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PNImpl(" + element + ")");
        this.enclosureProductName = DCUtil.trimAttribute(((OVERLORDINFRAType.PN)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PNImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ASSETImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ASSETImpl(" + element + ")");
        this.enclosureAsset = DCUtil.trimAttribute(((OVERLORDINFRAType.ASSET)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ASSETImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(" + element + ")");
        this.enclosureStatus = DCUtil.trimAttribute(((OVERLORDINFRAType.STATUS)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ENCLSNImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ENCLSNImpl(" + element + ")");
        this.enclosureSerialNumber = DCUtil.trimAttribute(((OVERLORDINFRAType.ENCLSN)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_PARTImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PARTImpl(" + element + ")");
        this.enclosurePartNumber = DCUtil.trimAttribute(((OVERLORDINFRAType.PART)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PARTImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_UUIDImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UUIDImpl(" + element + ")");
        this.enclosureUUID = DCUtil.trimAttribute(((OVERLORDINFRAType.UUID)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_UIDSTATUSImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UIDSTATUSImpl(" + element + ")");
        this.enclosureUUIDStatus = DCUtil.trimAttribute(((OVERLORDINFRAType.UIDSTATUS)element).getValue());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UIDSTATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ADDRImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ADDRImpl(" + element + ")");
        this.enclosureAddress = DCUtil.trimAttribute(DCUtil.getHexString(((OVERLORDINFRAType.ADDR)element).getValue()));
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ADDRImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_DIMImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_DIMImpl(" + element + ")");
        OVERLORDINFRAType.DIM dim = (OVERLORDINFRAType.DIM)element;
        this.enclosureHeight = dim.getMmHeight().intValue();
        this.encloureWidth = dim.getMmWidth().intValue();
        this.enclosureDepth = dim.getMmDepth().intValue();
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_DIMImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_BLADESImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_BLADESImpl(" + element + ")");
        OVERLORDINFRAType.BLADES blades = (OVERLORDINFRAType.BLADES)element;
        List tempBladeList = blades.getBLADE();
        List tempBladeBayList = blades.getBAYS().getBAY();
        for (int i = 0; i < tempBladeList.size(); ++i) {
            this.bladeList.add(new OLBlade((BLADEType)tempBladeList.get(i), (BAYINFOType)tempBladeBayList.get(i), this.enclosureProductName));
        }
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_BLADESImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_SWITCHESImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_SWITCHESImpl(" + element + ")");
        OVERLORDINFRAType.SWITCHES switches = (OVERLORDINFRAType.SWITCHES)element;
        List tempSwitchList = switches.getSWITCH();
        List tempSwitchBayList = switches.getBAYS().getBAY();
        for (int i = 0; i < tempSwitchList.size(); ++i) {
            this.switchList.add(new OLSwitch((SWITCHType)tempSwitchList.get(i), (BAYINFOType)tempSwitchBayList.get(i)));
        }
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_SWITCHESImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_MANAGERSImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_MANAGERSImpl(" + element + ")");
        OVERLORDINFRAType.MANAGERS managers = (OVERLORDINFRAType.MANAGERS)element;
        List tempManagerList = managers.getMANAGER();
        List tempManagerBayList = managers.getBAYS().getBAY();
        for (int i = 0; i < tempManagerList.size(); ++i) {
            this.oaList.add(new OnboardAdministrator((ENCLMGRType)tempManagerList.get(i), (BAYINFOType)tempManagerBayList.get(i)));
        }
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_MANAGERSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_FANSImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_FANSImpl(" + element + ")");
        OVERLORDINFRAType.FANSType fansType = (OVERLORDINFRAType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_FANSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_TEMPSImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((OVERLORDINFRAType.TEMPSType)element).getContent());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_TEMPSImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_POWERImpl(Object element) {
        LOGGER.enter("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_POWERImpl(" + element + ")");
        this.enclosurePowerType.init(((OVERLORDINFRAType.POWERType)element).getContent());
        LOGGER.exit("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_POWERImpl(" + element + ")");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_VCMImpl(Object element) {
        LOGGER.enter("OlEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_VCMImpl(" + element + ")");
        OVERLORDINFRAType.VCM vcm = (OVERLORDINFRAType.VCM)element;
        this.vcm = new VCM(vcm);
        LOGGER.exit("OlEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_VCMImpl(" + element + ")");
    }

    private void initUniqueIdentifier() {
        LOGGER.enter("OlEnclosure.initUniqueIdentifier()");
        this.uniqueIdentifier = this.enclosureUUID;
        if (this.uniqueIdentifier == null || this.uniqueIdentifier.trim().length() == 0) {
            this.uniqueIdentifier = this.enclosureSerialNumber;
        }
        LOGGER.exit("OlEnclosure.initUniqueIdentifier()");
    }

    public List<OLDevice> getSwitchList() {
        return this.switchList;
    }

    public List<OLDevice> getBladeList() {
        return this.bladeList;
    }

    public List<OLDevice> getOAList() {
        return this.oaList;
    }

    public OLDevice resolveCurrentOADevice(String MGMTPROC_ADDRESS) throws OAException {
        LOGGER.enter("OLEnclosure.resolveCurrentOADevice(" + MGMTPROC_ADDRESS + ")");
        OLDevice olDevice = null;
        for (int i = 0; i < this.oaList.size(); ++i) {
            olDevice = this.oaList.get(i);
            if (!olDevice.getDeviceMgmtProcIp().equalsIgnoreCase(MGMTPROC_ADDRESS)) continue;
            LOGGER.exit("OLEnclosure.resolveCurrentOADevice(" + MGMTPROC_ADDRESS + ")");
            return olDevice;
        }
        LOGGER.exit("OLEnclosure.resolveCurrentOADevice(" + MGMTPROC_ADDRESS + ")");
        throw new OAException("Unable to resolve current OA device");
    }

    public String getRackName() {
        return this.rackName;
    }

    public RackTopology getRackTopology() {
        return this.rackTopology;
    }

    public String getEnclosureSerialNumber() {
        return this.enclosureSerialNumber;
    }

    public String getEnclosureProductName() {
        return this.enclosureProductName;
    }

    public String getEnclosureName() {
        return this.enclosureName;
    }

    public String getEnclosureAsset() {
        return this.enclosureAsset;
    }

    public String getEnclosureUUID() {
        return this.enclosureUUID;
    }

    public String getEnclosureUUIDStatus() {
        return this.enclosureUUIDStatus;
    }

    public String getEnclosureStatus() {
        return this.enclosureStatus;
    }

    public String getEnclosureAddress() {
        return this.enclosureAddress;
    }

    public String getEnclosurePartNumber() {
        return this.enclosurePartNumber;
    }

    public int getEnclosureHeight() {
        return this.enclosureHeight;
    }

    public int getEnclosureWidth() {
        return this.encloureWidth;
    }

    public int getEnclosureDepth() {
        return this.enclosureDepth;
    }

    public DeviceTempsType getDeviceTempsType() {
        return this.deviceTempsType;
    }

    public DeviceFansType getDeviceFansType() {
        return this.deviceFansType;
    }

    public EnclosurePowerType getEnclosurePowerType() {
        return this.enclosurePowerType;
    }

    public VCM getVCM() {
        return this.vcm;
    }

    public void update(MxNode enclosureMxNode) {
        LOGGER.enter("OLEnclosure.update(" + enclosureMxNode + ")");
        VCM.clean(enclosureMxNode);
        if (this.vcm != null) {
            this.vcm.update(enclosureMxNode);
        }
        DCUtil.commit(enclosureMxNode);
        LOGGER.exit("OLEnclosure.update(" + enclosureMxNode + ")");
    }

    public MxNode getDeviceMxNode() throws OAException {
        LOGGER.enter("OLEnclosure.getDeviceMxNode()");
        MxNode enclosureMxNode = null;
        if (this.enclosureUUID != null && this.enclosureUUID.trim().length() > 0) {
            try {
                enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.enclosureUUID);
            }
            catch (MxException e) {
                LOGGER.fine("OLEnclosure.getDeviceMxNode.MxException Unable to find Enclosure MxNode by enclosureUUID " + (Object)((Object)e));
            }
        }
        if (enclosureMxNode == null) {
            try {
                enclosureMxNode = DCUtil.getNodeBySerialNumber(this.enclosureSerialNumber);
            }
            catch (DCException de) {
                LOGGER.fine("OLEnclosure.getDeviceMxNode.DCException Unable to find Enclosure MxNode : " + de);
                LOGGER.exception((Throwable)de);
            }
        }
        if (enclosureMxNode == null) {
            LOGGER.exit("OLEnclosure.getDeviceMxNode()");
            throw new OAException("OLEnclosure.getDeviceMxNode unable to find enclosure node by uuid/serial number");
        }
        LOGGER.exit("OLEnclosure.getDeviceMxNode()");
        return enclosureMxNode;
    }

    protected void print(String SOURCE) {
        LOGGER.enter("*********OLEnclosure.print(" + SOURCE + ")**************");
        LOGGER.fine("OLEnclosure.enclosureSerialNumber " + this.enclosureSerialNumber);
        LOGGER.fine("OLEnclosure.enclosureProductName " + this.enclosureProductName);
        LOGGER.fine("OLEnclosure.enclosureName " + this.enclosureName);
        LOGGER.fine("OLEnclosure.enclosureAsset " + this.enclosureAsset);
        LOGGER.fine("OLEnclosure.enclosureUUID " + this.enclosureUUID);
        LOGGER.fine("OLEnclosure.enclosureUUIDStatus " + this.enclosureUUIDStatus);
        LOGGER.fine("OLEnclosure.enclosureStatus " + this.enclosureStatus);
        LOGGER.fine("OLEnclosure.enclosureAddress " + this.enclosureAddress);
        LOGGER.fine("OLEnclosure.enclosurePartNumber " + this.enclosurePartNumber);
        LOGGER.fine("OLEnclosure.enclosureHeight " + this.enclosureHeight);
        LOGGER.fine("OLEnclosure.encloureWidth " + this.encloureWidth);
        LOGGER.fine("OLEnclosure.enclosureDepth " + this.enclosureDepth);
        LOGGER.fine("OLEnclosure.rackName " + this.rackName);
        LOGGER.fine("OLEnclosure.uniqueIdentifier " + this.uniqueIdentifier);
        LOGGER.fine("OLEnclosure.bladeList.size() " + this.bladeList.size());
        LOGGER.fine("OLEnclosure.switchList.size() " + this.switchList.size());
        LOGGER.fine("OLEnclosure.oaList.size() " + this.oaList.size());
        if (this.vcm != null) {
            this.vcm.print();
        }
        LOGGER.exit("*********OLEnclosure.print(" + SOURCE + ")**************");
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        if (this.enclosureProductName.toLowerCase().contains("c3000")) {
            subTypeList.add("c3000");
        } else {
            subTypeList.add("c7000");
        }
        return subTypeList;
    }

    public static class VCM {
        private boolean vcmMode = false;
        private String vcmURL = "";
        private String vcmDomainName = "";
        private String vcmDomainId = "";
        private static String[] VCM_CLIENTATTRIBUTES = new String[]{"VCM_MODE", "VCM_URL", "VCM_DOMIAN_NAME", "VCM_DOMAIN_ID"};

        private VCM(OVERLORDINFRAType.VCM vcm) {
            this.vcmMode = vcm.isVcmMode();
            this.vcmURL = DCUtil.trimAttribute(vcm.getVcmUrl());
            this.vcmDomainName = DCUtil.trimAttribute(vcm.getVcmDomainName());
            this.vcmDomainId = DCUtil.trimAttribute(vcm.getVcmDomainId());
        }

        private void print() {
            LOGGER.fine("OLEnclosure.vcmMode " + this.vcmMode);
            LOGGER.fine("OLEnclosure.vcmURL " + this.vcmURL);
            LOGGER.fine("OLEnclosure.vcmDomainName " + this.vcmDomainName);
            LOGGER.fine("OLEnclosure.vcmDomainId " + this.vcmDomainId);
        }

        public boolean getEnclosureVCMMode() {
            return this.vcmMode;
        }

        public String getEnclosureVCMURL() {
            return this.vcmURL;
        }

        public String getEnclosureVCMDomainName() {
            return this.vcmDomainName;
        }

        public String getEnclosureVCMDomainID() {
            return this.vcmDomainId;
        }

        private void update(MxNode enclosureMxNode) {
            if (this.vcmMode) {
                enclosureMxNode.setClientAttribute(VCM_CLIENTATTRIBUTES[0], new Boolean(this.vcmMode).toString());
                if (OAHelper.getOAHelper().isValidURL(this.vcmURL)) {
                    enclosureMxNode.setClientAttribute(VCM_CLIENTATTRIBUTES[1], this.vcmURL);
                    if (!this.vcmDomainName.equals("")) {
                        enclosureMxNode.setClientAttribute(VCM_CLIENTATTRIBUTES[2], this.vcmDomainName);
                    }
                    enclosureMxNode.setClientAttribute(VCM_CLIENTATTRIBUTES[3], this.vcmDomainId);
                }
            }
        }

        private static void clean(MxNode enclosureMxNode) {
            for (int i = 0; i < VCM_CLIENTATTRIBUTES.length; ++i) {
                enclosureMxNode.removeClientAttribute(VCM_CLIENTATTRIBUTES[i]);
            }
        }
    }
}

