/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.soap.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.soap.oa.OAConstants;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MxFileSecurity;
import com.hp.mx.utilities.MxFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class OAFileHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OAFileHandler.class);

    public Hashtable getConfigFiles(String leftOaGuid, String rightOaGuid) {
        LOGGER.enter("********OAFileHandler.getConfigFiles(" + leftOaGuid + ", " + rightOaGuid + ")**********");
        Hashtable<String, String> cfgFileTable = new Hashtable<String, String>();
        File file = new File(OAConstants.CMS_OA_CONFIG_PATH);
        LOGGER.fine("Config path in CMS is " + file.getAbsolutePath());
        Object[] files = file.listFiles();
        String filePrefix1 = leftOaGuid + "_";
        String filePrefix2 = "";
        if (rightOaGuid != null && rightOaGuid.length() != 0) {
            filePrefix2 = rightOaGuid + "_";
        }
        if (files == null) {
            LOGGER.fine("No config files found in " + file.getAbsolutePath());
            return cfgFileTable;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            String fileName = ((File)files[i]).getName();
            LOGGER.finest("checking for the config file File Name : " + fileName);
            if (!fileName.endsWith(".cfg") || !fileName.startsWith(filePrefix1) && (filePrefix2.length() == 0 || !fileName.startsWith(filePrefix2))) continue;
            String filePath = ((File)files[i]).getAbsolutePath();
            String tmpName = this.removeGuidFromFileName(((File)files[i]).getName());
            tmpName = this.removeExtensionFromFileName(tmpName);
            LOGGER.finest("Adding file name : " + tmpName);
            cfgFileTable.put(filePath, tmpName);
        }
        LOGGER.exit("********OAFileHandler.getConfigFiles(" + leftOaGuid + ", " + rightOaGuid + ")**********");
        return cfgFileTable;
    }

    public String removeGuidFromFileName(String fileNameWithGuid) {
        LOGGER.enter("********OAFileHandler.removeGuidFromFileName(" + fileNameWithGuid + ")**********");
        int index = fileNameWithGuid.indexOf("_");
        String tmpName = "";
        if (index != -1) {
            tmpName = fileNameWithGuid.substring(++index);
        }
        LOGGER.exit("********OAFileHandler.removeGuidFromFileName(*" + fileNameWithGuid + ")**********");
        return tmpName;
    }

    public void deleteFile(String[] fileNames) {
        LOGGER.enter("********OAFileHandler.deleteFile() ***********");
        for (int i = 0; i < fileNames.length; ++i) {
            LOGGER.finest("deleting file " + fileNames[i] + " from CMS");
            File f = new File(fileNames[i]);
            f.delete();
        }
        LOGGER.exit("********OAFileHandler.deleteFile() ***********");
    }

    public void saveFile(String guid, String configLabel, String configData) throws IOException {
        LOGGER.enter("********OAFileHandler.saveFile(" + guid + "," + configLabel + "," + configData + ")**********");
        File file = new File(OAConstants.CMS_OA_CONFIG_PATH + "/" + guid + "_" + configLabel + ".cfg");
        LOGGER.fine("File to be saved is " + file.getName());
        MxFileUtil.secureFile((File)file, (MxFileSecurity)MxFileSecurity.ROOTONLY_FILE_DIR);
        LOGGER.fine("File permissions set successfully on " + file.getName());
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(configData.getBytes());
        fout.close();
        LOGGER.exit("********OAFileHandler.saveFile(" + guid + "," + configLabel + "," + configData + ")**********");
    }

    public void deleteAllFiles(String guid) {
        LOGGER.enter("********OAFileHandler.deleteAllFiles(" + guid + ")**********");
        File cfgDir = new File(OAConstants.CMS_OA_CONFIG_PATH);
        File[] files = cfgDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            if (!fileName.startsWith(guid) || !fileName.endsWith(".cfg")) continue;
            LOGGER.finest("deleting file " + fileName);
            files[i].delete();
        }
        LOGGER.exit("******** OAFileHandler.deleteAllFiles(" + guid + ")**********");
    }

    public void deleteAllFiles(String[] allFiles) {
        LOGGER.enter("********OAFileHandler.deleteAllFiles(" + allFiles + ")**********");
        for (int i = 0; i < allFiles.length; ++i) {
            File f;
            if (allFiles[i] == null || (f = new File(allFiles[i])) == null) continue;
            LOGGER.finest("deleting file " + f);
            f.delete();
        }
        LOGGER.exit("******** OAFileHandler.deleteAllFiles(" + allFiles + ")**********");
    }

    public void copyFileToWebappFromConfigDir(String sourceFile, String destinationFile) throws Exception {
        int i;
        LOGGER.enter("********OAFileHandler.copyFileToWebappFromConfigDir(" + sourceFile + "," + destinationFile + ")******");
        FileInputStream fin = new FileInputStream(sourceFile);
        FileOutputStream fout = new FileOutputStream(destinationFile + "/" + "tmpCfg");
        while ((i = fin.read()) != -1) {
            fout.write((char)i);
        }
        fin.close();
        fout.close();
        LOGGER.fine("successfully copied file webapp dir : " + destinationFile);
        LOGGER.exit("********OAFileHandler.copyFileToWebappFromConfigDir(" + sourceFile + "," + destinationFile + ")******");
    }

    public static String getErrorMsg(String reqType, MxLoginBean loginBean) {
        LOGGER.enter("********OAFileHandler.getErrorMsg(" + reqType + ")*************");
        String errorMsg = "";
        if (reqType.equals("delete") || reqType.equals("deleteAll")) {
            errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.delete", loginBean.getLocale());
        }
        if (reqType.equals("save")) {
            errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.save", loginBean.getLocale());
        }
        if (reqType.equals("restore")) {
            errorMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.restore", loginBean.getLocale());
        }
        LOGGER.fine("error message for " + reqType + " is " + errorMsg);
        LOGGER.exit("********OAFileHandler.getErrorMsg(" + reqType + ")*************");
        return errorMsg;
    }

    private String removeExtensionFromFileName(String fileName) {
        LOGGER.enter("********OAFileHandler.removeExtensionFromFileName(" + fileName + ")*******");
        int index = fileName.lastIndexOf(".cfg");
        String tmpName = "";
        if (index != -1) {
            tmpName = fileName.substring(0, index);
        }
        LOGGER.exit("********OAFileHandler.removeExtensionFromFileName(" + fileName + ")*******");
        return tmpName;
    }

    public String getStandByOaGuid(String curOaDeviceKey) throws Exception {
        LOGGER.enter("********OAFileHandler.getStandByOaGuid(" + curOaDeviceKey + ")*******");
        String standByOaGuid = "";
        if (curOaDeviceKey == null) {
            return standByOaGuid;
        }
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        int enclosureDeviceKey = nodeAssociationsManager.getAssociatedDeviceKey(Integer.parseInt(curOaDeviceKey), "MgmtProcToEnclosure");
        Vector oaDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclosureDeviceKey, "MgmtProcToEnclosure");
        Integer oaDevKeyObj = null;
        if (oaDeviceKeyVect != null) {
            for (int j = 0; j < oaDeviceKeyVect.size(); ++j) {
                oaDevKeyObj = (Integer)oaDeviceKeyVect.elementAt(j);
                int oaDevKey = oaDevKeyObj;
                LOGGER.fine("oa device key is " + oaDevKey);
                if (oaDevKey == Integer.parseInt(curOaDeviceKey)) continue;
                LOGGER.fine("found stand by oa guid " + oaDevKey);
                MxNode oaNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(oaDevKey));
                return oaNode.getGUID().toString();
            }
        }
        LOGGER.fine("stand by oa guid not found");
        LOGGER.exit("********OAFileHandler.getStandByOaGuid(" + curOaDeviceKey + ")*******");
        return "";
    }
}

