/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.toolmanager.filter.MxFilterOperator_t;
import com.hp.mx.core.toolmanager.filter.MxNameValueOperator;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssociationHandlerUtil {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(AssociationHandlerUtil.class);

    public static final MxNode getNodeBySerialNumber(String SERIAL_NUMBER) throws HandlerException {
        LOGGER.enter("AssociationHandlerUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
        ArrayList filters = new ArrayList();
        ArrayList<MxNameValueOperator> currentFilter = new ArrayList<MxNameValueOperator>();
        filters.add(currentFilter);
        MxNameValueOperator namevaluePair = null;
        try {
            namevaluePair = new MxNameValueOperator("SerialNumber", MxFilterOperator_t.OPERATOR_EQ, SERIAL_NUMBER);
        }
        catch (MxException e) {
            throw new HandlerException(e, "There is no device matching serial number " + SERIAL_NUMBER + " MxException in AssociationHandlerUtil.getNodeBySerialNumber");
        }
        currentFilter.add(namevaluePair);
        List nodeList = MxNodeController.getDefaultControllerNoEx().getFilterNodes((MxTransaction)new MxCoreTransaction(), filters);
        LOGGER.fine("AssociationHandlerUtil.getNodeBySerialNumber.nodeList.size() " + nodeList.size());
        if (nodeList.size() > 0) {
            return (MxNode)nodeList.get(0);
        }
        throw new HandlerException("There is no device matching serial number " + SERIAL_NUMBER);
    }

    public static List getListOfNodeBySerialNumber(String SERIAL_NUMBER) {
        LOGGER.fine("AssociationHandlerUtil:getListOfNodeBySerialNumber" + SERIAL_NUMBER);
        ArrayList filters = new ArrayList();
        ArrayList<MxNameValueOperator> currentFilter = new ArrayList<MxNameValueOperator>();
        filters.add(currentFilter);
        MxNameValueOperator namevaluePair = null;
        try {
            namevaluePair = new MxNameValueOperator("SerialNumber", MxFilterOperator_t.OPERATOR_EQ, SERIAL_NUMBER);
        }
        catch (Exception e) {
            LOGGER.error("can not find Node with serial Number" + SERIAL_NUMBER);
        }
        currentFilter.add(namevaluePair);
        List nodeList = MxNodeController.getDefaultControllerNoEx().getFilterNodes((MxTransaction)new MxCoreTransaction(), filters);
        return nodeList;
    }

    public static ArrayList<String> getMIBData(String oid, SnmpProtocolDataHandler snmpPdh) {
        LOGGER.enter("AssociationHandlerUtil.getMIBData(" + oid + ")");
        ArrayList<String> dataFrmMIB = new ArrayList<String>();
        String oidFrmMIB = null;
        String uid = null;
        snmpPdh.getSnmpRequest().setAsn1Numbers(oid);
        String data = null;
        while (true) {
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            uid = oid.substring(oid.indexOf(91) + 1, oid.indexOf(93));
            SnmpResponseVarBind resVarBnd = uid == null || uid.length() <= 0 ? curResp.findResponse(oid) : curResp.findById(Integer.parseInt(uid));
            if (resVarBnd == null || resVarBnd.isError()) break;
            oidFrmMIB = resVarBnd.getOid();
            LOGGER.fine("oidFrmMIB:" + oidFrmMIB);
            LOGGER.fine("vb0.getValueType():" + resVarBnd.getValueType());
            if (!oidFrmMIB.startsWith(oid.substring(0, oid.indexOf(91)))) break;
            data = resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("INTEGER") ? resVarBnd.getIntValue() + "" : resVarBnd.getValue());
            LOGGER.fine("dataFrmMIB :" + data);
            if (data == null || data.length() == 0 || data.equals("")) {
                data = "";
            }
            dataFrmMIB.add(data);
            snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            if (uid == null || uid.length() <= 0) {
                uid = "0";
            }
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(oidFrmMIB, uid);
        }
        LOGGER.exit("AssociationHandlerUtil.getMIBData(" + oid + ")");
        return dataFrmMIB;
    }

    public static void displayNodeAssociations(NodeAssociations myNodeRelationships) {
        LOGGER.enter("Start: displayNodeAssociations()");
        LOGGER.fine("DeviceKey:" + myNodeRelationships.getDeviceKey());
        LOGGER.fine("SlotNumber:" + myNodeRelationships.getSlotNumber());
        LOGGER.fine("MmHeight:" + myNodeRelationships.getMmHeight());
        LOGGER.fine("MmWidth:" + myNodeRelationships.getMmWidth());
        LOGGER.fine("setMmDepth:" + myNodeRelationships.getMmDepth());
        LOGGER.fine("NumBladeSlotsUsed:" + myNodeRelationships.getNumBladeSlotsUsed());
        LOGGER.fine("NumBladeSlotsUsedXDir:" + myNodeRelationships.getNumBladeSlotsUsedXDir());
        LOGGER.fine("NumBladeSlotsUsedYDir:" + myNodeRelationships.getNumBladeSlotsUsedYDir());
        LOGGER.fine("associationType:" + myNodeRelationships.getSource());
        LOGGER.fine("getSwitchesPresent:" + myNodeRelationships.getSwitchesPresent());
        LOGGER.exit("displayNodeAssociations()");
    }

    public static void displayToplogyVector(Vector<Vector<String>> topology) {
        LOGGER.enter("AssociationHandlerUtil.displayToplogyVector()");
        LOGGER.fine("topology.size():" + topology.size());
        String[] enclAttr = new String[]{"Enclosure UID: ", "Enclosure Name :", "Left Enclosure Name :", "Right Enclosure Name :", "HasServerBlades: ", "HasPowerBlades: ", "Left enclosure UUID: ", "Right enclosure UUID: ", "Enclousre Serial number: ", "Left Enclousre Serial number: ", "Right Enclousre Serial number: "};
        for (Vector<String> enclInfo : topology) {
            LOGGER.fine("Size of each topo:" + enclInfo.size());
            for (int j = 0; j < enclInfo.size(); ++j) {
                LOGGER.fine(enclAttr[j] + enclInfo.get(j) + " :index" + j);
            }
        }
        LOGGER.exit("End:AssociationHandlerUtil.displayToplogyVector()");
    }

    public static MxNode getAssocDeviceNode(MxNode node, String atn, boolean isRdOnly) {
        LOGGER.enter("AssociationHandlerUtil.getAssocDeviceNode()");
        LOGGER.fine("Node Name:" + node.getNameString());
        LOGGER.fine("ATN:" + atn);
        MxNode assocDevice = null;
        NodeAssociationsManager nodeAssocMgr = null;
        try {
            nodeAssocMgr = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Unable to obtain NodeAssocMgr" + (Object)((Object)e));
            LOGGER.exit("End:AssociationHandlerUtil.getAssocDeviceNode()");
            return assocDevice;
        }
        int assocDevKey = nodeAssocMgr.getAssociatedDeviceKey(node.getDeviceKey(), atn);
        if (assocDevKey != 0) {
            try {
                assocDevice = isRdOnly ? MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(assocDevKey) : MxNodeController.getDefaultControllerNoEx().getNodeByKey(assocDevKey);
            }
            catch (MxUndefinedNodeException e) {
                LOGGER.fine("Node not defined" + (Object)((Object)e));
            }
        }
        LOGGER.exit("End:AssociationHandlerUtil.getAssocDeviceNode()");
        return assocDevice;
    }

    public static int setRckTplgyIloXML(Element rootElement, String hostEnclSerNo, String hostEnclName, HashMap<String, String> enclProdIDMap, Vector<Vector<String>> rkTopolgy) {
        LOGGER.enter("AssociationHandlerUtil.getRackToplogyIlo(" + rootElement + ")");
        int hostEnclIndex = -1;
        if (rootElement == null) {
            LOGGER.fine("The rootElement that points to <RIMP> in ilo XML is null");
            LOGGER.fine("Exit:getRackToplogyIlo(" + rootElement + ")");
            return hostEnclIndex;
        }
        List rkToplgyLst = rootElement.getChildren("RK_TPLGY");
        if (rkToplgyLst == null) {
            LOGGER.fine("Unble to obtain <RK_TPLGY> from the root element.");
            LOGGER.fine("Exit:getRackToplogyIlo(" + rootElement + ")");
            return hostEnclIndex;
        }
        Element rkToplgy2 = null;
        String enclSer = null;
        String enclUUID = null;
        for (Element rkToplgy2 : rkToplgyLst) {
            List icmbList = rkToplgy2.getChildren("ICMB");
            Element icmbElems2 = null;
            int count = 0;
            for (Element icmbElems2 : icmbList) {
                Vector<String> tplgy = new Vector<String>();
                enclUUID = icmbElems2.getAttributeValue("UUID");
                if (enclUUID != null && enclUUID.trim().length() > 0 && enclUUID.trim().length() >= 10) {
                    tplgy.add(enclUUID);
                } else {
                    tplgy.add("");
                }
                enclSer = icmbElems2.getAttributeValue("SER");
                if (enclSer != null && hostEnclSerNo != null && enclSer.equalsIgnoreCase(hostEnclSerNo)) {
                    hostEnclIndex = count;
                    if (hostEnclName != null) {
                        tplgy.add(hostEnclName);
                    } else {
                        tplgy.add("");
                    }
                } else {
                    tplgy.add("");
                }
                Element icmbElem = icmbElems2.getChild("RIGHT");
                String topNgbrName = icmbElem.getAttributeValue("NAME");
                if (topNgbrName != null && topNgbrName.trim().length() > 0) {
                    tplgy.add(topNgbrName);
                } else {
                    tplgy.add("");
                }
                icmbElem = icmbElems2.getChild("LEFT");
                String botNgbrName = icmbElem.getAttributeValue("NAME");
                if (botNgbrName != null && botNgbrName.trim().length() > 0) {
                    tplgy.add(botNgbrName);
                } else {
                    tplgy.add("");
                }
                String enclProdId = icmbElems2.getAttributeValue("PROD_ID");
                if (enclProdId.equalsIgnoreCase("0x0003") || enclProdId.equalsIgnoreCase("0x0005")) {
                    tplgy.add("false");
                    tplgy.add("true");
                } else {
                    tplgy.add("true");
                    tplgy.add("false");
                }
                icmbElem = icmbElems2.getChild("RIGHT");
                String topEnclUUID = icmbElem.getAttributeValue("UUID");
                if (topEnclUUID != null && topEnclUUID.trim().length() > 0 && topEnclUUID.trim().length() >= 10) {
                    tplgy.add(topEnclUUID);
                } else {
                    tplgy.add("");
                }
                String topEnclSerNum = icmbElem.getAttributeValue("SER");
                icmbElem = icmbElems2.getChild("LEFT");
                String botEnclUuid = icmbElem.getAttributeValue("UUID");
                String botSerNum = icmbElem.getAttributeValue("SER");
                if (botEnclUuid != null && botEnclUuid.trim().length() > 0 && botEnclUuid.trim().length() >= 10) {
                    tplgy.add(botEnclUuid);
                } else {
                    tplgy.add("");
                }
                if (enclSer != null) {
                    tplgy.add(enclSer);
                    enclProdIDMap.put(enclSer, enclProdId.substring(enclProdId.indexOf(120), enclProdId.length()));
                } else {
                    tplgy.add("");
                }
                if (topEnclSerNum != null) {
                    tplgy.add(topEnclSerNum);
                } else {
                    tplgy.add("");
                }
                if (botSerNum != null) {
                    tplgy.add(botSerNum);
                } else {
                    tplgy.add("");
                }
                rkTopolgy.add(tplgy);
                LOGGER.fine("Added the enclousre information for enclosurewith UUID ." + enclUUID);
                ++count;
            }
        }
        LOGGER.fine("Host Enclosure Index:" + hostEnclIndex);
        LOGGER.fine("The rack topology vector:");
        AssociationHandlerUtil.displayToplogyVector(rkTopolgy);
        LOGGER.exit("AssociationHandlerUtil.getRackToplogyIlo(" + rootElement + ")");
        return hostEnclIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeAssociations loadAssocFrmDB(int deviceDbKey, NodeAssociationsManager nodeAssocMgr) {
        LOGGER.enter("AssociationHandlerUtil.loadAssociationFromDB(" + deviceDbKey + "," + nodeAssocMgr + ")");
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        NodeAssociations na = nodeAssocMgr.getNodeAssociations(deviceDbKey, true);
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("HurricaneAssociationHandler.loadAssociationDataFromDb");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
            int devKey1 = -1;
            int devKey2 = -1;
            String atn = null;
            while (myResultSet.next()) {
                devKey1 = myResultSet.getInt(1);
                devKey2 = myResultSet.getInt(2);
                atn = myResultSet.getString(3).trim();
                if (devKey1 != deviceDbKey) continue;
                LOGGER.fine("Setting " + atn + " between " + devKey1 + " and " + devKey2 + " .");
                if (atn.indexOf("Enclosure") > -1) {
                    na.setInContainer(true);
                    na.setParent(devKey2);
                    na.setTheAssociation(deviceDbKey, devKey2, atn, false);
                    LOGGER.fine("Setting the parent and container.");
                    continue;
                }
                if (atn.indexOf("MgmtProcToServer") <= -1 && atn.indexOf("MgmtProcToDesktop") <= -1) continue;
                na.setTheAssociation(deviceDbKey, devKey2, atn, true);
                try {
                    boolean isIA;
                    MxNode node = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceDbKey);
                    String modelName = node.getModel().toLowerCase();
                    String iaModelName = "integrated administrator";
                    boolean bl = isIA = modelName.indexOf("integrated administrator") > -1;
                    if (!node.getDeviceType().equalsIgnoreCase("MgmtProc") || isIA) continue;
                    na.setInContainer(true);
                    na.setParent(devKey2);
                }
                catch (MxUndefinedNodeException excep) {
                    LOGGER.fine("Unable to obtain MxNode for devicewith deviceKey" + deviceDbKey);
                }
            }
            myResultSet.close();
            myStatement.close();
            myResultSet = null;
            myStatement = null;
            nodeAssocMgr.releaseConnections(myConnection, myStatement, myResultSet);
        }
        catch (SQLException sqlEx) {
            LOGGER.fine("SQLException" + sqlEx);
        }
        finally {
            nodeAssocMgr.releaseConnections(myConnection, myStatement, myResultSet);
        }
        na = nodeAssocMgr.loadDeviceDimensionInfo(deviceDbKey, na);
        nodeAssocMgr.update(na);
        LOGGER.exit("AssociationHandlerUtil.loadAssociationFromDB(" + deviceDbKey + "," + nodeAssocMgr + ")");
        return na;
    }

    public static int getintValue(String intStr) {
        return intStr != null ? new Integer(intStr) : -1;
    }

    public static void setILOAsscociatedAttributes(MxNode serverMxNode, MxNode iLOMxNode) {
        LOGGER.enter("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
        if (iLOMxNode == null || serverMxNode == null) {
            LOGGER.fine("Client attributes are not set.");
            LOGGER.exit("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
            return;
        }
        if (iLOMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ILO2_SUBTYPE.toString())) {
            serverMxNode.setClientAttribute("ILOTypeAssociated", NodeSubTypeMapper.ILO2_SUBTYPE.toString());
        } else {
            serverMxNode.setClientAttribute("ILOTypeAssociated", NodeSubTypeMapper.ILO_SUBTYPE.toString());
        }
        serverMxNode.setClientAttribute("iloDeviceKey", String.valueOf(iLOMxNode.getDeviceKey()));
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
            LOGGER.fine("Client attributes set for server: " + serverMxNode.getNameString());
        }
        catch (MxException e) {
            LOGGER.fine("Client attributes are not set, Exception:" + (Object)((Object)e));
        }
        LOGGER.exit("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
    }

    public static void setILOAttributesOnServer(MxNode serverMxNode) {
        LOGGER.enter("PClassServerHandler.setILOAttributesOnServer(" + serverMxNode + ")");
        try {
            int iLOdevKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(serverMxNode.getDeviceKey(), "MgmtProcToServer_Ilo");
            MxNode iLOMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(iLOdevKey);
            AssociationHandlerUtil.setILOAsscociatedAttributes(serverMxNode, iLOMxNode);
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Unable to set ILO attributes on server, Exception:" + (Object)((Object)e));
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.fine("Unable to set ILO attributes on server, Exception:" + (Object)((Object)e));
        }
        LOGGER.exit("PClassServerHandler.setILOAttributesOnServer(" + serverMxNode + ")");
    }
}

