/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.PClassServerHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;

public class BladeSystemServerHandler
extends PClassServerHandler {
    private static final DebugSubsystem m_logger = new DebugSubsystem(BladeSystemServerHandler.class);

    public BladeSystemServerHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        m_logger.enter("BladeSystemServerHandler.getAssociationData(MxNode " + d.getNameString() + ",DeviceIdentificationData " + idInfo);
        if (!d.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            m_logger.fine("The Device is not p-class device.So Cleaning up the associations");
            return;
        }
        if (!MonteroSNMPUtils.checkSNMP(d)) {
            m_logger.fine("WorkingAddress is null for the device " + d.getNameString());
            return;
        }
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            m_logger.exception("InterruptedException in BladeSystemServerHandler.getAssociationData" + e);
        }
        int enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
        m_logger.fine("Enclosure device Key :" + enclDevKey);
        if (enclDevKey > 0) {
            this.getSwitchAttributesFromTheMib();
            String leftSWSerialNumber = this.getLeftSwitchSerialNumber();
            m_logger.fine("Left Switch Serial Number reported by the server:" + leftSWSerialNumber);
            String rightSWSerialNumber = this.getRightSwitchSerialNumber();
            m_logger.fine("Right Switch Serial Number reported by the server:" + rightSWSerialNumber);
            if (leftSWSerialNumber != null) {
                m_logger.finer("Left Switch Serial Number is not null.Set this as a client Attribure on the server node");
                d.setClientAttribute("compaq.devices.LeftSWSerialNo", leftSWSerialNumber);
                try {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                catch (MxException e) {
                    m_logger.exception("Exception While Modifying the node" + (Object)((Object)e));
                }
                this.checkSwitchToEnclosureAssociation(leftSWSerialNumber, enclDevKey, 0);
            }
            if (rightSWSerialNumber != null) {
                m_logger.finer("Right Switch Serial Number is not null.Set this as a client Attribure on the server node");
                d.setClientAttribute("compaq.devices.RightSWSerialNo", rightSWSerialNumber);
                try {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                catch (MxException e) {
                    m_logger.exception("Exception while modifying the switch node" + (Object)((Object)e));
                }
                this.checkSwitchToEnclosureAssociation(rightSWSerialNumber, enclDevKey, 9999);
            }
        } else {
            m_logger.fine("Enclosure not associated for device " + d.getNameString());
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        NodeAssociationsManager.releaseWriteLock();
        m_logger.exit("BladeSystemServerHandler.getAssociationData");
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        m_logger.enter("BladeSystemServerHandler.buildContainerTree()");
        m_logger.fine("node1.name:" + node1.getNameString());
        m_logger.fine("node1.getDeviceType:" + node1.getDeviceType());
        m_logger.fine("node2.name:" + node2.getNameString());
        m_logger.fine("node2.getDeviceType:" + node2.getDeviceType());
        if (node1.getDeviceType().equals("Server") && node2.getDeviceType().equals("Enclosure")) {
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
            myAssoc.setInContainer(true);
            myAssoc.setParent(node2.getDeviceKey());
        }
        m_logger.exit("BladeSystemServerHandler.buildContainerTree()");
        return myAssoc;
    }

    public void doEnclosureDeviceProcessing(int switchKey, int enclKey, int switchSlotNumber) {
        m_logger.enter("BladeSystemServerHandler.doEnclosureDeviceProcessing(int " + switchKey + ",int " + enclKey + ",int " + switchSlotNumber);
        NodeAssociations theEnclNodeAssociations = null;
        NodeAssociations theSwitchAssociation = this.myNodeRelationshipManager.getNodeAssociations(switchKey);
        if (theSwitchAssociation == null) {
            theSwitchAssociation = new NodeAssociations(switchKey);
        }
        if ((theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclKey)) != null) {
            theSwitchAssociation.setTheAssociation(switchKey, enclKey, "SwitchToEnclosure", false);
            try {
                MxNode switchMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(switchKey);
                MxNode enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclKey);
                switchMxNode.setEnclosureName(enclNode.getNameString());
                switchMxNode.setRackName(enclNode.getRackName());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchMxNode, false);
            }
            catch (MxException e) {
                m_logger.exception("MxException in BladeSystemServerHandler.doEnclosureDeviceProcessing" + (Object)((Object)e));
            }
            this.addDeviceToTopologyTree(theEnclNodeAssociations, switchKey);
            theSwitchAssociation.setSlotNumber(switchSlotNumber);
            theSwitchAssociation.setInContainer(true);
            theSwitchAssociation.setParent(enclKey);
            NodeAssociations theRackNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclNodeAssociations.getParentDeviceKey());
            if (theRackNodeAssociations != null) {
                this.addTreeNodeToTopologyTree(theRackNodeAssociations, enclKey, null, null);
                this.myNodeRelationshipManager.update(theRackNodeAssociations);
            }
            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
            this.myNodeRelationshipManager.update(theSwitchAssociation);
        }
        m_logger.exit("BladeSystemServerHandler.doEnclosureDeviceProcessing");
    }

    private void checkSwitchToEnclosureAssociation(String switchSerNumber, int enclDevKey, int switchSlot) {
        m_logger.enter("BladeSystemServerHandler.checkSwitchToEnclsoureAssociation(String " + switchSerNumber + ",int " + enclDevKey + ",int " + switchSlot);
        List switchList = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("compaq.devices.SwitchHPSerialNo", switchSerNumber);
        int switchDevKey = -1;
        m_logger.fine("switchList size:" + switchList.size());
        for (int i = 0; i < switchList.size(); ++i) {
            switchDevKey = (Integer)switchList.get(i);
        }
        m_logger.fine("Jamocha switch deviceKey:" + switchDevKey);
        if (switchDevKey > 0) {
            try {
                String jamochaModel = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(switchDevKey).getModel();
                if (jamochaModel.matches("Cisco Gigabit Ethernet Switch Module.*.HP BladeSystem p-Class")) {
                    int tempEnclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(switchDevKey, "SwitchToEnclosure");
                    m_logger.fine("Enclosure deviceKey Jamocha switch is associated with associated with:" + tempEnclDevKey);
                    if (tempEnclDevKey == 0) {
                        m_logger.finer("Enclosure device Key is 0.Associate with the proper Enclosure with device key:" + enclDevKey);
                        this.doEnclosureDeviceProcessing(switchDevKey, enclDevKey, switchSlot);
                    }
                }
            }
            catch (MxUndefinedNodeException e) {
                m_logger.error("MxUndefinedNodeException in BladeSystemServerHandler.setSwitchToEnclsoureAssociation");
            }
        }
        m_logger.exit("BladeSystemServerHandler.checkSwitchToEnclosureAssociation");
    }
}

