/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.SwitchAssociationDataHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public class BladeSystemSwitchHandler
extends SwitchAssociationDataHandler {
    private String m_hpSerialNumber = "";
    private static final DebugSubsystem m_logger = new DebugSubsystem(BladeSystemSwitchHandler.class);

    public BladeSystemSwitchHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        m_logger.enter("BladeSystemSwitchHandler.getAssociationData(MxNode " + d + ",DeviceIdentificationData " + idInfo);
        if (!d.getModel().matches("Cisco Gigabit Ethernet Switch Module.*.HP BladeSystem p-Class")) {
            m_logger.fine("The device is not a jamocha switch");
            return;
        }
        if (!MonteroSNMPUtils.checkSNMP(d)) {
            m_logger.fine("SNMP DISABLED GLOBALLY on " + d.getNameString());
            return;
        }
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e1) {
            m_logger.error("InterruptedException in BladeSystemSwitchHandler.getAssociationData" + e1);
        }
        String ciscoSerialNumber = null;
        ciscoSerialNumber = this.snmpPdh.getStrValueFromMib("1.3.6.1.2.1.47.1.1.1.1.11.1001[1]", true);
        if (ciscoSerialNumber != null) {
            this.m_hpSerialNumber = this.convertCiscoToHPSerialNumber(ciscoSerialNumber);
            d.setClientAttribute("compaq.devices.SwitchHPSerialNo", this.m_hpSerialNumber);
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
            }
            catch (MxException e) {
                m_logger.exception("MxException in BladeSystemSwitchHandler.getAssociationData");
            }
        } else {
            m_logger.fine("Switch Serial number is null for device : " + d.getNameString());
            return;
        }
        this.getEnclosureInfoFromServer(d);
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        NodeAssociationsManager.releaseWriteLock();
        m_logger.exit("BladeSystemSwitchHandler.getAssociationData");
    }

    public void doEnclosureDeviceProcessing(MxNode switchNode, int enclKey, int switchSlotNo) {
        m_logger.enter("BladeSystemSwitchHandler.doEnclosureDeviceProcessing(MxNode " + switchNode.getNameString() + ",int " + enclKey + ",int " + switchSlotNo);
        NodeAssociations theEnclNodeAssociations = null;
        theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclKey);
        if (theEnclNodeAssociations != null) {
            int switchKey = switchNode.getDeviceKey();
            this.myNodeRelationships.setTheAssociation(switchKey, enclKey, "SwitchToEnclosure", false);
            m_logger.fine("Association between Jamocha switch and Enclosure is done.");
            m_logger.finer("Add the Jamocha switch to the Topology tree");
            this.addDeviceToTopologyTree(theEnclNodeAssociations, switchKey);
            this.myNodeRelationships.setSlotNumber(switchSlotNo);
            this.myNodeRelationships.setInContainer(true);
            this.myNodeRelationships.setParent(enclKey);
            int rakDeviceKey = theEnclNodeAssociations.getParentDeviceKey();
            try {
                String enclName = MxNodeController.getDefaultController().getNodeByKey(enclKey).getNameString();
                m_logger.finer("Set the Enclsoure name as " + enclName + " on Switch node");
                switchNode.setEnclosureName(enclName);
                MxNode rackNode = MxNodeController.getDefaultController().getNodeByKey(rakDeviceKey);
                m_logger.finer("set the rack name as " + rackNode.getNameString());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
                NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(rackNode.getDeviceKey());
                this.updateDevContainerAndRoleNames(rackNode);
            }
            catch (MxException e) {
                m_logger.error("MxException in BladeSystemSwitchHandler.doEnclosureDeviceProcessing");
            }
            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
        }
        m_logger.exit("BladeSystemSwitchHandler.doEnclosureDeviceProcessing");
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    private String convertCiscoToHPSerialNumber(String ciscoSerialNumber) {
        m_logger.enter("BladeSystemSwitchHandler.convertCiscoToHPSerialNumber(String " + ciscoSerialNumber);
        StringBuffer tmpSerialNumber = new StringBuffer();
        tmpSerialNumber = tmpSerialNumber.append("CN8");
        int subString1 = Integer.parseInt(ciscoSerialNumber.substring(3, 5), 10);
        m_logger.fine("subString1:" + subString1);
        m_logger.fine("After subtracting with 4:" + (subString1 -= 4));
        if (subString1 < 10) {
            tmpSerialNumber = tmpSerialNumber.append("0");
            m_logger.fine("subString is less than 10.So append 0 to tmpSerialNumber:" + tmpSerialNumber);
        }
        if (subString1 < 0) {
            subString1 = 0;
        }
        m_logger.fine("subString1:" + subString1);
        String subString2 = ciscoSerialNumber.substring(5, 7);
        m_logger.fine("subString2:" + subString2);
        String subString3 = ciscoSerialNumber.substring(8, 11);
        m_logger.fine("subString3:" + subString3);
        String genhpSerialNumber = tmpSerialNumber.append(subString1).append(subString2).append(subString3).toString();
        m_logger.fine("HP Serial number for Jamocha switch:" + genhpSerialNumber);
        m_logger.exit("BladeSystemSwitchHandler.convertCiscoToHPSerialNumber");
        return genhpSerialNumber;
    }

    private boolean checkSwitchToEnclosureAssociation(String switchSerNo, MxNode switchNode, int enclDevKey, int switchSlotNo) {
        m_logger.enter("BladeSystemSwitchHandler.checkSwitchToEnclosureAssociation(String " + switchSerNo + ",int " + enclDevKey + ",int " + switchSlotNo + ")");
        m_logger.fine("The HP Serial number for Jamocha:" + this.m_hpSerialNumber);
        if (switchSerNo.equalsIgnoreCase(this.m_hpSerialNumber)) {
            m_logger.fine("The Switch serial number and server reported serial numbers are same");
            int tmpenclDevKey = 0;
            tmpenclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(switchNode.getDeviceKey(), "SwitchToEnclosure");
            m_logger.fine("Jamocha switch is associated with the Enclosure with device Key:" + tmpenclDevKey);
            if (tmpenclDevKey == 0) {
                m_logger.fine("Enclosure device Key is 0.Associate with the proper Enclosure with device key:" + enclDevKey);
                this.doEnclosureDeviceProcessing(switchNode, enclDevKey, switchSlotNo);
                return true;
            }
        }
        m_logger.exit("BladeSystemSwitchHandler.checkSwitchToEnclosureAssociation");
        return false;
    }

    private void getEnclosureInfoFromServer(MxNode switchNode) {
        m_logger.enter("BladeSystemSwitchHandler.getEnclosureInfoFromServer(MxNode " + switchNode.getNameString() + ")");
        Vector listofDevKeys = this.myNodeRelationshipManager.getDevicesThatHaveAssociationsUsingATNs("ServerToEnclosure");
        int devKeysSize = listofDevKeys.size();
        m_logger.finer("Number of devices with ServerToEnclsoure Association:" + devKeysSize);
        Integer devKey = null;
        for (int i = 0; i < devKeysSize; ++i) {
            devKey = (Integer)listofDevKeys.elementAt(i);
            MxNode serverNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(devKey);
            m_logger.fine("Server Node:" + serverNode.getNameString());
            if (!serverNode.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) continue;
            String leftSWSerialNumber = serverNode.getClientAttribute("compaq.devices.LeftSWSerialNo");
            m_logger.fine("Left Switch Serial number:" + leftSWSerialNumber);
            String rightSWSerialNumber = serverNode.getClientAttribute("compaq.devices.RightSWSerialNo");
            m_logger.fine("Right Switch serial number:" + rightSWSerialNumber);
            int enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(serverNode.getDeviceKey(), "ServerToEnclosure");
            m_logger.fine("The Enclosure device Key Server is associated with:" + enclDevKey);
            if (enclDevKey > 0 && (leftSWSerialNumber != null && this.checkSwitchToEnclosureAssociation(leftSWSerialNumber, switchNode, enclDevKey, 0) || rightSWSerialNumber != null && this.checkSwitchToEnclosureAssociation(rightSWSerialNumber, switchNode, enclDevKey, 9999))) break;
        }
        m_logger.exit("BladeSystemSwitchHandler.getEnclosureInfoFromServer");
    }
}

