/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitch;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.tree.DefaultMutableTreeNode;

public class OverlordSwitchHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem m_logger = new DebugSubsystem(OverlordSwitchHandler.class);

    public OverlordSwitchHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode switchNode, DeviceIdentificationData idInfo) {
        m_logger.enter("OverlordSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
        if (switchNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            String serialNumberOfSwitch = switchNode.getSerialNumber();
            m_logger.fine("Serial Number of a switch :" + switchNode.getSerialNumber());
            if (serialNumberOfSwitch == null || serialNumberOfSwitch.trim().length() == 0) {
                serialNumberOfSwitch = this.getSwitchSerialNumberFromMib(switchNode);
            }
            if (serialNumberOfSwitch != null && serialNumberOfSwitch.trim().length() > 0) {
                switchNode.setSerialNumber(serialNumberOfSwitch);
                m_logger.fine("switchNode.getSerialNumber:" + switchNode.getSerialNumber());
                this.doEnclosureDeviceProcessing(switchNode);
            }
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
        }
        m_logger.exit("OverlordSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        block16: {
            m_logger.enter("OverlordSwitchHandler.loadAssociationDataFromDb(" + device + ")");
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            m_logger.fine("OverlordSwitchHandler.loadAssociationDataFromDb: In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (device == null || !device.getDeviceType().equals("Switch") || !associationTypeNumber.equalsIgnoreCase("SwitchToEnclosure") || deviceKey1 != deviceDbKey) continue;
                na.setInContainer(true);
                na.setParent(deviceKey2);
                na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
            }
            m_logger.fine("OverlordSwitchHandler.loadAssociationDataFromDb: loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
            try {
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            break block16;
            catch (SQLException myException) {
                try {
                    m_logger.exception("OverlordSwitchHandler.loadAssociationDataFromDb: Failed to get the vector of devices that have associations " + myException);
                }
                catch (Throwable throwable) {
                    try {
                        myResultSet.close();
                        myStatement.close();
                        myResultSet = null;
                        myStatement = null;
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                try {
                    myResultSet.close();
                    myStatement.close();
                    myResultSet = null;
                    myStatement = null;
                }
                catch (SQLException sqle) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    private void doEnclosureDeviceProcessing(MxNode switchNode) {
        m_logger.enter("OverlordSwitchHandler.doEnclosureDeviceProcessing(" + switchNode + ")");
        m_logger.fine("OverlordSwitchHandler.doEnclosureDeviceProcessing: Switch Serial Number :" + switchNode.getSerialNumber());
        try {
            String enclName;
            OAHelper myOAHelper = OAHelper.getOAHelper();
            MxNode enclORDevice = null;
            OLSwitch myOLSwitch = null;
            try {
                enclORDevice = myOAHelper.getDeviceNodeHavingProperty(switchNode.getSerialNumber());
            }
            catch (Exception e) {
                m_logger.exception("OverlordSwitch.doEnclosureDeviceProcessing unable to find enclosure node by switch serialnumber ");
            }
            if (enclORDevice != null && !enclORDevice.getDeviceType().equals("Enclosure") && (enclName = switchNode.getEnclosureName()) != null && enclName.length() > 0) {
                try {
                    MxNode enclMxNode;
                    enclORDevice = enclMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                }
                catch (MxException e) {
                    m_logger.fine("Logical Node not created, enclORDevice is encl node & data available on enclosure node");
                }
            }
            myOLSwitch = (OLSwitch)myOAHelper.getOLDevice(switchNode, enclORDevice);
            if (enclORDevice != null && enclORDevice.getDeviceType().equals("Enclosure")) {
                m_logger.fine("OverlordSwitchHandler.doEnclosureDeviceProcessing: enclosure node found with device key :" + enclORDevice.getDeviceKey());
                this.makeSwitchToEnclAssociation(switchNode, enclORDevice.getDeviceKey());
                if (this.myNodeRelationships.getSlotNumber() <= 0) {
                    this.myNodeRelationships.setSlotNumber(myOLSwitch.getDeviceSlot());
                    this.myNodeRelationships.setNumBladeSlotsUsedXDir(myOLSwitch.getDeviceSlotsInXDirection());
                    this.myNodeRelationships.setNumBladeSlotsUsedYDir(myOLSwitch.getDeviceSlotsInYDirection());
                    this.myNodeRelationships.setMmHeight(myOLSwitch.getDeviceHeight());
                    this.myNodeRelationships.setMmWidth(myOLSwitch.getDeviceWidth());
                    this.myNodeRelationships.setMmDepth(myOLSwitch.getDeviceDepth());
                    this.myNodeRelationships.setInContainer(true);
                }
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclORDevice, false);
            } else if (enclORDevice != null && enclORDevice.getDeviceType().equals("Switch")) {
                m_logger.fine("OverlordSwitchHandler.doEnclosureDeviceProcessing: logicalNode found with device key:" + enclORDevice.getDeviceKey());
                MxNode enclosureNode = this.getAssociatedNode(enclORDevice, "SwitchToEnclosure");
                this.makeSwitchToEnclAssociation(switchNode, enclosureNode.getDeviceKey());
                NodeAssociations thelogicalSwitchAssociations = null;
                thelogicalSwitchAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclORDevice.getDeviceKey());
                this.myNodeRelationships.setSlotNumber(thelogicalSwitchAssociations.getSlotNumber());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(thelogicalSwitchAssociations.getNumBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(thelogicalSwitchAssociations.getNumBladeSlotsUsedYDir());
                this.myNodeRelationships.setMmHeight(thelogicalSwitchAssociations.getMmHeight());
                this.myNodeRelationships.setMmWidth(thelogicalSwitchAssociations.getMmWidth());
                this.myNodeRelationships.setMmDepth(thelogicalSwitchAssociations.getMmDepth());
                this.myNodeRelationships.setInContainer(true);
                NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
                DefaultMutableTreeNode topologyTree = na.getContainerDeviceTree();
                this.removeBladeFromTopology(enclORDevice.getDeviceKey(), topologyTree);
                this.myNodeRelationshipManager.update(na);
                thelogicalSwitchAssociations.removeTheAssociation(enclORDevice.getDeviceKey(), "SwitchToEnclosure");
                this.myNodeRelationshipManager.update(thelogicalSwitchAssociations);
                this.cleanUpAssociationData(enclORDevice, "SwitchToEnclosure");
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
            } else {
                this.checkNodeInDB(switchNode);
            }
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
        }
        catch (Exception e) {
            m_logger.exception("OverlordSwitchHandler.doEnclosureDeviceProcessing: exception  :" + e);
        }
        m_logger.exit("OverlordSwitchHandler.doEnclosureDeviceProcessing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSwitchToEnclAssociation(MxNode switchNode, int theEnclDeviceKey) {
        m_logger.enter("OverlordSwitchHandler.makeAssociation(" + switchNode + "," + theEnclDeviceKey + ")");
        m_logger.fine("switchNode Device Key:" + switchNode.getDeviceKey());
        m_logger.fine("enclosure Device Key:" + theEnclDeviceKey);
        MxNode syncObject = switchNode;
        try {
            MxNode enclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
            if (na != null) {
                syncObject = na;
            }
            MxNode mxNode = syncObject;
            synchronized (mxNode) {
                if (na != null) {
                    int myDeviceKey = switchNode.getDeviceKey();
                    this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "SwitchToEnclosure", false);
                    this.addDeviceToTopologyTree(na, myDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    MxNode theRackDevice = this.getAssociatedNode(enclosureNode, "EnclosureToRack");
                    this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), enclosureNode.getDeviceKey());
                    m_logger.fine("OverlordSwitchHandler.makeAssociation: switchToEnclosure association set between :" + myDeviceKey + "and" + theEnclDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                    this.updateDevContainerAndRoleNames(theRackDevice);
                    switchNode.setEnclosureName(enclosureNode.getNameString());
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
                }
            }
        }
        catch (Exception e) {
            m_logger.exception("OverlordSwitchHandler.makeAssociation: Exception :" + e);
        }
    }

    private void checkNodeInDB(MxNode d) {
        NodeAssociations dTmpNodeAssociations;
        m_logger.enter("OverlordSwitchHandler.checkNodeInDB(" + d + ")");
        MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
        if (dTmp != null && (dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
            DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
            topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
            this.cleanUpAssociationData(d);
            dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
            this.myNodeRelationshipManager.update(dTmpNodeAssociations);
        }
    }

    private String getSwitchSerialNumberFromMib(MxNode d) {
        String serialNumberFromMib;
        block2: {
            m_logger.enter("OverlordSwitchHandler.getSerialNumberFromMib: d.getNameString()" + d.getNameString());
            boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(d);
            if (!isSNMPSupported) {
                m_logger.fine("End:OverlordSwitchHandler.getSerialNumberFromMib(" + d + ")");
                return null;
            }
            String swserialNumberOID = null;
            serialNumberFromMib = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.2.1.47.1.1.1.1.11[0]");
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findById(0);
                if (vb == null || vb.isError()) break block2;
                swserialNumberOID = vb.getOid();
                if (!swserialNumberOID.startsWith("1.3.6.1.2.1.47.1.1.1.1.11.")) break;
                m_logger.fine("The Switch serial Number OID : " + swserialNumberOID);
                serialNumberFromMib = vb.getValue();
                m_logger.fine(" switch serial Number :" + serialNumberFromMib);
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(swserialNumberOID, "0");
            }
            m_logger.fine("switch serial number oid was not correct" + swserialNumberOID);
        }
        return serialNumberFromMib;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        m_logger.enter("OverlordSwitchHandler.buildContainerTree(" + myAssoc + "," + node1 + "," + node2 + ")");
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        m_logger.enter("OverlordSwitchHandler.cleanUpAssociationData(" + d + ")");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nape) {
            m_logger.exception("OverlordSwitchHandler:cleanUpAssociationData:" + (Object)((Object)nape));
        }
    }

    private void cleanUpAssociationData(MxNode node, String strAssociationType) {
        m_logger.enter("OverlordSwitchHandler.cleanUpAssociationData(" + node + "," + strAssociationType + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), strAssociationType);
    }

    private MxNode getAssociatedNode(MxNode deviceNode, String asscType) {
        m_logger.enter("overlordswitchHandler:getAssociatedNode");
        m_logger.fine("device Key:" + deviceNode.getDeviceKey() + " ; association type:" + asscType);
        int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(deviceNode.getDeviceKey(), asscType);
        m_logger.fine("associated DeviceKey: " + associatedDeviceKey);
        MxNode associatedDevice = null;
        try {
            associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
        }
        catch (MxUndefinedNodeException ex) {
            m_logger.exception("associated Node not found" + (Object)((Object)ex));
        }
        return associatedDevice;
    }
}

