/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class PClassServerHandler
extends SnmpRackMibHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PClassServerHandler.class);
    private String associationType;

    public PClassServerHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        LOGGER.enter("PClassServerHandler.getAssociationData for " + d.getNameString() + "|" + d.getDeviceType());
        if (!d.getDeviceType().equals("Server")) {
            LOGGER.fine("device not Server, cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(d);
        if (!isSNMPSupported) {
            LOGGER.fine("PClassServerHandler.getAssociationData for (" + d + ")" + "SNMP Not Supported");
            return;
        }
        int ribLoc = 0;
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        LOGGER.fine("got rib location " + ribLoc + " for device " + d.getNameString());
        int doesThisHaveEnclosureMgmt = 0;
        if (ribLoc == 1) {
            this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.2[0],1.3.6.1.4.1.232.2.2.13.1.1.6[1]");
            String oidHasEnclMgt = null;
            String oidSerialNumber = null;
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.exception("InterruptedException while waiting for association write lock");
                }
            }
            while (true) {
                this.snmpPdh.snmpReq.SnmpGetNext();
                SnmpResponse currResp = this.snmpPdh.snmpReq.getResponseVarbinds();
                SnmpResponseVarBind vbHasEnclMgt = currResp.findById(0);
                if (vbHasEnclMgt == null || vbHasEnclMgt.isError()) break;
                oidHasEnclMgt = vbHasEnclMgt.getOid();
                SnmpResponseVarBind vbSerialNumber = currResp.findById(1);
                if (vbSerialNumber == null || vbSerialNumber.isError()) break;
                oidSerialNumber = vbSerialNumber.getOid();
                if (!oidHasEnclMgt.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.2.")) break;
                doesThisHaveEnclosureMgmt = vbHasEnclMgt.getIntValue();
                LOGGER.fine("doesThisHaveEnclosureMgmt is " + doesThisHaveEnclosureMgmt);
                if (doesThisHaveEnclosureMgmt == 2) {
                    this.getRackAttributesFromTheMib();
                    this.getCommonEnclosureAttributesAndTopologyFromTheMib();
                    this.getServerEnclosureAttributesFromTheMib();
                    this.getServerBladeAttributesFromTheMib(false, null);
                    this.getSwitchAttributesFromTheMib();
                    this.doRackEnclosureDeviceProcessing(d);
                    AssociationHandlerUtil.setILOAttributesOnServer(d);
                    break;
                }
                this.snmpPdh.snmpReq.clearSnmpReqInfo();
                this.snmpPdh.snmpReq.addSnmpGetVarbind(oidHasEnclMgt, "0");
                this.snmpPdh.snmpReq.addSnmpGetVarbind(oidSerialNumber, "1");
            }
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("PClassServerHandler.getAssociationData for " + d.getNameString() + "|" + d.getDeviceType());
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        LOGGER.enter("PClassServerHandler.loadAssociationDataFromDb for " + device.getNameString() + "|" + device.getDeviceKey());
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(device.getDeviceKey(), true);
        if (device != null && device.getDeviceType().equals("Server")) {
            na = AssociationHandlerUtil.loadAssocFrmDB(device.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("PClassServerHandler.loadAssociationDataFromDb for " + device.getNameString() + "|" + device.getDeviceKey());
        return na;
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        LOGGER.enter("PClassserverHandler:doRackEnclosureDeviceProcessing " + d.getNameString());
        Vector enclosureInfo = null;
        if (this.getServerEnclosureIndex() > -1 && this.getTopology().size() > this.getServerEnclosureIndex()) {
            enclosureInfo = (Vector)this.getTopology().elementAt(this.getServerEnclosureIndex());
        }
        if (enclosureInfo != null && (String)enclosureInfo.elementAt(8) != null && ((String)enclosureInfo.elementAt(8)).length() > 0) {
            for (int i = 0; i < enclosureInfo.size(); ++i) {
                LOGGER.finer("enclosureInfo : " + enclosureInfo.get(i).toString());
            }
            LOGGER.fine("setting enclosure name for p-class server " + d.getNameString() + " : " + enclosureInfo.get(1));
            LOGGER.fine("In rackEnclosure Device Processing getBladeSlot():" + this.getBladeSlot());
            this.myNodeRelationships.setSlotNumber(this.getBladeSlot());
            this.myNodeRelationships.setMmHeight(this.getBladeHeight());
            this.myNodeRelationships.setMmWidth(this.getBladeWidth());
            this.myNodeRelationships.setMmDepth(this.getBladeDepth());
            this.myNodeRelationships.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
            this.myNodeRelationships.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
            this.myNodeRelationships.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
            this.myNodeRelationships.setSource(this.associationType);
            this.myNodeRelationships.setSwitchApis(this.getSwitchesPresent());
            LOGGER.finer("myNodeRelationships.getSlotNumber():" + this.myNodeRelationships.getSlotNumber());
            LOGGER.finer("myNodeRelationships.getNumBladeSlotsUsedXDir():" + this.myNodeRelationships.getNumBladeSlotsUsedXDir());
            LOGGER.finer("myNodeRelationships.getNumBladeSlotsUsedYDir():" + this.myNodeRelationships.getNumBladeSlotsUsedYDir());
            LOGGER.finer("ServerADH : Finished storing blade attributes");
            NodeAssociations theEnclNodeAssociations = null;
            if (this.getServerEnclosureIndex() != -1) {
                LOGGER.finer("ServerADH : Before storing enclosure information");
                theEnclNodeAssociations = this.getEnclosureInformation((Vector)this.getTopology().elementAt(this.getServerEnclosureIndex()), this.getRackName(), this.getRuid());
                LOGGER.fine("setting rack name for p-class server " + d.getNameString() + " : " + this.getRackName());
                LOGGER.finer("ServerADH : after storing enclosure and rack information");
                if (theEnclNodeAssociations != null) {
                    int deviceKey = this.device.getDeviceKey();
                    int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                    try {
                        d.setEnclosureName(MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey).getNameString());
                    }
                    catch (MxUndefinedNodeException e) {
                        LOGGER.fine("Exception while updating enclosure name on server" + (Object)((Object)e));
                        e.printStackTrace();
                    }
                    LOGGER.fine("The encl device is " + theEnclDeviceKey);
                    LOGGER.fine("Slot number for myNodeRelationships in storeenclosureinformation is " + this.myNodeRelationships.getSlotNumber());
                    if (this.myNodeRelationships.getSlotNumber() != -1) {
                        this.removeOldAssociationsFromThisSlot(deviceKey, theEnclDeviceKey);
                        if (this.device.getDeviceType().equals("Server")) {
                            this.myNodeRelationships.setTheAssociation(deviceKey, theEnclDeviceKey, "ServerToEnclosure", false);
                        }
                        this.addDeviceToTopologyTree(theEnclNodeAssociations, deviceKey);
                        this.myNodeRelationships.setInContainer(true);
                        this.myNodeRelationships.setParent(theEnclDeviceKey);
                    }
                    theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
                    theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
                    theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
                    theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
                    theEnclNodeAssociations.setSource("Enclosure");
                    LOGGER.fine("getMaxNumBladesXDir():" + this.getMaxNumBladesXDir());
                    LOGGER.fine("getMaxNumBladesYDir():" + this.getMaxNumBladesYDir());
                    this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                }
            }
            if (this.getRuid() != null) {
                this.storeTopologyInformation(this.getTopology(), this.getRuid());
            }
        } else {
            MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
            if (dTmp != null) {
                LOGGER.fine("MIB shows server " + new Integer(d.getDeviceKey()) + " was not in enclosure - removing it from topology");
                NodeAssociations dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey());
                if (dTmpNodeAssociations != null) {
                    DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
                    topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                    dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
                    this.myNodeRelationshipManager.update(dTmpNodeAssociations);
                }
            }
        }
        LOGGER.exit("PClassserverHandler:doRackEnclosureDeviceProcessing " + d.getNameString());
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        LOGGER.enter("PClassServerHandler.buildContainerTree " + myAssoc + "/" + node1.getNameString() + "/" + node2.getNameString());
        LOGGER.fine("node1.name:" + node1.getNameString());
        LOGGER.fine("node1.getDeviceType:" + node1.getDeviceType());
        LOGGER.fine("node2.name:" + node2.getNameString());
        LOGGER.fine("node2.getDeviceType:" + node2.getDeviceType());
        if (node1.getDeviceType().equals("Server") && node2.getDeviceType().equals("Enclosure")) {
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
            myAssoc.setInContainer(true);
            myAssoc.setParent(node2.getDeviceKey());
        }
        LOGGER.exit("PClassServerHandler.buildContainerTree " + myAssoc + "/" + node1.getNameString() + "/" + node2.getNameString());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        LOGGER.enter("PClassServerHandler.cleanUpAssociationData for " + d.getNameString());
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rib");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rcc");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nape) {
            LOGGER.exception((Throwable)nape);
        }
        LOGGER.exit("PClassServerHandler.cleanUpAssociationData for " + d.getNameString());
    }
}

