/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class PbleClassAssociationDataHandler
extends SnmpRackMibHandler {
    private static Integer syncenclIa = new Integer(0);
    private MxNode m_EnclosureNode = null;
    private String m_swicthSerialNum = null;
    private static final DebugSubsystem m_logger = new DebugSubsystem(PbleClassAssociationDataHandler.class);

    public PbleClassAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode iaNode, DeviceIdentificationData idInfo) {
        m_logger.enter("PbleClassAssocaitionDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
        m_logger.fine("IN The PblEclassASSOCIATIONDATAHANDLER.... - Getting the new associations");
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(iaNode);
        if (!isSNMPSupported) {
            m_logger.fine("End:PbleClassAssociationDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
            return;
        }
        m_logger.fine("AssociationHandlerSnmpConstants.ENCLOSURE_SERIAL_NUM_OID_FROM_IA:1.3.6.1.4.1.232.2.2.2.1.0[1]");
        try {
            this.getCommonEnclosureAttributesAndTopologyFromTheMib();
            this.getServerEnclosureAttributesFromTheMib();
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            this.doRackEnclosureDeviceProcessing(iaNode);
            this.doSwitchEnclAssociation(iaNode);
            this.setPowerSupplyDetailsOnEnclNode();
            String theEnclSysSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.2.2.2.1.0[1]", true);
            m_logger.fine("PBLECLASSASSOCIATIONDATAHANDLER....After getting enclosure serial no. " + theEnclSysSerialNo + " for device " + iaNode.getNameString());
            if (theEnclSysSerialNo != null && theEnclSysSerialNo.trim().length() > 0) {
                this.setAssociationsForTheListOfAssociatedDevices(iaNode, theEnclSysSerialNo);
            }
        }
        catch (Exception e) {
            m_logger.exit("exception PbleClassAssocaitionDataHandler.getAssociationData:" + e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            NodeAssociationsManager.releaseWriteLock();
        }
        m_logger.exit("end :PbleClassAssocaitionDataHandler.getAssociationData(" + iaNode + "," + idInfo + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        m_logger.enter("PbleClassAssociatioDataHandler:loadAssociationDataFromDb for device:" + device.getWorkingAddress());
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            m_logger.fine("In Loading Device Associations for " + device.getWorkingAddress() + "dKey:" + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                String mgmtEnclAssocType = "MgmtProcToEnclosure";
                if (device == null || !device.getDeviceType().equals("MgmtProc")) continue;
                if (associationTypeNumber.equalsIgnoreCase(mgmtEnclAssocType)) {
                    if (deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    continue;
                }
                if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ia") && !associationTypeNumber.equalsIgnoreCase("MgmtProcToDesktop_Ia") || deviceKey2 != deviceDbKey) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
            }
            myResultSet.close();
            myStatement.close();
            myResultSet = null;
            myStatement = null;
            m_logger.fine("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
        }
        catch (SQLException myException) {
            try {
                m_logger.exception("Failed to get the vector of devices that have associations " + myException);
            }
            catch (Throwable throwable) {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                throw throwable;
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        m_logger.exit("end: PbleClassAssociatioDataHandler:loadAssociationDataFromDb for device:" + device.getWorkingAddress());
        return na;
    }

    private void setAssociationsForTheListOfAssociatedDevices(MxNode device, String theSerialNumber) {
        m_logger.enter("PblaClassAssociationDataHandler:setAssociationsForTheListOfAssociatedDevices for :" + device.getWorkingAddress() + "theSerialNumber:" + theSerialNumber);
        MxNode associatedDevice = null;
        MxNode theEnclosure = null;
        try {
            theEnclosure = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(theSerialNumber);
        }
        catch (MxUndefinedNodeException ex) {
            m_logger.exception("setAssociationsForTheListOfAssociatedDevices:Enclosure node not found:" + (Object)((Object)ex));
            return;
        }
        List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), theSerialNumber);
        Iterator iter = allDevicesWithThisProperty.iterator();
        m_logger.fine("Size of the associated devices iteration : " + allDevicesWithThisProperty.size());
        while (iter.hasNext()) {
            Integer associatedDeviceKey = (Integer)iter.next();
            m_logger.fine(" Adding association for device keys : " + associatedDeviceKey + " and " + device.getDeviceKey());
            try {
                associatedDevice = MxNodeController.getDefaultController().getNodeByKey(associatedDeviceKey.intValue());
                this.makeServerToIaAssociation(associatedDevice, device.getDeviceKey());
                this.getServerBladeAttributesFromTheMib(true, associatedDevice.getSerialNumber());
                this.makeServerToEnclAssociation(associatedDevice, theEnclosure);
                associatedDevice.setEnclosureName(theEnclosure.getNameString());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), associatedDevice, false);
            }
            catch (MxException ex1) {
                m_logger.exception("setAssociationsForTheListOfAssociatedDevices:server/desktop node not found:" + (Object)((Object)ex1));
            }
        }
        PbleClassAssociationDataHandler.addSubTypeOnEnclNode(theEnclosure);
        m_logger.exit("end: PblaClassAssociationDataHandler:setAssociationsForTheListOfAssociatedDevices for :" + device.getWorkingAddress() + "theSerialNumber:" + theSerialNumber);
    }

    private void makeServerToIaAssociation(MxNode serverNode, int iADeviceKey) {
        m_logger.enter("PbleClassAssociationDataHandler:makeServerToIaAssociation " + serverNode.getDeviceKey() + ":" + iADeviceKey);
        NodeAssociations theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverNode.getDeviceKey());
        if (serverNode.getDeviceType().equals("Server")) {
            this.myNodeRelationships.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToServer_Ia", false);
            theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToServer_Ia", false);
        } else if (serverNode.getDeviceType().equals("Desktop")) {
            this.myNodeRelationships.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToDesktop_Ia", false);
            theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), iADeviceKey, "MgmtProcToDesktop_Ia", false);
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        m_logger.exit("end: PbleClassAssociationDataHandler:makeServerToIaAssociation " + serverNode.getDeviceKey() + ":" + iADeviceKey);
    }

    private void makeServerToEnclAssociation(MxNode serverNode, MxNode theEnclosure) {
        m_logger.enter("PbleClassAssociationDataHandler:makeServerToEnclAssociation:" + serverNode.getDeviceKey() + ":" + theEnclosure.getDeviceKey());
        NodeAssociations theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverNode.getDeviceKey());
        if (theAssociatedDeviceNodeAssociations == null) {
            theAssociatedDeviceNodeAssociations = new NodeAssociations(serverNode.getDeviceKey());
        }
        theAssociatedDeviceNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
        theAssociatedDeviceNodeAssociations.setSlotNumber(this.getBladeSlot());
        theAssociatedDeviceNodeAssociations.setMmHeight(this.getBladeHeight());
        theAssociatedDeviceNodeAssociations.setMmWidth(this.getBladeWidth());
        theAssociatedDeviceNodeAssociations.setMmDepth(this.getBladeDepth());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
        theAssociatedDeviceNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
        theAssociatedDeviceNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
        theAssociatedDeviceNodeAssociations.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
        theAssociatedDeviceNodeAssociations.setInContainer(true);
        theAssociatedDeviceNodeAssociations.setParent(theEnclosure.getDeviceKey());
        if (theEnclosure != null && theEnclosure.getDeviceType().equals("Enclosure")) {
            NodeAssociations theEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
            if (theAssociatedDeviceNodeAssociations.getSlotNumber() != -1) {
                if (serverNode.getDeviceType().equals("Server")) {
                    theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), theEnclosure.getDeviceKey(), "ServerToEnclosure", false);
                    theAssociatedDeviceNodeAssociations.setSource("ServerToEnclosure");
                } else if (serverNode.getDeviceType().equals("Desktop")) {
                    theAssociatedDeviceNodeAssociations.setTheAssociation(serverNode.getDeviceKey(), theEnclosure.getDeviceKey(), "DesktopToEnclosure", false);
                    theAssociatedDeviceNodeAssociations.setSource("DesktopToEnclosure");
                }
                m_logger.fine(" Just before adding the device " + serverNode.getDeviceKey() + " to the topology tree of " + theEnclosure.toString());
                this.addDeviceToTopologyTree(theEnclosureNodeAssociations, serverNode.getDeviceKey());
                m_logger.fine("Finished adding the device to the topology tree");
                theAssociatedDeviceNodeAssociations.setInContainer(true);
                theAssociatedDeviceNodeAssociations.setParent(theEnclosure.getDeviceKey());
                this.myNodeRelationshipManager.update(theEnclosureNodeAssociations);
            }
        }
        this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
        m_logger.exit("end: PbleClassAssociationDataHandler:makeServerToEnclAssociation:" + serverNode.getDeviceKey() + ":" + theEnclosure.getDeviceKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubTypeOnEnclNode(MxNode theEnclosure) {
        m_logger.enter("PbleClassAssociationDataHandler:addSubTypeOnEnclNode for enclosure node" + theEnclosure.getDeviceKey());
        if (theEnclosure != null) {
            List nodeSubTypeList = theEnclosure.getDeviceSubTypes();
            boolean bModify = false;
            if (!nodeSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                bModify = true;
            }
            Integer n = syncenclIa;
            synchronized (n) {
                if (bModify) {
                    theEnclosure.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                    theEnclosure.setModel("Server Enclosure");
                    try {
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclosure, false);
                    }
                    catch (Exception e1) {
                        m_logger.exception("addSubTypeOnEnclNode:error while updating on enclosure node:" + e1);
                    }
                }
            }
        }
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        m_logger.enter("PbleClassAssociationDataHandler:rackEnclosure Device Processing:" + d.getDeviceKey());
        m_logger.fine("PbleClass : Before storing enclosure information");
        NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(this.getContainerEnclosureInformation(), null, null);
        if (theEnclNodeAssociations != null) {
            int myDeviceKey = d.getDeviceKey();
            int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
            m_logger.fine("IA DEVICE KEY:" + myDeviceKey);
            m_logger.fine("enclosure devicekey:" + theEnclDeviceKey);
            try {
                this.m_EnclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            }
            catch (MxUndefinedNodeException e) {
                m_logger.exception("doRackEnclosureDeviceProcessing:exception:" + (Object)((Object)e));
            }
            m_logger.fine("The encl device is " + theEnclDeviceKey);
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(theEnclDeviceKey, "MgmtProcToEnclosure");
            this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "MgmtProcToEnclosure", false);
            this.myNodeRelationships.setInContainer(true);
            this.myNodeRelationships.setParent(theEnclDeviceKey);
            theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
            theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
            theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
            theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
            theEnclNodeAssociations.setSource("Enclosure");
            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            try {
                String enclName = this.m_EnclosureNode.getNameString();
                d.setEnclosureName(enclName);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
            }
            catch (Exception e) {
                m_logger.exception("doRackEnclosureDeviceProcessing:error while updating enclosure name on server:" + e);
            }
        }
        m_logger.exit("end:PbleClassAssociationDataHandler:rackEnclosure Device Processing:" + d.getDeviceKey());
    }

    private void doSwitchEnclAssociation(MxNode d) {
        m_logger.enter("PbleClassAssociationDataHandler:doSwitchEnclAssociation for IA :" + d.getWorkingAddress());
        this.getSwitchSerialNumberFromMib(d);
        m_logger.fine("switch serial Number from IA:" + d.getWorkingAddress() + "is" + this.m_swicthSerialNum);
        NodeAssociations theAssociatedDeviceNodeAssociations = null;
        MxNode theSwitchDev = null;
        if (this.m_swicthSerialNum != null && this.m_swicthSerialNum.trim().length() > 0) {
            try {
                theSwitchDev = AssociationHandlerUtil.getNodeBySerialNumber(this.m_swicthSerialNum.trim());
            }
            catch (Exception e) {
                m_logger.exception("PbleClassAssociationDataHandler:doSwicthEnclAssociation switch node not found" + e);
            }
            if (theSwitchDev != null && this.m_EnclosureNode != null) {
                NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(this.m_EnclosureNode.getDeviceKey());
                theAssociatedDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theSwitchDev.getDeviceKey());
                m_logger.fine("asscotiate :" + theSwitchDev.getDeviceKey() + "and" + this.m_EnclosureNode.getDeviceKey());
                theAssociatedDeviceNodeAssociations.setTheAssociation(theSwitchDev.getDeviceKey(), this.m_EnclosureNode.getDeviceKey(), "SwitchToEnclosure", false);
                theAssociatedDeviceNodeAssociations.setSource("SwitchToEnclosure");
                theAssociatedDeviceNodeAssociations.setInContainer(true);
                theAssociatedDeviceNodeAssociations.setParent(this.m_EnclosureNode.getDeviceKey());
                this.addDeviceToTopologyTree(theEnclNodeAssociations, theSwitchDev.getDeviceKey());
                theEnclNodeAssociations.setSource("Enclosure");
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(theAssociatedDeviceNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
            }
            m_logger.fine("PbleClassAssociationDataHandler:doSwitchEnclAssociation :set Switch As client Attribute with Switch_SerNum:" + this.m_swicthSerialNum);
            this.m_EnclosureNode.setClientAttribute("Switch_SerNum", this.m_swicthSerialNum);
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.m_EnclosureNode, false);
            }
            catch (Exception e) {
                m_logger.exception("doSwitchEnclAssociation:error while updating on enclosure node:" + e);
            }
        }
        m_logger.exit("end:PbleClassAssociationDataHandler:doSwitchEnclAssociation for IA :" + d.getWorkingAddress());
    }

    private void getSwitchSerialNumberFromMib(MxNode d) {
        String serialNumberFromMib;
        block1: {
            m_logger.enter("PbleClassAssociationDataHandler:getSwitchSerialNumberFromMib from IA:" + d.getNameString());
            String swserialNumberOID = null;
            serialNumberFromMib = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.7[0]");
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findById(0);
                if (vb == null || vb.isError()) break block1;
                swserialNumberOID = vb.getOid();
                if (!swserialNumberOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.7.")) break;
                m_logger.fine("The Switch serial Number OID : " + swserialNumberOID);
                serialNumberFromMib = vb.getValue();
                m_logger.fine(" switch serial Number :" + serialNumberFromMib);
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(swserialNumberOID, "0");
            }
            m_logger.fine("switch serial number oid was not correct" + swserialNumberOID);
        }
        this.m_swicthSerialNum = serialNumberFromMib;
        m_logger.exit("end:PbleClassAssociationDataHandler:getSwitchSerialNumberFromMib from IA:" + d.getNameString());
    }

    private void setPowerSupplyDetailsOnEnclNode() {
        boolean rightPowerSupPresent;
        boolean leftPowerSupPresent;
        block6: {
            m_logger.enter("PbleClassAssociationDataHandler:setPowerSupplyDetailsOnEnclNode");
            String leftPowerSupplyIndex = "00000001";
            String rightPowerSupplyInder = "00000002";
            leftPowerSupPresent = false;
            rightPowerSupPresent = false;
            String powerSupplyIndexOID = null;
            String powerSupplySerialNumOID = null;
            String powerSupplyIndex = null;
            String powerSupplySerialNum = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.5.1.1.1.3[0],1.3.6.1.4.1.232.22.2.5.1.1.1.5[1]");
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind powerSupIndexVB = curResp.findById(0);
                if (powerSupIndexVB == null || powerSupIndexVB.isError()) break block6;
                powerSupplyIndexOID = powerSupIndexVB.getOid();
                m_logger.fine("powerSupplyIndexOID" + powerSupplyIndexOID);
                SnmpResponseVarBind powerSupSerialNumVB = curResp.findById(1);
                if (powerSupSerialNumVB == null || powerSupSerialNumVB.isError()) break block6;
                powerSupplySerialNumOID = powerSupSerialNumVB.getOid();
                m_logger.fine("powerSupplySerialNumOID:" + powerSupplySerialNumOID);
                if (!powerSupplyIndexOID.startsWith("1.3.6.1.4.1.232.22.2.5.1.1.1.3.")) break;
                powerSupplyIndex = powerSupIndexVB.getValue();
                powerSupplySerialNum = powerSupSerialNumVB.getValue();
                m_logger.fine("powerSupplyIndex:" + powerSupplyIndex);
                m_logger.fine("powerSupplySerialNum:" + powerSupplySerialNum);
                if (powerSupplyIndex.equals(leftPowerSupplyIndex) && powerSupplySerialNum != null && powerSupplySerialNum.trim().length() > 0) {
                    leftPowerSupPresent = true;
                    m_logger.fine("leftPowerSupPresent:" + leftPowerSupPresent);
                } else if (powerSupplyIndex.equals(rightPowerSupplyInder) && powerSupplySerialNum != null && powerSupplySerialNum.trim().length() > 0) {
                    rightPowerSupPresent = true;
                    m_logger.fine("rightPowerSupPresent:" + rightPowerSupPresent);
                }
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyIndexOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplySerialNumOID, "1");
            }
            m_logger.fine("PowerSupply index OID was not correct" + powerSupplyIndexOID);
        }
        m_logger.fine("power supply attributes on encl node as");
        m_logger.fine("leftPowerSupply" + String.valueOf(leftPowerSupPresent));
        m_logger.fine("rightPowerSupply:" + String.valueOf(rightPowerSupPresent));
        this.m_EnclosureNode.setClientAttribute("leftPowerSupply", String.valueOf(leftPowerSupPresent));
        this.m_EnclosureNode.setClientAttribute("rightPowerSupply", String.valueOf(rightPowerSupPresent));
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), this.m_EnclosureNode, false);
        }
        catch (Exception e) {
            m_logger.exception("setPowerSupplyDetailsOnEnclNode:error while updating on enclosure node:" + e);
        }
        m_logger.exit("end:PbleClassAssociationDataHandler:setPowerSupplyDetailsOnEnclNode");
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToDesktop_Ia");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToEnclosure");
        this.myNodeRelationshipManager.resetDeviceAssociations(d.getDeviceKey());
    }
}

