/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.MxDuplicateNodeException;
import com.hp.mx.core.nodemanager.MxInvalidIPAddressException;
import com.hp.mx.core.nodemanager.MxInvalidNodeNameException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.querymanager.criteria.DeviceByRackDataObject;
import com.hp.mx.core.querymanager.criteria.RackEnclosureObject;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.BaseNodeRelationshipHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class RackEnclosureTopologyHandler
extends BaseNodeRelationshipHandler {
    private MxNode theRackDevice;
    private static final int BOGUS_DEVKEY = -1;
    private static final int NEITHER_NEIGHBOR_EMPTY = 1;
    private static final int BOTTOM_NEIGHBOR_EMPTY = 2;
    private static final int TOP_NEIGHBOR_EMPTY = 3;
    protected HashMap<String, String> prodIdList = new HashMap();
    private boolean hasTopologyChanged = false;
    private String useThisIdForNamingEnclosures = "";
    private static Integer syncEnclAdds = new Integer(0);
    private static Integer syncRackMoves = new Integer(1);
    private static final DebugSubsystem LOGGER = new DebugSubsystem(RackEnclosureTopologyHandler.class);
    public static DebugSubsystem rackTopologyDebug = new DebugSubsystem(RackEnclosureTopologyHandler.class);

    public void getAssociationData(MxNode device, DeviceIdentificationData idInfo) {
    }

    public void cleanUpAssociationData(MxNode device) {
    }

    public void setAssociationType(String associationType) {
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode theDevice) {
        NodeAssociations tempNodeAssociations;
        block14: {
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            int deviceDbKey = theDevice.getDeviceKey();
            tempNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (!associationTypeNumber.equalsIgnoreCase("EnclosureToRack")) continue;
                    MxNode dev1 = null;
                    if (deviceKey1 == deviceDbKey) {
                        dev1 = theDevice;
                    } else {
                        try {
                            dev1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey1);
                        }
                        catch (MxUndefinedNodeException ex) {
                            dev1 = null;
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("load assn for " + deviceDbKey + " k1 " + deviceKey1 + " k2 " + deviceKey2 + " dev1 " + dev1));
                    if (dev1 == null || !dev1.getDeviceType().equals("Enclosure")) continue;
                    if (deviceKey1 == deviceDbKey) {
                        tempNodeAssociations.setInContainer(true);
                        tempNodeAssociations.initializeTopologyTree();
                        tempNodeAssociations.setParent(deviceKey2);
                        tempNodeAssociations.setTheAssociation(deviceKey1, deviceKey2, "EnclosureToRack", false);
                        continue;
                    }
                    if (deviceKey2 != deviceDbKey) continue;
                    tempNodeAssociations.initializeTopologyTree();
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + tempNodeAssociations.inContainer() + " parent " + tempNodeAssociations.getParent()));
                }
                tempNodeAssociations = this.loadContainerTree(deviceDbKey, tempNodeAssociations);
                tempNodeAssociations = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, tempNodeAssociations);
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
            catch (SQLException myException) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                this.myNodeRelationshipManager.update(tempNodeAssociations);
                break block14;
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                this.myNodeRelationshipManager.update(tempNodeAssociations);
            }
            this.myNodeRelationshipManager.update(tempNodeAssociations);
        }
        return tempNodeAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadContainerTree(int theDeviceKey, NodeAssociations na) {
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block38: {
            DeviceAssociationObject dao;
            Vector containedDevices;
            LOGGER.fine("RackEnclosureTopologyHandler.loadContainerTree(theDeviceKey " + theDeviceKey + ",na " + na.getDeviceKey());
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            LOGGER.fine("In Loading Container Tree for " + theDeviceKey);
            MxNode theDevice = null;
            String deviceName = null;
            try {
                theDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theDeviceKey);
                deviceName = theDevice.getDeviceNameStandard();
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (theDevice == null) {
                LOGGER.error("Device association error, could not load on delete!! " + theDeviceKey);
                return na;
            }
            try {
                this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            }
            catch (NodeAssociationsPersistenceException e) {
                return null;
            }
            if (theDevice.getDeviceType().equals("Enclosure")) {
                LOGGER.fine("Loading container Tree for ENCLOSURE : " + deviceName);
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from rackTopology where Encl_DeviceKey=" + theDeviceKey);
                if (myResultSet.next()) {
                    Integer bottomDeviceKey = new Integer(myResultSet.getInt("Right_Neighbor_DeviceKey"));
                    if (bottomDeviceKey != -1) {
                        na.setBottomNeighborDeviceKey(bottomDeviceKey.intValue());
                        LOGGER.fine("Setting the enclosure's bottom neighbor to " + bottomDeviceKey);
                    } else {
                        na.setBottomMostItem(true);
                        LOGGER.fine("Bottom Neighboring Enclosure for Enclosure " + deviceName + " in the RACK  : is null");
                    }
                    Integer topDeviceKey = new Integer(myResultSet.getInt("Left_Neighbor_DeviceKey"));
                    if (topDeviceKey != -1) {
                        na.setTopNeighborDeviceKey(topDeviceKey.intValue());
                        LOGGER.fine("Setting the enclosure's top neighbor to " + topDeviceKey);
                    } else {
                        na.setTopMostItem(true);
                        LOGGER.fine("Top Enclosure for Enclosure " + deviceName + " in the RACK  : is null");
                    }
                }
                containedDevices = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(theDeviceKey, true);
                LOGGER.fine("Vector contained Devices : " + containedDevices.size());
                for (int i = 0; i < containedDevices.size(); ++i) {
                    dao = (DeviceAssociationObject)containedDevices.elementAt(i);
                    LOGGER.fine("Adding device key is " + dao.getDeviceKey());
                    MxNode deviceMxNode = null;
                    try {
                        deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
                    }
                    catch (MxUndefinedNodeException ex1) {
                        LOGGER.fine("Unable to find the device node with devKey" + dao.getDeviceKey() + "parsing the next device in the list.");
                    }
                    if (deviceMxNode == null) continue;
                    LOGGER.fine("The device Name adding to the tree:" + deviceMxNode.getNameString());
                    int mpDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(deviceMxNode.getDeviceKey(), "MgmtProcToServer_Ilo");
                    try {
                        MxNode mpMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(mpDeviceKey);
                        LOGGER.fine("MP Node name:" + mpMxNode.getNameString());
                        String modelName = mpMxNode.getModel().toLowerCase();
                        String iaModelName = "integrated administrator";
                        if (mpMxNode.getDeviceType().equalsIgnoreCase("MgmtProc") && modelName.indexOf("integrated administrator") == -1) {
                            NodeAssociations serverNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceMxNode.getDeviceKey());
                            serverNodeAssociations.setTheAssociation(mpDeviceKey, serverNodeAssociations.getDeviceKey(), "MgmtProcToServer_Ilo", true);
                            NodeAssociations mpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(mpMxNode.getDeviceKey());
                            if (mpNodeAssociations == null) {
                                mpNodeAssociations = new NodeAssociations(mpMxNode.getDeviceKey());
                            }
                            mpNodeAssociations.setInContainer(true);
                            mpNodeAssociations.setParent(deviceMxNode.getDeviceKey());
                            this.myNodeRelationshipManager.update(mpNodeAssociations);
                        }
                    }
                    catch (MxUndefinedNodeException e) {
                        LOGGER.fine("Unable to add MP with devKey" + mpDeviceKey + "to the server tree.MP doesn not exists.");
                    }
                    if ((deviceMxNode == null || deviceMxNode.getDeviceType().equals("MgmtProc")) && (!deviceMxNode.getDeviceType().equals("MgmtProc") || !deviceMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()))) continue;
                    this.addDeviceToTopologyTree(na, dao.getDeviceKey());
                    na.setTheAssociation(dao.getDeviceKey(), theDeviceKey, dao.getAssociationType(), false);
                }
            }
            if (!theDevice.getDeviceType().equals("Rack")) break block38;
            LOGGER.fine("Loading container Tree for RACK : " + theDevice);
            containedDevices = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(theDeviceKey, true);
            int topDeviceKey = -1;
            int bottomDeviceKey = -1;
            MxNode bottomDev = null;
            MxNode topDev = null;
            LOGGER.fine("Vector contained Devices : " + containedDevices.size());
            for (int i = 0; i < containedDevices.size(); ++i) {
                dao = (DeviceAssociationObject)containedDevices.elementAt(i);
                Integer theEnclDeviceKey = new Integer(dao.getDeviceKey());
                topDeviceKey = -1;
                bottomDeviceKey = -1;
                topDev = null;
                bottomDev = null;
                LOGGER.fine("Enclosure " + i + " in the RACK  : device Key: " + dao.getDeviceKey());
                try {
                    MxNode theEnclDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey.intValue());
                    NodeAssociations tmpEnclNA = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey.intValue());
                    topDeviceKey = tmpEnclNA.getTopNeighborDeviceKey();
                    bottomDeviceKey = tmpEnclNA.getBottomNeighborDeviceKey();
                    if (topDeviceKey != -1) {
                        topDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(topDeviceKey);
                    }
                    if (bottomDeviceKey != -1) {
                        bottomDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(bottomDeviceKey);
                    }
                    this.addTreeNodeToTopologyTree(na, theEnclDev, topDev, bottomDev);
                    continue;
                }
                catch (MxUndefinedNodeException ex4) {
                    containerDeviceDebug.exception((Throwable)ex4);
                }
            }
        }
        try {
            NodeAssociationsManager.getDefaultManager().releaseConnections(myConnection, myStatement, myResultSet);
        }
        catch (NodeAssociationsPersistenceException e) {
            return null;
        }
        catch (SQLException myException) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
            try {
                NodeAssociationsManager.getDefaultManager().releaseConnections(myConnection, myStatement, myResultSet);
            }
            catch (NodeAssociationsPersistenceException e) {
                return null;
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                try {
                    NodeAssociationsManager.getDefaultManager().releaseConnections(myConnection, myStatement, myResultSet);
                }
                catch (NodeAssociationsPersistenceException e2) {
                    return null;
                }
            }
        }
        return na;
    }

    public RackEnclosureTopologyHandler(MxNode device) {
        super(device);
    }

    public RackEnclosureTopologyHandler() {
    }

    public NodeAssociations getRackInformation(String rackName, String rUid, int theEnclDeviceKey) {
        LOGGER.enter("getRackInformationrackName:" + rackName + "rUid:" + rUid);
        LOGGER.exit("getRackInformationrackName:" + rackName + "rUid:" + rUid);
        return null;
    }

    public void storeTopologyInformation(Vector topology, String theRackUUID) {
        MxNode theRackDevice = null;
        try {
            int i;
            String enclUUID = null;
            String enclName = null;
            String enclSerialNumber = null;
            String leftNeighborName = null;
            String leftNeighborUUID = null;
            String leftNeighborSerNo = null;
            String rghtNeighborName = null;
            String rghtNeighborUUID = null;
            String rghtNeighborSerNo = null;
            String hasServerBlades = null;
            String hasPowerBlades = null;
            Vector topologyElement = null;
            NodeAssociations theEnclNodeAssociations = null;
            Object theTopEnclNodeAssociations = null;
            Object thebottomEnclNodeAssociations = null;
            MxNode theEnclosure = null;
            MxNode itsTopNeighbor = null;
            MxNode itsBottomNeighbor = null;
            int topMostEnclKey = -1;
            ArrayList<MxNode[]> lstEncls = new ArrayList<MxNode[]>();
            for (int i2 = 0; i2 < topology.size(); ++i2) {
                topologyElement = (Vector)topology.elementAt(i2);
                enclUUID = ((String)topologyElement.elementAt(0)).trim();
                enclName = ((String)topologyElement.elementAt(1)).trim();
                if (enclName != null) {
                    enclName = this.validateName(enclName);
                }
                leftNeighborName = (String)topologyElement.elementAt(2);
                rghtNeighborName = (String)topologyElement.elementAt(3);
                hasServerBlades = (String)topologyElement.elementAt(4);
                hasPowerBlades = (String)topologyElement.elementAt(5);
                leftNeighborUUID = ((String)topologyElement.elementAt(6)).trim();
                rghtNeighborUUID = ((String)topologyElement.elementAt(7)).trim();
                enclSerialNumber = ((String)topologyElement.elementAt(8)).trim();
                leftNeighborSerNo = ((String)topologyElement.elementAt(9)).trim();
                rghtNeighborSerNo = ((String)topologyElement.elementAt(10)).trim();
                LOGGER.fine("Enclosure UUID. [" + i2 + "] is " + enclUUID);
                LOGGER.fine("Enclosure Name [" + i2 + "] is " + enclName);
                LOGGER.fine("Top Neighbor Name [" + i2 + "] is " + leftNeighborName);
                LOGGER.fine("Bottom Neighbor Name [" + i2 + "] is " + rghtNeighborName);
                LOGGER.fine("Has Server Blades [" + i2 + "] is " + hasServerBlades);
                LOGGER.fine("Has Power Blades [" + i2 + "] is " + hasPowerBlades);
                LOGGER.fine("Top Neighbor serial No. : [" + i2 + "] is " + leftNeighborUUID);
                LOGGER.fine("Bottom neighbor serial no. [" + i2 + "] is " + rghtNeighborUUID);
                theEnclosure = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, theRackDevice);
                itsTopNeighbor = this.getEnclosureDevice(leftNeighborUUID, leftNeighborSerNo, leftNeighborName, null, null, theRackDevice);
                itsBottomNeighbor = this.getEnclosureDevice(rghtNeighborUUID, rghtNeighborSerNo, rghtNeighborName, null, null, theRackDevice);
                lstEncls.add(new MxNode[]{itsTopNeighbor, theEnclosure, itsBottomNeighbor});
                if (theEnclosure != null) {
                    theEnclosure.setClientAttribute("dCRackUUID", theRackUUID);
                    theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
                    try {
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclosure, false);
                    }
                    catch (Exception e) {
                        LOGGER.exception((Throwable)e);
                    }
                }
                if (itsTopNeighbor != null) {
                    itsTopNeighbor.setClientAttribute("dCRackUUID", theRackUUID);
                    this.addSubTypeOnEncl(itsTopNeighbor, theEnclosure);
                    try {
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), itsTopNeighbor, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (itsBottomNeighbor != null) {
                    itsBottomNeighbor.setClientAttribute("dCRackUUID", theRackUUID);
                    this.addSubTypeOnEncl(itsBottomNeighbor, theEnclosure);
                    try {
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), itsBottomNeighbor, false);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey(), true);
                int rackKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theEnclosure.getDeviceKey(), "EnclosureToRack");
                if (rackKey == 0 && rackKey == -1) continue;
                NodeAssociations rNA = this.myNodeRelationshipManager.getNodeAssociations(rackKey);
                this.addDeviceToTopologyTree(rNA, theEnclosure.getDeviceKey());
            }
            LOGGER.fine("sorting encls using neighbour information..");
            ArrayList<MxNode[]> sorted = new ArrayList<MxNode[]>();
            for (MxNode[] item : lstEncls) {
                if (item[0] != null) continue;
                LOGGER.finer("first encl in DC : " + item[1].getNameString());
                sorted.add(item);
            }
            for (i = 0; i < lstEncls.size(); ++i) {
                for (int j = 0; j < lstEncls.size(); ++j) {
                    MxNode[] item = (MxNode[])lstEncls.get(j);
                    if (item[1] != null && sorted.get(sorted.size() - 1) != null && ((MxNode[])sorted.get(sorted.size() - 1))[2] != null && item[1].getDeviceKey() == ((MxNode[])sorted.get(sorted.size() - 1))[2].getDeviceKey()) {
                        LOGGER.finer("adding : " + item[1].getNameString());
                        sorted.add(item);
                        continue;
                    }
                    if (item[0] != null && item[1] != null && sorted.get(sorted.size() - 1) != null && ((MxNode[])sorted.get(sorted.size() - 1))[1] != null && item[0].getDeviceKey() == ((MxNode[])sorted.get(sorted.size() - 1))[1].getDeviceKey()) {
                        LOGGER.finer("adding : " + item[1].getNameString());
                        sorted.add(item);
                        continue;
                    }
                    if (item[0] == null || sorted.get(sorted.size() - 1) == null || ((MxNode[])sorted.get(sorted.size() - 1))[2] == null || item[0].getDeviceKey() != ((MxNode[])sorted.get(sorted.size() - 1))[2].getDeviceKey()) continue;
                    LOGGER.finer("adding : " + item[0].getNameString());
                    sorted.add(new MxNode[]{null, item[0], null});
                }
            }
            for (i = 0; i < sorted.size(); ++i) {
                if (((MxNode[])sorted.get(i))[1] == null) continue;
                LOGGER.fine("order of encls (sorted) : " + ((MxNode[])sorted.get(i))[1].getNameString() + " is " + Integer.toString(i + 1));
                ((MxNode[])sorted.get(i))[1].setClientAttribute("Order", Integer.toString(i + 1));
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), ((MxNode[])sorted.get(i))[1], false);
            }
        }
        catch (Exception e) {
            LOGGER.exception((Throwable)e);
        }
    }

    public int getNext(int devicekey, List nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
        }
        return -1;
    }

    public void setEnclosureOrder(int thebottomEnclosureDevKey) {
        LOGGER.enter("RacktopogyHandler.setEnclosureOrder");
        int theEnclDeviceKey = 0;
        int i = 1;
        while (thebottomEnclosureDevKey > 0) {
            theEnclDeviceKey = thebottomEnclosureDevKey;
            LOGGER.fine("theEnclDeviceKey:" + theEnclDeviceKey);
            try {
                MxNode enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(theEnclDeviceKey);
                enclosureMxNode.setClientAttribute("Order", "" + i);
                ++i;
                thebottomEnclosureDevKey = this.getneighbourEnclosureFromRackTopology(theEnclDeviceKey, false);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureMxNode, false);
            }
            catch (Exception e) {
                LOGGER.exception("can not find enclosure node");
            }
        }
        LOGGER.exit("RacktopogyHandler.setEnclosureOrder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getneighbourEnclosureFromRackTopology(int theEnclosureDeviceKey, boolean topEncl) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int Neighbor = 0;
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("rackEnclosureTopologyHandler:storeNeighborInfoInDb");
            myStatement = myConnection.createStatement();
            myResultSet = topEncl ? myStatement.executeQuery("select Left_Neighbor_DeviceKey from rackTopology where Encl_DeviceKey=" + theEnclosureDeviceKey) : myStatement.executeQuery("select Right_Neighbor_DeviceKey from rackTopology where Encl_DeviceKey=" + theEnclosureDeviceKey);
            if (myResultSet.next()) {
                Neighbor = myResultSet.getInt(1);
                myResultSet.close();
                myResultSet = null;
                myStatement.close();
                myStatement = null;
            }
        }
        catch (SQLException e) {
        }
        finally {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
            }
            catch (SQLException e1) {
                LOGGER.fine("exception" + e1);
            }
        }
        return Neighbor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations getEnclosureInformation(Vector enclosureInfo, String rackName, String rUid) {
        NodeAssociations theEnclNodeAssociations;
        block28: {
            theEnclNodeAssociations = null;
            MxNode theEnclDevice = null;
            try {
                String tmpStr = null;
                String enclUUID = null;
                String enclName = null;
                String enclSerialNumber = null;
                String hasServerBlades = null;
                String hasPowerBlades = null;
                if (enclosureInfo != null) {
                    tmpStr = (String)enclosureInfo.elementAt(0);
                    if (tmpStr != null) {
                        enclUUID = tmpStr.trim();
                    }
                    if ((tmpStr = (String)enclosureInfo.elementAt(1)) != null) {
                        enclName = tmpStr.trim();
                    }
                    if ((tmpStr = (String)enclosureInfo.elementAt(8)) != null) {
                        enclSerialNumber = tmpStr.trim();
                    }
                    hasServerBlades = (String)enclosureInfo.elementAt(4);
                    hasPowerBlades = (String)enclosureInfo.elementAt(5);
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("Encl Serial num : '" + enclUUID + "'"));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ENclosure Name : '" + enclName + "'"));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("Has Server Blades  : " + hasServerBlades));
                if (enclName != null) {
                    enclName = this.validateName(enclName);
                }
                if (hasServerBlades == null || !hasServerBlades.trim().equalsIgnoreCase("true")) break block28;
                int theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerialNumber, 14);
                try {
                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUUID);
                }
                catch (MxUndefinedNodeException ex1) {
                    // empty catch block
                }
                if (theEnclDevice != null && theEnclDevice.getDeviceType().equals("Enclosure")) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Device is already there in the dB " + theEnclDevice.getNameString()));
                    this.useThisIdForNamingEnclosures = enclUUID;
                    if (theEnclDevice.getNameString() != null && enclName != null && !theEnclDevice.getNameString().equalsIgnoreCase(enclName) && enclName.trim().length() > 0 && !theEnclDevice.getNameString().equalsIgnoreCase(enclName + "_" + this.useThisIdForNamingEnclosures)) {
                        MxNode otherDevice = MxNodeController.getDefaultControllerNoEx().getDeviceByName(enclName);
                        if (otherDevice != null) {
                            theEnclDevice.setDeviceName(enclName + "_" + this.useThisIdForNamingEnclosures);
                        } else {
                            theEnclDevice.setDeviceName(enclName);
                        }
                        theEnclDevice.setEnclosureName(theEnclDevice.getNameString());
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                    }
                } else if (theEnclDeviceKey != 0) {
                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Device is already there in the dB " + theEnclDevice.getNameString()));
                    if (theEnclDevice.getNameString() != null && enclName != null && !theEnclDevice.getNameString().equalsIgnoreCase(enclName) && enclName.trim().length() > 0 && !theEnclDevice.getNameString().equalsIgnoreCase(enclName + "_" + enclSerialNumber)) {
                        MxNode origEnclNode = (MxNode)theEnclDevice.clone();
                        MxNode otherDevice = null;
                        try {
                            otherDevice = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                        }
                        catch (MxUndefinedNodeException ex2) {
                        }
                        catch (MxInvalidNodeNameException ex2) {
                            // empty catch block
                        }
                        if (otherDevice != null) {
                            theEnclDevice.setDeviceName(enclName + "_" + enclSerialNumber);
                        } else {
                            theEnclDevice.setDeviceName(enclName);
                        }
                        theEnclDevice.setRackName("");
                        theEnclDevice.setEnclosureName(theEnclDevice.getNameString());
                        MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origEnclNode, theEnclDevice);
                    }
                } else if (enclSerialNumber != null && enclSerialNumber.trim().length() > 0) {
                    theEnclDevice = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, this.theRackDevice);
                }
                if (theEnclDevice != null && theEnclDevice.getSnoozeTime() != -2) {
                    theEnclDevice.setSnoozeTime(-2);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                }
            }
            catch (Exception ex) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Exception in storing enclosure information for device" + this.device.getNameString() + " " + ex));
                containerDeviceDebug.exception((Throwable)ex);
            }
            finally {
                if (theEnclDevice != null) {
                    theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDevice.getDeviceKey(), true);
                }
            }
        }
        return theEnclNodeAssociations;
    }

    public void storeTopologyInformation(Vector topology, MxNode theRackDevice) {
        try {
            String enclUUID = null;
            String enclName = null;
            String enclSerialNumber = null;
            String leftNeighborName = null;
            String leftNeighborUUID = null;
            String leftNeighborSerNo = null;
            String rghtNeighborName = null;
            String rghtNeighborUUID = null;
            String rghtNeighborSerNo = null;
            String hasServerBlades = null;
            String hasPowerBlades = null;
            Vector topologyElement = null;
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"CREATING AND STORING TOPOLOGY INFORMATION");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"\n*******************************************************************************************************************\n");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("TOPOLOGY Vector Size : " + topology.size()));
            NodeAssociations theEnclNodeAssociations = null;
            NodeAssociations theTopEnclNodeAssociations = null;
            NodeAssociations thebottomEnclNodeAssociations = null;
            for (int i = 0; i < topology.size(); ++i) {
                topologyElement = (Vector)topology.elementAt(i);
                enclUUID = ((String)topologyElement.elementAt(0)).trim();
                enclName = ((String)topologyElement.elementAt(1)).trim();
                if (enclName != null) {
                    enclName = this.validateName(enclName);
                }
                leftNeighborName = (String)topologyElement.elementAt(2);
                rghtNeighborName = (String)topologyElement.elementAt(3);
                hasServerBlades = (String)topologyElement.elementAt(4);
                hasPowerBlades = (String)topologyElement.elementAt(5);
                leftNeighborUUID = ((String)topologyElement.elementAt(6)).trim();
                rghtNeighborUUID = ((String)topologyElement.elementAt(7)).trim();
                enclSerialNumber = ((String)topologyElement.elementAt(8)).trim();
                leftNeighborSerNo = ((String)topologyElement.elementAt(9)).trim();
                rghtNeighborSerNo = ((String)topologyElement.elementAt(10)).trim();
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure UUID. [" + i + "] is " + enclUUID));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Name [" + i + "] is " + enclName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Top Neighbor Name [" + i + "] is " + leftNeighborName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Bottom Neighbor Name [" + i + "] is " + rghtNeighborName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Has Server Blades [" + i + "] is " + hasServerBlades));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Has Power Blades [" + i + "] is " + hasPowerBlades));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Top Neighbor serial No. : [" + i + "] is " + leftNeighborUUID));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Bottom neighbor serial no. [" + i + "] is " + rghtNeighborUUID));
                MxNode theEnclosure = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, theRackDevice);
                MxNode itsTopNeighbor = this.getEnclosureDevice(leftNeighborUUID, leftNeighborSerNo, leftNeighborName, null, null, theRackDevice);
                MxNode itsBottomNeighbor = this.getEnclosureDevice(rghtNeighborUUID, rghtNeighborSerNo, rghtNeighborName, null, null, theRackDevice);
                if (theEnclosure != null) {
                    NodeAssociations theRackNodeAssociations;
                    theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
                    Vector children = new Vector(1);
                    this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), theEnclosure.getDeviceKey());
                    if (itsTopNeighbor == null && itsBottomNeighbor == null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), -1, -1, 1);
                        this.cutOldNeighborLink(theEnclosure, true);
                        this.cutOldNeighborLink(theEnclosure, false);
                    } else if (itsTopNeighbor == null && itsBottomNeighbor != null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), -1, itsBottomNeighbor.getDeviceKey(), 1);
                        theEnclNodeAssociations.setTopMostItem(true);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsBottomNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - bottom enclosure empty (top null): " + itsBottomNeighbor.getNameString()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsBottomNeighbor, true);
                        }
                        this.cutOldNeighborLink(theEnclosure, true);
                    } else if (itsBottomNeighbor == null && itsTopNeighbor != null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), itsTopNeighbor.getDeviceKey(), -1, 1);
                        theEnclNodeAssociations.setBottomMostItem(true);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsTopNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - top enclosure empty (bottom null): " + itsTopNeighbor.getNameString()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsTopNeighbor, false);
                        }
                        this.cutOldNeighborLink(theEnclosure, false);
                    } else {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), itsTopNeighbor.getDeviceKey(), itsBottomNeighbor.getDeviceKey(), 1);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsTopNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - top enclosure empty: " + itsTopNeighbor.getNameString()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsTopNeighbor, false);
                        }
                        if ((children = this.myNodeRelationshipManager.getAllDevsInContainer(itsBottomNeighbor.getDeviceKey())).size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - bottom enclosure empty: " + itsBottomNeighbor.getNameString()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsBottomNeighbor, true);
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"Getting ready to store the neighbor info in dB");
                    if (itsTopNeighbor != null) {
                        theTopEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(itsTopNeighbor.getDeviceKey());
                        theTopEnclNodeAssociations.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
                        theEnclNodeAssociations.setTopNeighborDeviceKey(itsTopNeighbor.getDeviceKey());
                        this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), itsTopNeighbor.getDeviceKey());
                    }
                    if (itsBottomNeighbor != null) {
                        thebottomEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(itsBottomNeighbor.getDeviceKey());
                        thebottomEnclNodeAssociations.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
                        theEnclNodeAssociations.setBottomNeighborDeviceKey(itsBottomNeighbor.getDeviceKey());
                        this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), itsBottomNeighbor.getDeviceKey());
                    }
                    if (theRackDevice == null || (theRackNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theRackDevice.getDeviceKey())) == null) continue;
                    this.addTreeNodeToTopologyTree(theRackNodeAssociations, theEnclosure, itsTopNeighbor, itsBottomNeighbor);
                    continue;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"The middle enclosure is null : ");
            }
            if (this.hasTopologyChanged && theRackDevice != null) {
                NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                this.updateDevContainerAndRoleNames(theRackDevice);
            }
            if (theRackDevice != null) {
                this.setSubTypeOnEnclosure(theRackDevice);
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    private void setSubTypeOnEnclosure(MxNode theRackDevice) {
        MxNode theEnclosureNode = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        Vector enclosureKeyVector = nodeAssociationsManager.getAssociatedDevicesUsingATNs(theRackDevice.getDeviceKey(), "EnclosureToRack");
        int enclosureDeviceKey = 0;
        for (int i = 0; i < enclosureKeyVector.size(); ++i) {
            Integer vectKey = (Integer)enclosureKeyVector.elementAt(i);
            enclosureDeviceKey = vectKey;
            try {
                theEnclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclosureDeviceKey);
                if (!theEnclosureNode.getDeviceType().equalsIgnoreCase("Enclosure")) continue;
                this.addSubTypeOnEncl(theEnclosureNode, theRackDevice);
                continue;
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    private void addSubTypeOnEncl(MxNode theEnclosureNode, MxNode theRackNode) {
        if (theRackNode != null && theRackNode.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            this.addNodeTypeSubType(theEnclosureNode, NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
        }
        if (theRackNode != null && theRackNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            this.addNodeTypeSubType(theEnclosureNode, NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        }
        if (theRackNode != null && theRackNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE)) {
            this.addNodeTypeSubType(theEnclosureNode, NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
        }
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclosureNode, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MxNode getTheRackDevice() {
        return this.theRackDevice;
    }

    public void removeOldAssociationsFromThisSlot(int newDeviceKey, int theEnclDeviceKey) {
        int numSlotsUsed = this.myNodeRelationships.getNumBladeSlotsUsed();
        int slotNumber = this.myNodeRelationships.getSlotNumber();
        NodeAssociations theEnclDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey);
        if (theEnclDeviceNodeAssociations != null) {
            MxNode tmpDevice = theEnclDeviceNodeAssociations.getDeviceBySlotNumber(slotNumber);
            containerDeviceDebug.fine("IN REMOVE OLD ASSOCIATIONS for " + theEnclDeviceKey);
            containerDeviceDebug.fine("Slot number - " + slotNumber);
            containerDeviceDebug.fine("Number of slots used - " + numSlotsUsed);
            containerDeviceDebug.fine("Current device over there - " + tmpDevice);
            containerDeviceDebug.fine("New device wanting to be in that slot - " + newDeviceKey);
            if (tmpDevice != null && tmpDevice.getDeviceKey() != newDeviceKey) {
                for (int i = slotNumber; i < slotNumber + numSlotsUsed; ++i) {
                    tmpDevice = theEnclDeviceNodeAssociations.getDeviceBySlotNumber(i);
                    if (tmpDevice == null) continue;
                    this.myNodeRelationshipManager.removeBladeFromTopology(tmpDevice.getDeviceKey());
                    theEnclDeviceNodeAssociations.setContainerDeviceTree(this.removeBladeFromTopology(tmpDevice.getDeviceKey(), theEnclDeviceNodeAssociations.getContainerDeviceTree()));
                }
            }
        }
    }

    protected void removeOldDeviceFromThisSlot(NodeAssociations myDeviceNodeAssociations, NodeAssociations myEnclosureNodeAssociations, String DEVICE_TYPE, String ASSOCIATION_TYPE) {
        LOGGER.enter("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot(" + myDeviceNodeAssociations + "," + myEnclosureNodeAssociations + "," + DEVICE_TYPE + "," + ASSOCIATION_TYPE + ")");
        int NUM_SLOTS_USED = myDeviceNodeAssociations.getNumBladeSlotsUsed();
        int SLOT_NUMBER = myDeviceNodeAssociations.getSlotNumber();
        LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.NUM_SLOTS_USED " + NUM_SLOTS_USED);
        LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.SLOT_NUMBER " + SLOT_NUMBER);
        if (myEnclosureNodeAssociations != null) {
            MxNode deviceMxNode = this.getDeviceAtSlot(myEnclosureNodeAssociations.getDeviceKey(), DEVICE_TYPE, SLOT_NUMBER);
            LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.deviceMxNode " + deviceMxNode);
            if (deviceMxNode != null) {
                LOGGER.fine("RackEnclosureTopologyHandler.deviceMxNode.getDeviceKey() " + deviceMxNode.getDeviceKey());
                LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.myDeviceNodeAssociations.getDeviceKey() " + myDeviceNodeAssociations.getDeviceKey());
            }
            if (deviceMxNode != null && deviceMxNode.getDeviceKey() != myDeviceNodeAssociations.getDeviceKey()) {
                for (int i = SLOT_NUMBER; i < SLOT_NUMBER + NUM_SLOTS_USED; ++i) {
                    deviceMxNode = this.getDeviceAtSlot(myEnclosureNodeAssociations.getDeviceKey(), DEVICE_TYPE, i);
                    LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.deviceMxNode At " + i + " " + deviceMxNode);
                    if (deviceMxNode == null) continue;
                    LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.Removing old device at slot " + i + " for device " + DEVICE_TYPE);
                    try {
                        LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.Deleting node " + deviceMxNode.getName());
                        this.deleteAssociationsForDevice(myEnclosureNodeAssociations, deviceMxNode.getDeviceKey(), ASSOCIATION_TYPE);
                        MxNodeController.getDefaultControllerNoEx().deleteNode((MxTransaction)new MxCoreTransaction(), deviceMxNode);
                        LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.Deletion success");
                        continue;
                    }
                    catch (MxException e) {
                        LOGGER.fine("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot.Deletion failed");
                        LOGGER.exception((Throwable)e);
                    }
                }
            }
        }
        LOGGER.exit("RackEnclosureTopologyHandler.removeOldDeviceFromThisSlot(" + myDeviceNodeAssociations + "," + myEnclosureNodeAssociations + "," + DEVICE_TYPE + "," + ASSOCIATION_TYPE + ")");
    }

    private MxNode getDeviceAtSlot(int ENCLOSURE_DEVICE_KEY, String DEVICE_TYPE, int SLOT_NUMBER) {
        LOGGER.enter("RackEnclosureTopologyHandler.getDeviceAtSlot(" + ENCLOSURE_DEVICE_KEY + "," + DEVICE_TYPE + "," + SLOT_NUMBER + ")");
        Vector associatedDeviceList = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(ENCLOSURE_DEVICE_KEY, true);
        LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.associatedDeviceList.size " + associatedDeviceList.size());
        NodeAssociations na = null;
        DeviceAssociationObject dao = null;
        for (int i = 0; i < associatedDeviceList.size(); ++i) {
            dao = (DeviceAssociationObject)associatedDeviceList.elementAt(i);
            MxNode deviceMxNode = null;
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode " + deviceMxNode);
            if (deviceMxNode == null) continue;
            na = this.myNodeRelationshipManager.getNodeAssociations(dao.getDeviceKey());
            LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode " + deviceMxNode);
            LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.na " + na);
            LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode.getDeviceType() " + deviceMxNode.getDeviceType());
            if (na != null) {
                LOGGER.fine("RackEnclosureTopologyHandler.getDeviceAtSlot.na.getSlotNumber() " + na.getSlotNumber());
            }
            if (na == null || na.getSlotNumber() != SLOT_NUMBER || !deviceMxNode.getDeviceType().equalsIgnoreCase(DEVICE_TYPE)) continue;
            LOGGER.exit("RackEnclosureTopologyHandler.getDeviceAtSlot(" + ENCLOSURE_DEVICE_KEY + "," + DEVICE_TYPE + "," + SLOT_NUMBER + ")");
            return deviceMxNode;
        }
        LOGGER.exit("RackEnclosureTopologyHandler.getDeviceAtSlot(" + ENCLOSURE_DEVICE_KEY + "," + DEVICE_TYPE + "," + SLOT_NUMBER + ")");
        return null;
    }

    public void deleteAssociationsForDevice(NodeAssociations myEnclosureNodeAssociations, int DEVICEKEY, String ASSOCIATION_TYPE) {
        LOGGER.enter("RackEnclosureTopologyHandler.deleteAssociationsForDevice(" + myEnclosureNodeAssociations + "," + DEVICEKEY + "," + ASSOCIATION_TYPE + ")");
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(DEVICEKEY, ASSOCIATION_TYPE);
            myNodeRelationshipManager.deleteDimensionInformation(DEVICEKEY, ASSOCIATION_TYPE);
            myEnclosureNodeAssociations.removeTheAssociation(DEVICEKEY, ASSOCIATION_TYPE);
            LOGGER.fine("RackEnclosureTopologyHandler.deleteAssociations : SUCCESS");
        }
        catch (Exception e) {
            LOGGER.fine("RackEnclosureTopologyHandler.deleteAssociations : Exception " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("RackEnclosureTopologyHandler.deleteAssociationsForDevice(" + myEnclosureNodeAssociations + "," + DEVICEKEY + "," + ASSOCIATION_TYPE + ")");
    }

    private void fixEmptyNeighbor(MxNode theEnclosure, MxNode emptyNeighbor, boolean emptyNeighborOnBottom) {
        NodeAssociations theEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
        NodeAssociations emptyNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(emptyNeighbor.getDeviceKey());
        if (containerDeviceDebug.check(35)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - enclosure: " + theEnclosure.getNameString() + " emptyNeighbor: " + emptyNeighbor.getNameString() + " bottom: " + new Boolean(emptyNeighborOnBottom)));
        }
        if (emptyNeighborOnBottom) {
            this.storeNeighborInfoInDb(emptyNeighbor.getDeviceKey(), theEnclosure.getDeviceKey(), -1, 2);
        } else {
            this.storeNeighborInfoInDb(emptyNeighbor.getDeviceKey(), -1, theEnclosure.getDeviceKey(), 3);
        }
        MxNode theEnclRack = theEnclosureNodeAssociations.getParent();
        MxNode theEmptyRack = emptyNeighborNodeAssociations.getParent();
        if (theEnclRack != null && theEmptyRack != null && theEnclRack.getDeviceKey() != theEmptyRack.getDeviceKey()) {
            MxNode rackDev = theEnclRack;
            if (rackDev != null) {
                if (containerDeviceDebug.check(35)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - setting new rack association for enclosure: " + emptyNeighbor.getNameString()));
                }
                this.myNodeRelationshipManager.setNewRack(emptyNeighbor.getDeviceKey(), rackDev.getDeviceKey());
                emptyNeighborNodeAssociations.setParent(rackDev.getDeviceKey());
                this.myNodeRelationshipManager.update(emptyNeighborNodeAssociations);
                this.hasTopologyChanged = true;
            }
        } else if (containerDeviceDebug.check(35) && theEnclosureNodeAssociations.getParent() != null && emptyNeighborNodeAssociations.getParent() != null) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - both enclosures have same rack - enclosure: " + theEnclosure.getNameString() + " (" + new Integer(theEnclosureNodeAssociations.getParent().getDeviceKey()) + ")" + " empty encl.: " + emptyNeighbor.getNameString() + " (" + new Integer(emptyNeighborNodeAssociations.getParent().getDeviceKey()) + ")"));
        }
    }

    public void cutOldNeighborLink(MxNode enclDev, boolean topNeighbor) {
        int neighborKey = -1;
        MxNode neighborDev = null;
        if (this.myNodeRelationshipManager == null) {
            try {
                this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.exception((Throwable)e);
                return;
            }
        }
        NodeAssociations theEnclDevNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclDev.getDeviceKey());
        if (topNeighbor) {
            neighborKey = theEnclDevNodeAssociations.getTopNeighborDeviceKey();
            try {
                neighborDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(neighborKey);
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (neighborKey != -1) {
                NodeAssociations theNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(neighborDev.getDeviceKey());
                this.storeNeighborInfoInDb(enclDev.getDeviceKey(), -1, -1, 2);
                if (neighborDev != null && theNeighborNodeAssociations.getBottomNeighborDeviceKey() == enclDev.getDeviceKey()) {
                    this.storeNeighborInfoInDb(neighborKey, -1, -1, 3);
                }
            }
        } else {
            neighborKey = theEnclDevNodeAssociations.getBottomNeighborDeviceKey();
            try {
                neighborDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(neighborKey);
            }
            catch (MxUndefinedNodeException ex1) {
                // empty catch block
            }
            if (neighborKey != -1) {
                NodeAssociations theNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(neighborDev.getDeviceKey());
                this.storeNeighborInfoInDb(enclDev.getDeviceKey(), -1, -1, 3);
                if (containerDeviceDebug.check(35)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in cutOldNeighborLink - bottom neighbor: " + neighborDev + " neighbor's top neighbor: " + theNeighborNodeAssociations.getTopNeighborDeviceKey()));
                }
                if (neighborDev != null && theNeighborNodeAssociations.getTopNeighborDeviceKey() == enclDev.getDeviceKey()) {
                    this.storeNeighborInfoInDb(neighborKey, -1, -1, 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevContainerAndRoleNames(MxNode rackDev) {
        String rackName = rackDev.getNameString();
        StringBuffer sqlStr = new StringBuffer(250);
        Statement myStatement = null;
        Connection myConnection = null;
        sqlStr.append("update devContainerAndRole set RackName='");
        sqlStr.append(rackName);
        sqlStr.append("' where ");
        RackEnclosureObject reObj = new RackEnclosureObject(new Integer(rackDev.getDeviceKey()), rackDev.getNameString(), rackDev.getAgentUUID(), new Integer(13), null, null);
        if (reObj != null) {
            DeviceByRackDataObject.buildSQLQuery((StringBuffer)sqlStr, (RackEnclosureObject)reObj, (int)0, (boolean)false);
            if (containerDeviceDebug.check(35)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in updateDevContainerAndRoleNames - sqlStr: " + sqlStr.toString()));
            }
            try {
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("rackEnclosureTopologyHandler:updateDevContainerAndRoleNames");
                myStatement = myConnection.createStatement();
                myStatement.executeUpdate(sqlStr.toString());
                myStatement.close();
                myStatement = null;
                Vector devsInRack = this.myNodeRelationshipManager.getAllDevsInContainer(rackDev.getDeviceKey());
                for (int i = 0; i < devsInRack.size(); ++i) {
                    Integer tmpDevKey = (Integer)devsInRack.elementAt(i);
                    MxNode tmpDev = null;
                    try {
                        tmpDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(tmpDevKey.intValue());
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    if (tmpDev == null || !tmpDev.getDeviceType().equals("Enclosure") || (reObj = new RackEnclosureObject(new Integer(tmpDev.getDeviceKey()), tmpDev.getNameString(), tmpDev.getAgentUUID(), new Integer(14), null, null)) == null) continue;
                    sqlStr.setLength(0);
                    sqlStr.append("update devContainerAndRole set EnclosureName='");
                    sqlStr.append(tmpDev.getNameString());
                    sqlStr.append("' where ");
                    DeviceByRackDataObject.buildSQLQuery((StringBuffer)sqlStr, (RackEnclosureObject)reObj, (int)0, (boolean)false);
                    myStatement = myConnection.createStatement();
                    if (containerDeviceDebug.check(35)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in updateDevContainerAndRoleNames - sqlStr: " + sqlStr));
                    }
                    myStatement.executeUpdate(sqlStr.toString());
                    myStatement.close();
                    myStatement = null;
                }
            }
            catch (SQLException e) {
                containerDeviceDebug.exception((Throwable)e);
            }
            finally {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeNeighborInfoInDb(int theEnclDeviceKey, int topNeighbor, int bottomNeighbor, int neighborEmpty) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("rackEnclosureTopologyHandler:storeNeighborInfoInDb");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from rackTopology where Encl_DeviceKey=" + theEnclDeviceKey);
            if (myResultSet.next()) {
                int tNeighbor = myResultSet.getInt(1);
                int bNeighbor = myResultSet.getInt(2);
                if (tNeighbor != topNeighbor || bNeighbor != bottomNeighbor) {
                    myResultSet.close();
                    myResultSet = null;
                    myStatement.close();
                    myStatement = null;
                    myStatement = myConnection.createStatement();
                    String sqlStr = null;
                    sqlStr = neighborEmpty == 3 ? "update rackTopology set Right_Neighbor_DeviceKey=" + bottomNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey : (neighborEmpty == 2 ? "update rackTopology set Left_Neighbor_DeviceKey=" + topNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey : "update rackTopology set Right_Neighbor_DeviceKey=" + bottomNeighbor + ", Left_Neighbor_DeviceKey=" + topNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey);
                    if (containerDeviceDebug.check(35)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in storeNeighborInfoInDb - query: " + sqlStr));
                    }
                    myStatement.executeUpdate(sqlStr);
                    this.hasTopologyChanged = true;
                }
            } else {
                myResultSet.close();
                myResultSet = null;
                myStatement.close();
                myStatement = null;
                myStatement = myConnection.createStatement();
                myStatement.executeUpdate("insert into rackTopology values(" + theEnclDeviceKey + "," + bottomNeighbor + "," + topNeighbor + ")");
            }
        }
        catch (SQLException myException) {
        }
        finally {
            if (myResultSet != null) {
                try {
                    myResultSet.close();
                    myResultSet = null;
                }
                catch (SQLException myException) {}
            }
            if (myStatement != null) {
                try {
                    myStatement.close();
                    myStatement = null;
                }
                catch (SQLException myException) {}
            }
            if (myConnection != null) {
                try {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
                catch (SQLException myException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MxNode getEnclosureDevice(String enclUUID, String enclSerialNumber, String enclName, String hasServerBlades, String hasPowerBlades, MxNode theRackDevice) {
        MxNode theEnclDevice = null;
        if (enclName.trim().equalsIgnoreCase("unknown")) {
            return theEnclDevice;
        }
        int theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerialNumber, 14);
        try {
            Integer n = syncEnclAdds;
            synchronized (n) {
                try {
                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUUID);
                }
                catch (MxUndefinedNodeException ex) {
                    // empty catch block
                }
                if (theEnclDevice == null) {
                    if (theEnclDeviceKey == 0) {
                        if (enclSerialNumber != null && enclSerialNumber.trim().length() > 0) {
                            theEnclDevice = new MxNode();
                            String productId = this.prodIdList.get(enclSerialNumber);
                            if (productId != null) {
                                theEnclDevice.setProductId(productId);
                            }
                            if (containerDeviceDebug.check(10)) {
                                containerDeviceDebug.fine("New ENclosure Device Created: ");
                            }
                            theEnclDevice.setSerialNumber(enclSerialNumber);
                            if (enclUUID != null && enclUUID.trim().length() > 0) {
                                this.useThisIdForNamingEnclosures = enclUUID;
                                theEnclDevice.setAgentUUID(enclUUID);
                            } else {
                                this.useThisIdForNamingEnclosures = enclSerialNumber;
                                theEnclDevice.setAgentUUID(enclSerialNumber);
                            }
                            if (enclName != null && enclName.trim().length() > 0) {
                                MxNode otherDevice = null;
                                try {
                                    otherDevice = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                                }
                                catch (MxUndefinedNodeException ex2) {
                                }
                                catch (MxInvalidNodeNameException ex2) {
                                    containerDeviceDebug.exception((Throwable)ex2);
                                }
                                if (otherDevice != null) {
                                    if (otherDevice.getAgentUUID().equalsIgnoreCase(theEnclDevice.getAgentUUID()) && otherDevice.getSerialNumber().equalsIgnoreCase(theEnclDevice.getSerialNumber())) {
                                        return otherDevice;
                                    }
                                    theEnclDevice.setDeviceName(enclName + "_" + this.useThisIdForNamingEnclosures);
                                } else {
                                    theEnclDevice.setDeviceName(enclName);
                                }
                            } else {
                                theEnclDevice.setDeviceName("Encl_" + this.useThisIdForNamingEnclosures);
                            }
                            theEnclDevice.setDeviceType("Enclosure");
                            if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                                theEnclDevice.addDeviceSubType("ServerEnc");
                                theEnclDevice.setModel("Server Enclosure");
                            } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                                theEnclDevice.addDeviceSubType("PowerEnc");
                                theEnclDevice.setModel("Power Enclosure");
                            } else if (hasServerBlades == null && hasPowerBlades == null && productId != null && productId.length() > 0) {
                                if (productId.contains("7") || productId.contains("0x0002")) {
                                    theEnclDevice.addDeviceSubType("ServerEnc");
                                    theEnclDevice.setModel("Server Enclosure");
                                } else if (productId.contains("0x0005") || productId.contains("0x0003")) {
                                    theEnclDevice.addDeviceSubType("PowerEnc");
                                    theEnclDevice.setModel("Power Enclosure");
                                }
                            }
                            if (theRackDevice != null) {
                                theEnclDevice.setRackName(theRackDevice.getNameString());
                            }
                            theEnclDevice.setSnoozeTime(-2);
                            try {
                                MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), theEnclDevice);
                            }
                            catch (MxInvalidIPAddressException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxInvalidNodeNameException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxDuplicateNodeException ex3) {
                                theEnclDevice = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, theRackDevice);
                            }
                            catch (MxObjectPersistenceException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxInvalidTransactionException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            theEnclDeviceKey = theEnclDevice.getDeviceKey();
                            NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey);
                            theEnclNodeAssociations.initializeTopologyTree();
                            theEnclNodeAssociations.setInContainer(true);
                            theEnclNodeAssociations.setSource("Enclosure");
                            if (theRackDevice != null) {
                                theEnclNodeAssociations.setParent(theRackDevice.getDeviceKey());
                                theEnclNodeAssociations.setTheAssociation(theEnclDeviceKey, theRackDevice.getDeviceKey(), "EnclosureToRack", false);
                                if (containerDeviceDebug.check(40)) {
                                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in RackEnclosureTopologyHandler.getEnclosureDevice - setting RackName for enclosure: " + theRackDevice.getNameString()));
                                }
                            }
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Device key for enclosure : " + theEnclDeviceKey));
                            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        }
                    } else {
                        try {
                            theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                        }
                        catch (MxUndefinedNodeException ex1) {
                            // empty catch block
                        }
                        if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                            theEnclDevice.addDeviceSubType("ServerEnc");
                            theEnclDevice.setModel("Server Enclosure");
                        } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                            theEnclDevice.setDeviceSubTypes(new ArrayList());
                            theEnclDevice.addDeviceSubType("PowerEnc");
                            theEnclDevice.setModel("Power Enclosure");
                        }
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                    }
                } else {
                    if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                        theEnclDevice.addDeviceSubType("ServerEnc");
                        theEnclDevice.setModel("Server Enclosure");
                    } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                        theEnclDevice.addDeviceSubType("PowerEnc");
                        theEnclDevice.setModel("Power Enclosure");
                    }
                    if (theEnclDevice.getSnoozeTime() != -2) {
                        theEnclDevice.setSnoozeTime(-2);
                    }
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        return theEnclDevice;
    }

    protected void addNodeTypeSubType(MxNode node, String strNodeSubType) {
        boolean bModify = false;
        List nodeSubTypeList = node.getDeviceSubTypes();
        if (nodeSubTypeList.isEmpty()) {
            bModify = true;
            node.addDeviceSubType(strNodeSubType);
        } else if (strNodeSubType != null && !nodeSubTypeList.contains(strNodeSubType)) {
            bModify = true;
            node.addDeviceSubType(strNodeSubType);
        }
        if (bModify) {
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), node, false);
            }
            catch (MxException aMxException) {
                LOGGER.fine("RackEnclosureTopologyHandler::addNodeTypeSubType(): exception " + (Object)((Object)aMxException));
            }
        }
    }

    private boolean areTopologyTreesSame(DefaultMutableTreeNode curDevTopologyTree, DefaultMutableTreeNode oldDevTopologyTree) {
        LOGGER.enter("RackEnclosureTopologyHandler.areTopologyTreesSame(" + curDevTopologyTree + "," + oldDevTopologyTree + ")");
        boolean areTreesSame = true;
        if (curDevTopologyTree == null && oldDevTopologyTree == null) {
            areTreesSame = true;
        } else if (curDevTopologyTree == null && oldDevTopologyTree != null) {
            areTreesSame = false;
        } else if (curDevTopologyTree != null && oldDevTopologyTree == null) {
            areTreesSame = false;
        } else if (curDevTopologyTree != null && oldDevTopologyTree != null) {
            if (curDevTopologyTree.getChildCount() != oldDevTopologyTree.getChildCount()) {
                areTreesSame = false;
            } else if (curDevTopologyTree != null) {
                LOGGER.fine("Now check if the children are same");
                int treeCount = curDevTopologyTree.getChildCount();
                int treeChildDeviceKey = -1;
                for (int i = 0; i < treeCount; ++i) {
                    treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)curDevTopologyTree.getChildAt(i)).getUserObject();
                    if (this.isChildInTree(oldDevTopologyTree, treeChildDeviceKey)) continue;
                    areTreesSame = false;
                    break;
                }
            }
        }
        LOGGER.fine("areTreesSame:" + areTreesSame);
        LOGGER.exit("RackEnclosureTopologyHandler.areTopologyTreesSame(" + curDevTopologyTree + "," + oldDevTopologyTree + ")");
        return areTreesSame;
    }

    private boolean isChildInTree(DefaultMutableTreeNode topologyTree, int deviceKey) {
        LOGGER.enter("RackEnclosureTopologyHandler.isChildInTree(" + topologyTree + "," + deviceKey + ")");
        if (topologyTree != null) {
            int treeCount = topologyTree.getChildCount();
            int treeChildDeviceKey = -1;
            for (int i = 0; i < treeCount; ++i) {
                treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)topologyTree.getChildAt(i)).getUserObject();
                if (treeChildDeviceKey != deviceKey) continue;
                LOGGER.fine("Child is present in tree");
                return true;
            }
        }
        LOGGER.fine("Child not present in tree");
        LOGGER.exit("RackEnclosureTopologyHandler.isChildInTree(" + topologyTree + "," + deviceKey + ")");
        return false;
    }

    public void addDeviceToTopologyTree(NodeAssociations theNodeAssociations, int deviceKey) {
        LOGGER.enter("Start:RackEnclosureTopologyHandler.addDeviceToTopologyTree(theNodeAssociations " + theNodeAssociations + ",deviceKey " + deviceKey);
        try {
            DefaultMutableTreeNode topologyTree = theNodeAssociations.getContainerDeviceTree();
            LOGGER.fine("topologyTree for theNodeAssociations " + theNodeAssociations.getDeviceKey() + " is:" + topologyTree);
            if (topologyTree != null) {
                int treeCount = topologyTree.getChildCount();
                int treeChildDeviceKey = -1;
                for (int i = 0; i < treeCount; ++i) {
                    DefaultMutableTreeNode oldDevTopologyTree;
                    treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)topologyTree.getChildAt(i)).getUserObject();
                    if (treeChildDeviceKey != deviceKey) continue;
                    DefaultMutableTreeNode curDevTopologyTree = this.myNodeRelationshipManager.getNodeAssociations(deviceKey).getContainerDeviceTree();
                    if (this.areTopologyTreesSame(curDevTopologyTree, oldDevTopologyTree = (DefaultMutableTreeNode)topologyTree.getChildAt(i))) {
                        return;
                    }
                    topologyTree.remove(i);
                    treeCount = topologyTree.getChildCount();
                }
            } else {
                theNodeAssociations.initializeTopologyTree();
                topologyTree = theNodeAssociations.getContainerDeviceTree();
            }
            DefaultMutableTreeNode childNode = null;
            NodeAssociations deviceAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceKey);
            childNode = deviceAssociations.getContainerDeviceTree();
            topologyTree.add(childNode);
            theNodeAssociations.setContainerDeviceTree(topologyTree);
            int theEnclDeviceKey = theNodeAssociations.getDeviceKey();
            MxNode enclMxNode = null;
            enclMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(theEnclDeviceKey));
            if (enclMxNode.getDeviceType().equalsIgnoreCase("Enclosure")) {
                MxNode deviceMxNode = null;
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                List nodeSubTypeList = deviceMxNode.getDeviceSubTypes();
                if (enclMxNode != null && (nodeSubTypeList.contains(NodeSubTypeMapper.BLADE_SUBTYPE.toString()) || deviceMxNode.getDeviceType().equals("Switch") || nodeSubTypeList.contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()))) {
                    if (nodeSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
                        this.addNodeTypeSubType(enclMxNode, NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                    } else if (nodeSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                        this.addNodeTypeSubType(enclMxNode, NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                    } else if (nodeSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                        this.addNodeTypeSubType(enclMxNode, NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
                    }
                }
            }
            this.printDebugTreeInformation(NodeAssociationsManager.getDefaultManager(), topologyTree, deviceKey);
        }
        catch (Exception ex) {
            containerDeviceDebug.exception((Throwable)ex);
            LOGGER.fine("Exception in RackEnclosureTopologyHandler.addDeviceToTopologyTree()" + ex);
        }
        LOGGER.fine("Exit:RackEnclosureTopologyHandler.addDeviceToTopologyTree(theNodeAssociations " + theNodeAssociations + ",deviceKey " + deviceKey);
    }

    public void addTreeNodeToTopologyTree(NodeAssociations theNodeAssociations, int theEnclosureDeviceKey, MxNode topEnclosure, MxNode bottomEnclosure) {
        MxNode theEnclosure = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(theEnclosureDeviceKey));
        this.addTreeNodeToTopologyTree(theNodeAssociations, theEnclosure, topEnclosure, bottomEnclosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeNodeToTopologyTree(NodeAssociations theNodeAssociations, MxNode theEnclosure, MxNode topEnclosure, MxNode bottomEnclosure) {
        DefaultMutableTreeNode topologyTree = theNodeAssociations.getContainerDeviceTree();
        try {
            if (rackTopologyDebug.check(20)) {
                rackTopologyDebug.finer("\n\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                rackTopologyDebug.finer("                Adding Tree Nodes to Topology Tree        ");
                rackTopologyDebug.finer("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                rackTopologyDebug.finer("ROOT OF THE TOPOLOGY TREE : " + topologyTree.getRoot().toString());
            }
            if (theEnclosure == null) {
                return;
            }
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations theEnclDA = myNodeAssociationsManager.getNodeAssociations(theEnclosure.getDeviceKey());
            DefaultMutableTreeNode childNode = theEnclDA.getContainerDeviceTree();
            DefaultMutableTreeNode top = null;
            DefaultMutableTreeNode bottom = null;
            NodeAssociations topDA = null;
            NodeAssociations bottomDA = null;
            int index = 0;
            if (childNode == null) {
                rackTopologyDebug.finer("Container Tree for Child Node is null " + theEnclosure.toString());
                return;
            }
            if (topEnclosure != null) {
                topDA = myNodeAssociationsManager.getNodeAssociations(topEnclosure.getDeviceKey());
                top = topDA.getContainerDeviceTree();
                rackTopologyDebug.finer("GOING TO ADD enclosures 1: " + topEnclosure.getNameString() + " and '" + top + "'");
            }
            rackTopologyDebug.finer("GOING TO ADD enclosures 2: " + theEnclosure.getNameString() + " and '" + childNode + "'");
            if (bottomEnclosure != null) {
                bottomDA = myNodeAssociationsManager.getNodeAssociations(bottomEnclosure.getDeviceKey());
                bottom = bottomDA.getContainerDeviceTree();
                rackTopologyDebug.finer("GOING TO ADD enclosures 3: " + bottomEnclosure.getNameString() + " and '" + bottom + "'");
            }
            rackTopologyDebug.finer("Tree Nodes : Top is " + top + " and middle " + childNode + " and bottom " + bottom);
            if (top == null && bottom != null) {
                rackTopologyDebug.finer("1 Top node is null so middle must be the first one in the rack");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    topologyTree.insert(childNode, 0);
                    theEnclDA.setTopMostItem(true);
                    theEnclDA.setTopNeighborDeviceKey(-1);
                    rackTopologyDebug.finer("2 Middle node did not exist in the rack tree so added it and set topmost property to true and top neighbor to -1");
                    if (!this.doesTreeNodeExist(bottom, topologyTree) && bottom != null) {
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.finer("3 Bottom neighbor does not exist and so inserted it at index 1");
                    } else {
                        int topNeighborDK = bottomDA.getTopNeighborDeviceKey();
                        rackTopologyDebug.finer("4 Bottom node does exist and its top neighbor device key is " + topNeighborDK);
                        if (topNeighborDK != theEnclosure.getDeviceKey() && bottom != null) {
                            bottomDA.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
                            int middleIndex = topologyTree.getIndex(childNode);
                            if (topologyTree.getIndex(bottom) != middleIndex + 1) {
                                rackTopologyDebug.finer("5a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                                this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                            }
                            rackTopologyDebug.finer("5 Made the bottom encl to be next to the middle encl");
                        } else {
                            rackTopologyDebug.finer("6 Bottom node was the neighbor of middle so do nothing");
                        }
                    }
                    theEnclDA.setBottomNeighborDeviceKey(bottomEnclosure.getDeviceKey());
                } else if (!theEnclDA.isTopMostItem()) {
                    rackTopologyDebug.finer("7 Middle node exists and is not the topmost item");
                    topologyTree = this.moveNodeAndOtherNeighborsToTopOfTree(topologyTree, childNode, myNodeAssociationsManager);
                }
                return;
            }
            if (bottom == null && top != null) {
                rackTopologyDebug.finer("9 The bottom node is null so middle node must be the last one in the rack");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.finer("10 Middle node does not exist in the tree");
                    topologyTree.add(childNode);
                    theEnclDA.setBottomMostItem(true);
                    theEnclDA.setBottomNeighborDeviceKey(-1);
                    rackTopologyDebug.finer("11 Added middle node to the end of the rack tree and set bottomMost property to true and bottom neighbor DK to -1");
                    if (!this.doesTreeNodeExist(top, topologyTree)) {
                        index = topologyTree.getIndex(childNode);
                        if (index - 1 >= 0) {
                            topologyTree.insert(top, index);
                            rackTopologyDebug.finer("12 Top node did not exist and so added it to before middle node");
                        } else {
                            rackTopologyDebug.finer("12a Top node did not exist but middle node was at index " + index);
                        }
                    } else {
                        int bottomNeighborDK = topDA.getBottomNeighborDeviceKey();
                        rackTopologyDebug.finer("13 Top node does exist and its bottom neighbor DK : " + bottomNeighborDK);
                        if (bottomNeighborDK != theEnclosure.getDeviceKey()) {
                            topDA.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
                            topologyTree.remove(top);
                            int middleIndex = topologyTree.getIndex(childNode);
                            if (middleIndex - 1 >= 0) {
                                if (topologyTree.getIndex(top) != middleIndex - 1) {
                                    rackTopologyDebug.finer("13a Top exists in the tree but is out of place so moving it and neighbors to before middle");
                                    topologyTree = this.moveNodeAndOtherNeighborsToBeforeAnotherNode(topologyTree, top, childNode, myNodeAssociationsManager);
                                }
                                rackTopologyDebug.finer("14 Top node's bottom neighbor was not the middle encl so moved things around to make that happen");
                            } else {
                                rackTopologyDebug.finer("14a Top node's bottom neighbor was not the middle encl but index was " + middleIndex);
                            }
                        } else {
                            rackTopologyDebug.finer("15 Top node's bottom neighbor was the middle node so do nothing");
                        }
                    }
                    theEnclDA.setTopNeighborDeviceKey(topEnclosure.getDeviceKey());
                } else if (!theEnclDA.isBottomMostItem()) {
                    rackTopologyDebug.finer("16 Yes, the middle node exists in the tree and it is not the bottom most");
                    topologyTree = this.moveNodeAndOtherNeighborsToBottomOfTree(topologyTree, childNode, myNodeAssociationsManager);
                }
                return;
            }
            if (top == null && bottom == null) {
                rackTopologyDebug.finer("17a Before adding the middle node, checking to see if it exists");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    topologyTree.add(childNode);
                    rackTopologyDebug.finer("17 Only middle node is not null, doesn't exist in tree and is not empty so add to the tree");
                } else {
                    rackTopologyDebug.finer("17b Only middle node is not null, but it exists in tree so do nothing");
                }
                return;
            }
            rackTopologyDebug.finer("18 This means that all three enclosures exist.  But, do they exist in the tree?");
            if (!this.doesTreeNodeExist(top, topologyTree)) {
                rackTopologyDebug.finer("19 Top node does not exist");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.finer("20 Middle node does not exist");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.finer("21 Bottom node does not exist");
                        rackTopologyDebug.fine("The topology Tree count : " + topologyTree.getChildCount());
                        if (topologyTree.getChildCount() > 0) {
                            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getFirstChild();
                            if (myNodeAssociationsManager.getNodeAssociations(new Integer(tmp.toString()).intValue()).isTopMostItem()) {
                                rackTopologyDebug.finer("21a Tree already has a topmost item that should be at the top");
                                tmp = (DefaultMutableTreeNode)topologyTree.getLastChild();
                                if (myNodeAssociationsManager.getNodeAssociations(new Integer(tmp.toString()).intValue()).isBottomMostItem()) {
                                    rackTopologyDebug.finer("21b Tree already has a bottommost item that should be at the bottom");
                                } else {
                                    topologyTree.add(top);
                                    topologyTree.add(childNode);
                                    topologyTree.add(bottom);
                                    rackTopologyDebug.finer("22 Inserted top, middle and bottom at end of the tree");
                                }
                            } else if (topEnclosure.getDeviceSubTypes().contains("PowerEnc") || theEnclosure.getDeviceSubTypes().contains("PowerEnc") || bottomEnclosure.getDeviceSubTypes().contains("PowerEnc")) {
                                topologyTree.add(top);
                                topologyTree.add(childNode);
                                topologyTree.add(bottom);
                            } else {
                                topologyTree.insert(top, 0);
                                topologyTree.insert(childNode, topologyTree.getIndex(top) + 1);
                                topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                                rackTopologyDebug.finer("22 Inserted top at 0, middle at 1 and bottom at 2");
                            }
                        } else {
                            topologyTree.add(top);
                            topologyTree.add(childNode);
                            topologyTree.add(bottom);
                            rackTopologyDebug.finer("22 Inserted top, middle and bottom at end of the tree");
                        }
                    } else {
                        rackTopologyDebug.finer("23 Bottom node exists");
                        topologyTree.insert(childNode, topologyTree.getIndex(bottom));
                        topologyTree.insert(top, topologyTree.getIndex(childNode));
                        rackTopologyDebug.finer("24 Inserted middle before bottom and top before middle");
                    }
                } else {
                    rackTopologyDebug.finer("25 Middle node exists");
                    index = topologyTree.getIndex(childNode);
                    if (index > 0) {
                        topologyTree.insert(top, index);
                    } else {
                        topologyTree.insert(top, 0);
                    }
                    rackTopologyDebug.finer("26 Inserted top node before middle");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.finer("27 bottom does not exist");
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.finer("28 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.finer("29 bottom already exists in the tree at index " + this.getIndex(bottom, topologyTree));
                        rackTopologyDebug.finer("29 Index for child node (middle) in the tree : " + this.getIndex(childNode, topologyTree));
                        if (this.getIndex(bottom, topologyTree) != this.getIndex(childNode, topologyTree) + 1) {
                            rackTopologyDebug.finer("29a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                }
            } else {
                rackTopologyDebug.finer("30 Top node exists");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.finer("31 Middle node does not exist");
                    int topIndex = topologyTree.getIndex(top);
                    rackTopologyDebug.finer("31a Index of Top Node : " + topIndex + " And no. of children-1 : " + (topologyTree.getChildCount() - 1));
                    if (topIndex == topologyTree.getChildCount() - 1) {
                        topologyTree.add(childNode);
                    } else {
                        topologyTree.insert(childNode, topIndex + 1);
                    }
                    rackTopologyDebug.finer("32 Added middle node after the top");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.finer("33 Bottom does not exist");
                        int middleIndex = topologyTree.getIndex(childNode);
                        if (middleIndex == topologyTree.getChildCount() - 1) {
                            topologyTree.add(bottom);
                        } else {
                            topologyTree.insert(bottom, middleIndex + 1);
                        }
                        rackTopologyDebug.finer("34 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.finer("34a bottom already exists in the tree");
                        if (topologyTree.getIndex(bottom) != topologyTree.getIndex(childNode) + 1) {
                            rackTopologyDebug.finer("34a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                } else {
                    rackTopologyDebug.finer("35 Middle node exists");
                    int tempTopIndex = topologyTree.getIndex(top);
                    int tempMiddleIndex = topologyTree.getIndex(childNode);
                    if (tempTopIndex != -1 && tempMiddleIndex != -1 && tempTopIndex != tempMiddleIndex - 1) {
                        rackTopologyDebug.finer("35a Top exists in the tree but is out of place so moving it and neighbors to before middle");
                        topologyTree = this.moveNodeAndOtherNeighborsToBeforeAnotherNode(topologyTree, top, childNode, myNodeAssociationsManager);
                    }
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.finer("36 Bottom node does not exist");
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.finer("37 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.finer("37a bottom already exists in the tree");
                        rackTopologyDebug.finer("37a PRINTING THE INDICES bottom " + topologyTree.getIndex(bottom) + " and childNode (MIDDLE) : " + topologyTree.getIndex(childNode));
                        int tempBottomIndex = topologyTree.getIndex(bottom);
                        if (tempBottomIndex != -1 && tempMiddleIndex != -1 && tempBottomIndex != tempMiddleIndex + 1) {
                            rackTopologyDebug.finer("37b Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                }
            }
            topDA.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
            theEnclDA.setTopNeighborDeviceKey(topEnclosure.getDeviceKey());
            theEnclDA.setBottomNeighborDeviceKey(bottomEnclosure.getDeviceKey());
            bottomDA.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
        }
        catch (Exception e) {
            rackTopologyDebug.finer("Exception in adding node to the tree " + e.getMessage());
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            theNodeAssociations.setContainerDeviceTree(topologyTree);
        }
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToTopOfTree(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(childNode, 0);
        for (i = topologyTree.getIndex(childNode); i < topologyTree.getChildCount() - 1; ++i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i + 1);
            MxNode firstDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)first.getUserObject());
            MxNode secondDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)second.getUserObject());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.add(second);
            rackTopologyDebug.finer("8 Added node " + second.toString() + " to the tmp tree");
        }
        for (i = 0; i < tmpVector.size(); ++i) {
            topologyTree.insert((MutableTreeNode)tmpVector.get(i), i);
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToBottomOfTree(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.add(childNode);
        for (int i = topologyTree.getIndex(childNode); i > 0; --i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i - 1);
            MxNode firstDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)first.getUserObject());
            MxNode secondDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)second.getUserObject());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getTopNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.insertElementAt(second, 0);
            rackTopologyDebug.finer("17 Added node " + second.toString() + " to the tmp tree");
        }
        for (int j = 0; j < tmpVector.size(); ++j) {
            topologyTree.add((MutableTreeNode)tmpVector.get(j));
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToAfterAnotherNode(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode bottom, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(bottom, 0);
        MxNode firstDev = null;
        MxNode secondDev = null;
        rackTopologyDebug.finest(" PRINTING THE Indices : Bottom : " + topologyTree.getIndex(bottom) + " and Middle " + topologyTree.getIndex(childNode));
        for (i = topologyTree.getIndex(bottom); i < topologyTree.getChildCount() - 1; ++i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i + 1);
            try {
                firstDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)first.getUserObject()).intValue());
                secondDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)second.getUserObject()).intValue());
            }
            catch (MxUndefinedNodeException ex) {
                containerDeviceDebug.exception((Throwable)ex);
                continue;
            }
            rackTopologyDebug.finest(" i " + i + " comparison between " + myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() + " and " + secondDev.getDeviceKey());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.add(second);
            rackTopologyDebug.finest(" Added node " + second.toString() + " to the tmp tree");
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)"Going to print the list of nodes in the vector");
        for (i = 0; i < tmpVector.size(); ++i) {
            rackTopologyDebug.finest(" Contents of vector at " + i + " is " + tmpVector.get(i));
        }
        boolean addToEndOfTree = false;
        int i2 = topologyTree.getIndex(childNode) + 1;
        for (int j = 0; j < tmpVector.size(); ++j) {
            if (topologyTree.getIndex(childNode) == topologyTree.getChildCount() - 1 || addToEndOfTree) {
                addToEndOfTree = true;
                topologyTree.add((MutableTreeNode)tmpVector.get(j));
            } else {
                try {
                    topologyTree.insert((MutableTreeNode)tmpVector.get(j), i2);
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                    rackTopologyDebug.exception((Throwable)e);
                    rackTopologyDebug.finer("Exception:moveNodeAndOtherNeighborsToAfterAnotherNode()" + e);
                }
            }
            rackTopologyDebug.finer(" Inserted " + tmpVector.get(j) + " from vector into position " + i2);
            ++i2;
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToBeforeAnotherNode(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode top, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(top, 0);
        MxNode firstDev = null;
        MxNode secondDev = null;
        for (i = topologyTree.getIndex(top); i > 0; --i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i - 1);
            try {
                firstDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)first.getUserObject()).intValue());
                secondDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)second.getUserObject()).intValue());
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getTopNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.insertElementAt(second, 0);
            rackTopologyDebug.finer("17 Added node " + second.toString() + " to the tmp vector");
        }
        i = topologyTree.getIndex(childNode);
        for (int j = 0; j < tmpVector.size(); ++j) {
            try {
                topologyTree.insert((MutableTreeNode)tmpVector.get(j), i);
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
                rackTopologyDebug.exception((Throwable)e);
                rackTopologyDebug.finer("Exception:moveNodeAndOtherNeighborsToBeforeAnotherNode()" + e);
            }
            ++i;
        }
        return topologyTree;
    }

    public boolean doesTreeNodeExist(DefaultMutableTreeNode childNode, DefaultMutableTreeNode topologyTree) {
        int treeCount = topologyTree.getChildCount();
        for (int i = 0; i < treeCount; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            if (tmp == null || childNode == null || !tmp.toString().equals(childNode.toString())) continue;
            rackTopologyDebug.finer("DOES TREE NODE Exist : Yes, and the tree node at " + i + " is " + tmp.toString());
            return true;
        }
        return false;
    }

    public int getIndex(DefaultMutableTreeNode childNode, DefaultMutableTreeNode topologyTree) {
        int treeCount = topologyTree.getChildCount();
        for (int i = 0; i < treeCount; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            if (tmp == null || childNode == null || !tmp.toString().equals(childNode.toString())) continue;
            rackTopologyDebug.finer("INDEX of childNode " + childNode.toString() + " is " + i);
            return i;
        }
        return -1;
    }

    public DefaultMutableTreeNode removeBladeFromTopology(int deviceKey, DefaultMutableTreeNode topologyTree) {
        if (topologyTree != null) {
            int treeCount = topologyTree.getChildCount();
            int treeChildDeviceKey = -1;
            for (int i = 0; i < treeCount; ++i) {
                treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)topologyTree.getChildAt(i)).getUserObject();
                if (treeChildDeviceKey != deviceKey) continue;
                topologyTree.remove(i);
                try {
                    this.myNodeRelationshipManager.reLoadDeviceAssociations(deviceKey);
                }
                catch (Exception e) {}
                break;
            }
        }
        TableModelHandler.notifyViewTopoHasChanged();
        return topologyTree;
    }

    public void printDebugTreeInformation(NodeAssociationsManager myNodeAssociationsManager, DefaultMutableTreeNode topologyTree, int deviceKey) {
        if (containerDeviceDebug.check(5)) {
            try {
                if (topologyTree != null) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"\n\n");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("                TOPOLOGY TREE    - for " + deviceKey));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    MxNode dev3 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)((DefaultMutableTreeNode)topologyTree.getRoot()).getUserObject());
                    if (dev3 != null) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("----- " + dev3.getNameString() + "   (" + (Integer)((DefaultMutableTreeNode)topologyTree.getRoot()).getUserObject() + ")"));
                        int treeCount = topologyTree.getChildCount();
                        for (int i = 0; i < treeCount; ++i) {
                            MxNode dev1;
                            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
                            if (childNode == null || (dev1 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)childNode.getUserObject())) == null) continue;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"  |   ");
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----- " + dev1.getNameString() + "   (" + (Integer)childNode.getUserObject() + ") at Index : " + i));
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----------- Top Neighbor : " + myNodeAssociationsManager.getNodeAssociations(dev1.getDeviceKey()).getTopNeighborDeviceKey()));
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----------- Bot Neighbor : " + myNodeAssociationsManager.getNodeAssociations(dev1.getDeviceKey()).getBottomNeighborDeviceKey()));
                            for (int j = 0; j < childNode.getChildCount(); ++j) {
                                MxNode dev2;
                                DefaultMutableTreeNode childNode2 = (DefaultMutableTreeNode)childNode.getChildAt(j);
                                if (childNode2 == null || (dev2 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)childNode2.getUserObject())) == null) continue;
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"    |     ");
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("     ----- " + dev2.getNameString() + "   (" + (Integer)childNode2.getUserObject() + ")"));
                            }
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"\n\n");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"         END  TOPOLOGY TREE              ");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    public String validateName(String nameToValidate) {
        if (nameToValidate.indexOf(32) != -1) {
            nameToValidate = nameToValidate.replace(' ', '_');
        }
        return nameToValidate;
    }
}

