/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpSm2MibHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Iterator;
import java.util.List;

public class RiloeAssociationDataHandler
extends SnmpSm2MibHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(RiloeAssociationDataHandler.class);

    public RiloeAssociationDataHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        int ribLoc;
        block19: {
            String workingAddress;
            int associatedDeviceKey;
            block18: {
                LOGGER.enter("RiloAssociationDataHandler.getAssociationData" + d.getDeviceKey() + "," + idInfo);
                LOGGER.fine("RiloAssociationDataHandler.getAssociationData ModelName :" + d.getModel().toLowerCase() + "for" + d.getDeviceKey());
                if (AssociationHandlerConstants.isHPSystem()) {
                    return;
                }
                ribLoc = 0;
                String theRibSerialNo = null;
                String systemUuid = null;
                associatedDeviceKey = 0;
                LOGGER.fine("IN The RILOEASSOCIATIONDATAHANDLER....");
                if (!d.getDeviceType().equals("MgmtProc") || d.getModel().toLowerCase().indexOf("integrated lights-out") != -1 || d.getModel().toLowerCase().indexOf("remote insight lights-out edition ii") != -1) {
                    LOGGER.fine("RiloAssociationDataHandler.getAssociationData : model does not match " + d.getDeviceKey());
                    LOGGER.fine("RiloAssociationDataHandler cleaning up the associations");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The RILOEASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                    this.cleanUpAssociationData(d);
                    return;
                }
                String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
                if (!snmpEnabled.equals("checked")) {
                    LOGGER.fine("Riloe Association skipped (SNMP DISABLED GLOBALLY) on " + d.getNameString());
                    return;
                }
                if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                    LOGGER.fine("Riloe Association skipped ; snmp not detected on " + d.getNameString());
                    return;
                }
                LOGGER.fine("IN The RILOEASSOCIATIONDATAHANDLER.... - Getting the new associations");
                workingAddress = d.getWorkingAddress();
                if (workingAddress == null) {
                    LOGGER.fine("RiloeAssociationDataHandler : Working Address is null for device : " + d.getNameString());
                    return;
                }
                if (this.isThisDeviceAnIloRiloe()) {
                    LOGGER.fine("IN The RILOEASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                    this.cleanUpAssociationData(d);
                    return;
                }
                ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
                LOGGER.fine("RILOEASSOCIATIONDATAHANDLER ribLoc:" + ribLoc);
                boolean hasARib = d.checkMibStatusArrayForMib(9);
                LOGGER.fine("RILOEASSOCIATIONDATAHANDLER hasARib:" + hasARib);
                if (!hasARib) break block18;
                if (ribLoc != 2 && ribLoc != 3) break block19;
                theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
                LOGGER.fine("RILOEASSOCIATIONDATAHANDLER theRibSerialNo:" + theRibSerialNo + ":" + d.getDeviceKey());
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    theRibSerialNo = " + theRibSerialNo));
                }
                systemUuid = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.11.2.10.3.0[1]", true);
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    systemUuid = " + systemUuid));
                }
                if (systemUuid != null && this.isValidUuid(systemUuid)) {
                    MxNode hostServer = null;
                    try {
                        hostServer = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(systemUuid);
                    }
                    catch (MxUndefinedNodeException ex) {
                        hostServer = null;
                    }
                    if (hostServer != null) {
                        associatedDeviceKey = hostServer.getDeviceKey();
                        LOGGER.fine("RILOEASSOCIATIONDATAHANDLER..... The associated device key (via UUID): " + associatedDeviceKey + " for RIB " + d.getNameString());
                    }
                }
                if (associatedDeviceKey == 0) {
                    String theCpqSiSysSerialNo = null;
                    LOGGER.fine("theCpqSiSysSerialNo:" + theCpqSiSysSerialNo + ":" + d.getDeviceKey());
                    theCpqSiSysSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.2.2.2.1.0[1]", true);
                    LOGGER.fine("theCpqSiSysSerialNo = " + theCpqSiSysSerialNo);
                    if (theCpqSiSysSerialNo != null && theCpqSiSysSerialNo.trim().length() > 0) {
                        associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theCpqSiSysSerialNo);
                        LOGGER.fine("RILOEASSOCIATIONDATAHANDLER :associatedDeviceKey:" + associatedDeviceKey + "for device " + d.getNameString());
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    RILOEASSOCIATIONDATAHANDLER..... The associated device key : " + associatedDeviceKey + " for device " + d.getNameString()));
                        }
                    }
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    associatedDeviceKey = " + associatedDeviceKey));
                }
                if (associatedDeviceKey == 0) break block19;
                LOGGER.fine("make assc MgmtProcToServer_Rib for :" + d.getDeviceKey() + "and" + associatedDeviceKey);
                this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Rib", true);
                this.myNodeRelationships.setParent(associatedDeviceKey);
                this.myNodeRelationships.setInContainer(true);
                break block19;
            }
            List listOfAssociatedDeviceKeys = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("compaq.Devices.associatedIpAddress", workingAddress);
            Iterator iter = listOfAssociatedDeviceKeys.iterator();
            while (iter.hasNext()) {
                associatedDeviceKey = (Integer)iter.next();
                LOGGER.fine("associatedDeviceKey:" + associatedDeviceKey);
                if (associatedDeviceKey == 0) continue;
                LOGGER.fine("make assc MgmtProcToServer_Rib for :" + d.getDeviceKey() + "and" + associatedDeviceKey);
                this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Rcc", true);
                this.myNodeRelationships.setParent(associatedDeviceKey);
                this.myNodeRelationships.setInContainer(true);
            }
        }
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("    SnmpDevId " + d.getNameString() + " rib " + ribLoc));
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
    }

    private boolean isValidUuid(String systemUuid) {
        systemUuid = systemUuid.trim();
        try {
            Integer intUuid = new Integer(systemUuid);
            if (intUuid == 0) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return true;
        }
        return false;
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(device.getDeviceKey(), true);
        if (device != null && device.getDeviceType().equals("MgmtProc")) {
            na = AssociationHandlerUtil.loadAssocFrmDB(device.getDeviceKey(), this.myNodeRelationshipManager);
        }
        return na;
    }

    public void setAssociationType(String associationType) {
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        myAssoc.setParent(node2.getDeviceKey());
        myAssoc.setInContainer(true);
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rib");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rcc");
    }

    public boolean isThisDeviceAnIloRiloe() {
        LOGGER.fine("RILOASSOCIATIONDATAHANDLER:isThisDeviceAnIloRiloe ");
        int isThisAnIloRiloe = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true);
        return isThisAnIloRiloe == 5 || isThisAnIloRiloe == 6 || isThisAnIloRiloe == 7;
    }
}

