/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WorkstationServerHandler
extends SnmpRackMibHandler {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private String associationType = "";

    public WorkstationServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"WorkStationHandler.getAssociationData()");
            log_.debug((Object)(" d.getNameString():" + d.getNameString()));
        }
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        int ribLoc = 0;
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The WorkstationServerHandler.... for device " + d.getNameString() + " And product type " + d.getDeviceType()));
        }
        if (!d.getDeviceType().equals("Workstation")) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The WorkstationServerHandler.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("WorkstationServerHandler Server Association skipped (SNMP DISABLED GLOBALLY) on " + d.getNameString()));
            return;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("WorkstationServerHandler Server Association skipped ; snmp not detected on " + d.getNameString()));
            return;
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The WorkstationServerHandler.... - Getting the new associations");
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("WorkstationServerHandler : Working Address is null for device : " + d.getNameString()));
            }
            return;
        }
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("WorkstationServerHandler....After getting rib location  " + ribLoc + " for device " + d.getNameString()));
        }
        int doesThisHaveEnclosureMgmt = 0;
        try {
            block34: {
                if (ribLoc == 1) {
                    this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.2[0],1.3.6.1.4.1.232.2.2.13.1.1.6[1]");
                    boolean endOfTable = false;
                    String typeResponseOID = null;
                    String serialNoResponseOID = null;
                    while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                        Thread.sleep(100L);
                    }
                    while (!endOfTable) {
                        SnmpResponseVarBind vb2;
                        this.snmpPdh.snmpReq.SnmpGetNext();
                        SnmpResponse curResp = this.snmpPdh.snmpReq.getResponseVarbinds();
                        SnmpResponseVarBind vb = curResp.findById(0);
                        if (vb == null || vb.isError()) break;
                        typeResponseOID = vb.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The TYPE RESPONSE OID : " + typeResponseOID));
                        }
                        if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
                        serialNoResponseOID = vb2.getOid();
                        if (containerDeviceDebug.check(45)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The SERIAL no. RESPONSE OID : " + serialNoResponseOID));
                        }
                        if (!typeResponseOID.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.2.")) break;
                        doesThisHaveEnclosureMgmt = vb.getIntValue();
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Value returned from type OID : " + doesThisHaveEnclosureMgmt));
                        }
                        if (doesThisHaveEnclosureMgmt == 2) {
                            this.getRackAttributesFromTheMib();
                            this.getCommonEnclosureAttributesAndTopologyFromTheMib();
                            this.getServerEnclosureAttributesFromTheMib();
                            this.getServerBladeAttributesFromTheMib(false, null);
                            this.getSwitchAttributesFromTheMib();
                            this.doRackEnclosureDeviceProcessing(d);
                            this.doWorkstationIloDeviceProcessing(d);
                            break;
                        }
                        this.snmpPdh.snmpReq.clearSnmpReqInfo();
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(typeResponseOID, "0");
                        this.snmpPdh.snmpReq.addSnmpGetVarbind(serialNoResponseOID, "1");
                    }
                }
                int rackDevKey = 0;
                int enclDevKey = 0;
                String rackName = "";
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"WorkstationServerHandler ....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
                    if (enclDevKey > 0) {
                        try {
                            enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getNameString();
                        }
                        catch (MxUndefinedNodeException ex) {
                            // empty catch block
                        }
                        rackDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclDevKey, "EnclosureToRack");
                        if (rackDevKey > 0) {
                            try {
                                rackName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey).getNameString();
                            }
                            catch (MxUndefinedNodeException ex1) {
                                // empty catch block
                            }
                        }
                        d.setEnclosureName(enclName);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                        break block34;
                    }
                    if (this.myNodeRelationships.inContainer()) {
                        MxNode encl;
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("device " + d.getNameString() + " thinks it's in an enclosure, but we have nothing for it - fix that"));
                        }
                        if ((encl = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure")) != null) {
                            NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(encl.getDeviceKey());
                            if (theEnclNodeAssociations != null) {
                                DefaultMutableTreeNode topologyTree = theEnclNodeAssociations.getContainerDeviceTree();
                                topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                                theEnclNodeAssociations.setContainerDeviceTree(topologyTree);
                                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                            }
                            this.myNodeRelationshipManager.update(this.myNodeRelationships);
                        }
                    }
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Done trying to find associations for SERVER : " + d.getNameString()));
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            NodeAssociationsManager.releaseWriteLock();
        }
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        log_.debug((Object)("WorkStationServerHandler.loadAssociationDataFromDb(" + device + ")"));
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(device.getDeviceKey(), true);
        if (device != null && device.getDeviceType().equals("Workstation")) {
            na = AssociationHandlerUtil.loadAssocFrmDB(device.getDeviceKey(), this.myNodeRelationshipManager);
        }
        log_.debug((Object)("WorkStationServerHandler.loadAssociationDataFromDb(" + device + ")"));
        return na;
    }

    public void doRackEnclosureDeviceProcessing(MxNode d) {
        log_.debug((Object)" workstaion handler: doRackEnclosureDeviceProcessing");
        log_.debug((Object)(" d.getNameString():" + d.getNameString()));
        try {
            Vector enclosureInfo;
            String enclSerNo = null;
            if (this.getTopology().size() > 0 && (enclosureInfo = (Vector)this.getTopology().elementAt(this.getServerEnclosureIndex())) != null) {
                enclSerNo = (String)enclosureInfo.elementAt(8);
            }
            if (enclSerNo != null && !enclSerNo.equals("")) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : In rackEnclosure Device Processing");
                log_.debug((Object)(" getBladeSlot():" + this.getBladeSlot()));
                log_.debug((Object)("getBladeSlotsUsedXDir():" + this.getBladeSlotsUsedXDir()));
                log_.debug((Object)("getBladeSlotsUsedYDir():" + this.getBladeSlotsUsedYDir()));
                this.myNodeRelationships.setSlotNumber(this.getBladeSlot());
                this.myNodeRelationships.setMmHeight(this.getBladeHeight());
                this.myNodeRelationships.setMmWidth(this.getBladeWidth());
                this.myNodeRelationships.setMmDepth(this.getBladeDepth());
                this.myNodeRelationships.setNumBladeSlotsUsed(this.getBladeSlotsUsed());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(this.getBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(this.getBladeSlotsUsedYDir());
                this.myNodeRelationships.setSource(this.associationType);
                this.myNodeRelationships.setSwitchApis(this.getSwitchesPresent());
                log_.debug((Object)("myNodeRelationships.getSlotNumber():" + this.myNodeRelationships.getSlotNumber()));
                log_.debug((Object)("myNodeRelationships.getNumBladeSlotsUsedXDir():" + this.myNodeRelationships.getNumBladeSlotsUsedXDir()));
                log_.debug((Object)("myNodeRelationships.getNumBladeSlotsUsedYDir():" + this.myNodeRelationships.getNumBladeSlotsUsedYDir()));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Finished storing blade attributes");
                NodeAssociations theEnclNodeAssociations = null;
                if (this.getServerEnclosureIndex() != -1) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : Before storing enclosure information");
                    theEnclNodeAssociations = this.getEnclosureInformation((Vector)this.getTopology().elementAt(this.getServerEnclosureIndex()), this.getRackName(), this.getRuid());
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"ServerADH : after storing enclosure and rack information");
                    if (theEnclNodeAssociations != null) {
                        int myDeviceKey = this.device.getDeviceKey();
                        int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("The encl device is " + theEnclDeviceKey));
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Slot number for myNodeRelationships in storeenclosureinformation is " + this.myNodeRelationships.getSlotNumber()));
                        if (this.myNodeRelationships.getSlotNumber() != -1) {
                            this.removeOldAssociationsFromThisSlot(myDeviceKey, theEnclDeviceKey);
                            if (this.device.getDeviceType().equals("Workstation")) {
                                this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "ServerToEnclosure", false);
                            }
                            this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                            this.myNodeRelationships.setInContainer(true);
                            this.myNodeRelationships.setParent(theEnclDeviceKey);
                        }
                        theEnclNodeAssociations.setMaxNumItems(this.getMaxNumBlades());
                        theEnclNodeAssociations.setSwitchApis(this.getSwitchesPresent());
                        theEnclNodeAssociations.setMaxNumItemsXDir(this.getMaxNumBladesXDir());
                        theEnclNodeAssociations.setMaxNumItemsYDir(this.getMaxNumBladesYDir());
                        theEnclNodeAssociations.setSource("Enclosure");
                        this.getRackInformation(this.getRackName(), this.getRuid(), theEnclDeviceKey);
                        if (this.getTheRackDevice() != null) {
                            this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                            this.getTheRackDevice().setModel("Rack");
                        }
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    }
                }
                if (this.getRuid() != null) {
                    this.storeTopologyInformation(this.getTopology(), this.getRuid());
                }
            } else {
                MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
                if (dTmp != null) {
                    NodeAssociations dTmpNodeAssociations;
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("MIB shows server " + new Integer(d.getDeviceKey()) + " was not in enclosure - removing it from topology"));
                    }
                    if ((dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
                        DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
                        topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
                        dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
                        this.myNodeRelationshipManager.update(dTmpNodeAssociations);
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void doWorkstationIloDeviceProcessing(MxNode d) {
        String theRibSerialNo = null;
        int associatedDeviceKey = 0;
        try {
            List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), d.getAgentUUID());
            if (allDevicesWithThisProperty.size() > 0) {
                Iterator iter = allDevicesWithThisProperty.iterator();
                containerDeviceDebug.fine("Size of the associated devices iteration : " + allDevicesWithThisProperty.size());
                while (iter.hasNext()) {
                    Integer assocDeviceKey = (Integer)iter.next();
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)(" Adding association for device keys : " + assocDeviceKey + " and " + d.getDeviceKey()));
                    this.myNodeRelationships.setTheAssociation(assocDeviceKey.intValue(), d.getDeviceKey(), "MgmtProcToServer_Ilo", true);
                    NodeAssociations mpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(assocDeviceKey.intValue());
                    if (mpNodeAssociations == null) {
                        mpNodeAssociations = new NodeAssociations(assocDeviceKey.intValue());
                    }
                    mpNodeAssociations.setInContainer(true);
                    mpNodeAssociations.setParent(d.getDeviceKey());
                    AssociationHandlerUtil.setILOAsscociatedAttributes(d, MxNodeController.getDefaultControllerNoEx().getNodeByKey(assocDeviceKey));
                }
            } else {
                theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
                if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0) {
                    int isThisIloRilo;
                    associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theRibSerialNo);
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("SERVERASSOCIATIONDATAHANDLER..... The associated device key : " + associatedDeviceKey + " for device " + d.getNameString()));
                    }
                    if (associatedDeviceKey != 0 && ((isThisIloRilo = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true)) == 5 || isThisIloRilo == 6)) {
                        this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Ilo", true);
                        NodeAssociations mpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(associatedDeviceKey);
                        if (mpNodeAssociations == null) {
                            mpNodeAssociations = new NodeAssociations(associatedDeviceKey);
                        }
                        mpNodeAssociations.setInContainer(true);
                        mpNodeAssociations.setParent(d.getDeviceKey());
                        AssociationHandlerUtil.setILOAsscociatedAttributes(d, MxNodeController.getDefaultControllerNoEx().getNodeByKey(associatedDeviceKey));
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rib");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Rcc");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }
}

